/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.peakeldb.io;

import com.almworks.sqlite4java.SQLiteConnection;
import com.almworks.sqlite4java.SQLiteStatement;
import fr.profi.mzdb.model.Peakel;
import fr.profi.mzdb.model.PeakelDataMatrix;
import fr.profi.mzdb.model.PeakelDataMatrix$;
import fr.profi.mzdb.model.SpectrumHeader;
import fr.profi.mzdb.peakeldb.model.PeakelTable$;
import fr.profi.util.collection.package;
import fr.profi.util.collection.package$;
import java.io.File;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.LongMap;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class PeakelDbWriter$ {
    public static PeakelDbWriter$ MODULE$;

    static {
        new PeakelDbWriter$();
    }

    /*
     * WARNING - void declaration
     */
    public SQLiteConnection initPeaklUpdate(File fileLocation) {
        void var2_2;
        SQLiteConnection connection = new SQLiteConnection(fileLocation);
        connection.open(true);
        connection.exec("PRAGMA synchronous=OFF;");
        connection.exec("PRAGMA journal_mode=OFF;");
        connection.exec("PRAGMA temp_store=2;");
        connection.exec("PRAGMA cache_size=100000;");
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public SQLiteConnection initPeakelStore(File fileLocation) {
        void var2_2;
        SQLiteConnection connection = new SQLiteConnection(fileLocation);
        connection.open(true);
        connection.exec("PRAGMA synchronous=OFF;");
        connection.exec("PRAGMA journal_mode=OFF;");
        connection.exec("PRAGMA temp_store=2;");
        connection.exec("PRAGMA cache_size=100000;");
        String ddlQuery = "\r\nCREATE TABLE peakeldb_file (\r\n                id INTEGER NOT NULL,\r\n                name VARCHAR NOT NULL,\r\n                description VARCHAR,\r\n                raw_file_name VARCHAR NOT NULL,\r\n                is_dia_experiment BOOLEAN NOT NULL,\r\n                creation_timestamp TIMESTAMP NOT NULL,\r\n                modification_timestamp TIMESTAMP NOT NULL,\r\n                serialized_properties CLOB,\r\n                CONSTRAINT peakeldb_file_pk PRIMARY KEY (id)\r\n);\r\n\r\nCREATE TABLE lcms_map (\r\n                id INTEGER NOT NULL,\r\n                ms_level INTEGER NOT NULL,\r\n                peakel_count INTEGER NOT NULL,\r\n                serialized_properties CLOB,\r\n                peakeldb_file_id INTEGER NOT NULL,\r\n                CONSTRAINT lcms_map_pk PRIMARY KEY (id),\r\n                CONSTRAINT peakeldb_file_lcms_map_fk FOREIGN KEY (peakeldb_file_id) REFERENCES peakeldb_file (id)\r\n);\r\n\r\nCREATE TABLE lcms_map_relation (\r\n                parent_lcms_map_id INTEGER NOT NULL,\r\n                child_lcms_map_id INTEGER NOT NULL,\r\n                min_parent_mz REAL NOT NULL,\r\n                max_parent_mz REAL NOT NULL,\r\n                CONSTRAINT lcms_map_relation_pk PRIMARY KEY (parent_lcms_map_id, child_lcms_map_id)\r\n                CONSTRAINT lcms_map_lcms_map_relation_fk1 FOREIGN KEY (parent_lcms_map_id) REFERENCES lcms_map (id)\r\n                CONSTRAINT lcms_map_lcms_map_relation_fk2 FOREIGN KEY (child_lcms_map_id) REFERENCES lcms_map (id)\t\t\r\n);\r\n\r\nCREATE TABLE peakel (\r\n                id INTEGER NOT NULL,\r\n                moz DOUBLE NOT NULL,\r\n                elution_time REAL NOT NULL,\r\n                duration REAL NOT NULL,\r\n                gap_count INTEGER NOT NULL,\r\n                apex_intensity REAL NOT NULL,\r\n                area REAL NOT NULL,\r\n                amplitude REAL NOT NULL,\r\n                intensity_cv REAL NOT NULL,\r\n                left_hwhm_mean REAL,\r\n                left_hwhm_cv REAL,\r\n                right_hwhm_mean REAL,\r\n                right_hwhm_cv REAL,\r\n                is_interfering BOOLEAN NOT NULL,\r\n                peak_count INTEGER NOT NULL,\r\n                peaks BLOB NOT NULL,\r\n                serialized_properties CLOB,\r\n                first_spectrum_id INTEGER NOT NULL,\r\n                apex_spectrum_id INTEGER NOT NULL,\r\n                last_spectrum_id INTEGER NOT NULL,\r\n                map_id INTEGER NOT NULL,\r\n                CONSTRAINT peakel_pk PRIMARY KEY (id)\r\n                CONSTRAINT lcms_map_peakel_fk FOREIGN KEY (map_id) REFERENCES lcms_map (id)\r\n);\r\n\r\nCREATE INDEX peakel_map_idx ON peakel ( map_id );\r\n\r\nCREATE TABLE peakel_rtree (\r\n                id INTEGER NOT NULL,\r\n                min_lcms_map_id INTEGER NOT NULL,\r\n                max_lcms_map_id INTEGER NOT NULL,\r\n                min_mz REAL NOT NULL,\r\n                max_mz REAL NOT NULL,\r\n                min_time REAL NOT NULL,\r\n                max_time REAL NOT NULL,\r\n                CONSTRAINT peakel_rtree_pk PRIMARY KEY (id)\r\n                CONSTRAINT peakel_peakel_rtree_fk FOREIGN KEY (id) REFERENCES peakel (id)\r\n);\r\n\r\n";
        connection.exec(ddlQuery);
        connection.exec("BEGIN TRANSACTION;");
        SQLiteStatement peakelDbFileStmt = connection.prepare(new StringBuilder(35).append("INSERT INTO peakeldb_file VALUES (").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Array$.MODULE$.fill(8, (Function0 & Serializable & scala.Serializable)() -> "?", ClassTag$.MODULE$.apply(String.class)))).mkString(",")).append(")").toString());
        peakelDbFileStmt.bind(1, 1);
        peakelDbFileStmt.bind(2, "no name");
        peakelDbFileStmt.bindNull(3);
        peakelDbFileStmt.bind(4, "no name");
        peakelDbFileStmt.bind(5, 1);
        peakelDbFileStmt.bind(6, new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        peakelDbFileStmt.bind(7, new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        peakelDbFileStmt.bindNull(8);
        peakelDbFileStmt.step();
        SQLiteStatement lcmsMapStmt = connection.prepare(new StringBuilder(30).append("INSERT INTO lcms_map VALUES (").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Array$.MODULE$.fill(5, (Function0 & Serializable & scala.Serializable)() -> "?", ClassTag$.MODULE$.apply(String.class)))).mkString(",")).append(")").toString());
        lcmsMapStmt.bind(1, 1);
        lcmsMapStmt.bind(2, 1);
        lcmsMapStmt.bind(3, 0);
        lcmsMapStmt.bindNull(4);
        lcmsMapStmt.bind(5, 1);
        lcmsMapStmt.step();
        connection.exec("COMMIT TRANSACTION;");
        return var2_2;
    }

    public void storePeakelsInPeakelDB(SQLiteConnection sqliteConn, Peakel[] peakels, SpectrumHeader[] ms1SpecHeaders) {
        LongMap initialIdByMzDbSpecId = package.LongMapBuilderFromTraversableOnce$.MODULE$.toLongMapWith$extension(package$.MODULE$.array2longMapBuilder((Object)ms1SpecHeaders), (Function1 & Serializable & scala.Serializable)sh -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)sh.getId())), (Object)BoxesRunTime.boxToInteger((int)sh.getInitialId())));
        LongMap cycleByMzDbSpecId = package.LongMapBuilderFromTraversableOnce$.MODULE$.toLongMapWith$extension(package$.MODULE$.array2longMapBuilder((Object)ms1SpecHeaders), (Function1 & Serializable & scala.Serializable)sh -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)sh.getId())), (Object)BoxesRunTime.boxToInteger((int)sh.getCycle())));
        sqliteConn.exec("BEGIN TRANSACTION;");
        SQLiteStatement peakelStmt = sqliteConn.prepare(new StringBuilder(28).append("INSERT INTO peakel VALUES (").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Array$.MODULE$.fill(21, (Function0 & Serializable & scala.Serializable)() -> "?", ClassTag$.MODULE$.apply(String.class)))).mkString(",")).append(")").toString());
        SQLiteStatement peakelIndexStmt = sqliteConn.prepare(new StringBuilder(34).append("INSERT INTO peakel_rtree VALUES (").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Array$.MODULE$.fill(7, (Function0 & Serializable & scala.Serializable)() -> "?", ClassTag$.MODULE$.apply(String.class)))).mkString(",")).append(")").toString());
        try {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])peakels)).foreach((Function1 & Serializable & scala.Serializable)peakel -> {
                int[] scanInitialIds = (int[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(peakel.getSpectrumIds())).map((Function1)(JFunction1.mcIJ.sp & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)initialIdByMzDbSpecId.apply(x$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
                PeakelDataMatrix peakelMessage = peakel.toPeakelDataMatrix();
                byte[] peakelMessageAsBytes = PeakelDataMatrix$.MODULE$.pack(peakelMessage);
                double peakelMz = peakel.getMz();
                float peakelTime = peakel.getApexElutionTime();
                int fieldNumber = 1;
                peakelStmt.bind(fieldNumber, peakel.id());
                peakelStmt.bind(++fieldNumber, peakelMz);
                peakelStmt.bind(++fieldNumber, (double)peakelTime);
                peakelStmt.bind(++fieldNumber, (double)peakel.calcDuration());
                peakelStmt.bind(++fieldNumber, peakel.calcGapCount((LongMap<Object>)cycleByMzDbSpecId));
                peakelStmt.bind(++fieldNumber, (double)peakel.getApexIntensity());
                peakelStmt.bind(++fieldNumber, (double)peakel.area());
                peakelStmt.bind(++fieldNumber, (double)peakel.calcAmplitude());
                peakelStmt.bind(++fieldNumber, (double)peakel.calcIntensityCv());
                peakelStmt.bind(++fieldNumber, (double)peakel.leftHwhmMean());
                peakelStmt.bind(++fieldNumber, (double)peakel.leftHwhmCv());
                peakelStmt.bind(++fieldNumber, (double)peakel.rightHwhmMean());
                peakelStmt.bind(++fieldNumber, (double)peakel.rightHwhmCv());
                peakelStmt.bind(++fieldNumber, 0);
                peakelStmt.bind(++fieldNumber, peakel.spectrumIds().length);
                peakelStmt.bind(++fieldNumber, peakelMessageAsBytes);
                peakelStmt.bindNull(++fieldNumber);
                peakelStmt.bind(++fieldNumber, BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(scanInitialIds)).head()));
                peakelStmt.bind(++fieldNumber, peakel.getApexSpectrumId());
                peakelStmt.bind(++fieldNumber, BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(scanInitialIds)).last()));
                peakelStmt.bind(++fieldNumber, 1);
                peakelStmt.step();
                peakelStmt.reset();
                fieldNumber = 1;
                peakelIndexStmt.bind(fieldNumber, peakel.id());
                peakelIndexStmt.bind(++fieldNumber, 1);
                peakelIndexStmt.bind(++fieldNumber, 1);
                peakelIndexStmt.bind(++fieldNumber, peakelMz);
                peakelIndexStmt.bind(++fieldNumber, peakelMz);
                peakelIndexStmt.bind(++fieldNumber, (double)peakelTime);
                peakelIndexStmt.bind(++fieldNumber, (double)peakelTime);
                peakelIndexStmt.step();
                return peakelIndexStmt.reset();
            });
        }
        finally {
            peakelStmt.dispose();
            peakelIndexStmt.dispose();
        }
        sqliteConn.exec("COMMIT TRANSACTION;");
    }

    public void updatePeakelsInPeakelDB(SQLiteConnection sqliteConn, Peakel[] peakels, Map<Object, Object> initialIdBySpectrumId) {
        sqliteConn.exec("BEGIN TRANSACTION;");
        SQLiteStatement peakelStmt = sqliteConn.prepare(new StringBuilder(59).append("UPDATE ").append(PeakelTable$.MODULE$.tableName()).append(" SET ").append(PeakelTable$.MODULE$.DURATION()).append(" = ?, ").append(PeakelTable$.MODULE$.PEAK_COUNT()).append(" = ?, ").append(PeakelTable$.MODULE$.PEAKS()).append(" = ?, ").append(PeakelTable$.MODULE$.FIRST_SPECTRUM_ID()).append(" = ?, ").append(PeakelTable$.MODULE$.APEX_INTENSITY()).append(" = ?,").append("  ").append(PeakelTable$.MODULE$.LAST_SPECTRUM_ID()).append(" = ?  WHERE ").append(PeakelTable$.MODULE$.ID()).append(" = ?").toString());
        try {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])peakels)).foreach((Function1 & Serializable & scala.Serializable)peakel -> {
                long[] scanInitialIds = (long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(peakel.getSpectrumIds())).map((Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)x$2 -> BoxesRunTime.unboxToLong((Object)initialIdBySpectrumId.apply((Object)BoxesRunTime.boxToLong((long)x$2))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()));
                PeakelDataMatrix peakelMessage = peakel.toPeakelDataMatrix();
                byte[] peakelMessageAsBytes = PeakelDataMatrix$.MODULE$.pack(peakelMessage);
                int fieldNumber = 1;
                peakelStmt.bind(fieldNumber, (double)peakel.calcDuration());
                peakelStmt.bind(++fieldNumber, peakel.spectrumIds().length);
                peakelStmt.bind(++fieldNumber, peakelMessageAsBytes);
                peakelStmt.bind(++fieldNumber, BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(scanInitialIds)).head()));
                peakelStmt.bind(++fieldNumber, peakel.getApexSpectrumId());
                peakelStmt.bind(++fieldNumber, BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(scanInitialIds)).last()));
                peakelStmt.bind(++fieldNumber, peakel.getId());
                peakelStmt.step();
                return peakelStmt.reset();
            });
        }
        finally {
            peakelStmt.dispose();
        }
        sqliteConn.exec("COMMIT TRANSACTION;");
    }

    private PeakelDbWriter$() {
        MODULE$ = this;
    }
}

