/*
 * Decompiled with CFR 0.152.
 */
package org.jsuffixarrays;

import java.util.Arrays;
import org.jsuffixarrays.ISuffixArrayBuilder;
import org.jsuffixarrays.Tools;

public final class Skew
implements ISuffixArrayBuilder {
    private static final boolean leq(int a1, int a2, int b1, int b2) {
        return a1 < b1 || a1 == b1 && a2 <= b2;
    }

    private static final boolean leq(int a1, int a2, int a3, int b1, int b2, int b3) {
        return a1 < b1 || a1 == b1 && Skew.leq(a2, a3, b2, b3);
    }

    private static final void radixPass(int[] src, int[] dst, int[] v, int vi, int n, int K, int start, int[] cnt) {
        int i;
        assert (cnt.length >= K + 1);
        Arrays.fill(cnt, 0, K + 1, 0);
        for (i = 0; i < n; ++i) {
            int n2 = v[start + vi + src[i]];
            cnt[n2] = cnt[n2] + 1;
        }
        int sum = 0;
        for (i = 0; i <= K; ++i) {
            int t = cnt[i];
            cnt[i] = sum;
            sum += t;
        }
        for (i = 0; i < n; ++i) {
            int n3 = v[start + vi + src[i]];
            int n4 = cnt[n3];
            cnt[n3] = n4 + 1;
            dst[n4] = src[i];
        }
    }

    static final int[] suffixArray(int[] s, int[] SA, int n, int K, int start, int[] cnt) {
        int i;
        int n0 = (n + 2) / 3;
        int n1 = (n + 1) / 3;
        int n2 = n / 3;
        int n02 = n0 + n2;
        int[] s12 = new int[n02 + 3];
        s12[n02 + 2] = 0;
        s12[n02 + 1] = 0;
        s12[n02] = 0;
        int[] SA12 = new int[n02 + 3];
        SA12[n02 + 2] = 0;
        SA12[n02 + 1] = 0;
        SA12[n02] = 0;
        int[] s0 = new int[n0];
        int[] SA0 = new int[n0];
        int j = 0;
        for (int i2 = 0; i2 < n + (n0 - n1); ++i2) {
            if (i2 % 3 == 0) continue;
            s12[j++] = i2;
        }
        cnt = Skew.ensureSize(cnt, K + 1);
        Skew.radixPass(s12, SA12, s, 2, n02, K, start, cnt);
        Skew.radixPass(SA12, s12, s, 1, n02, K, start, cnt);
        Skew.radixPass(s12, SA12, s, 0, n02, K, start, cnt);
        int name = 0;
        int c0 = -1;
        int c1 = -1;
        int c2 = -1;
        for (i = 0; i < n02; ++i) {
            if (s[start + SA12[i]] != c0 || s[start + SA12[i] + 1] != c1 || s[start + SA12[i] + 2] != c2) {
                ++name;
                c0 = s[start + SA12[i]];
                c1 = s[start + SA12[i] + 1];
                c2 = s[start + SA12[i] + 2];
            }
            if (SA12[i] % 3 == 1) {
                s12[SA12[i] / 3] = name;
                continue;
            }
            s12[SA12[i] / 3 + n0] = name;
        }
        if (name < n02) {
            cnt = Skew.suffixArray(s12, SA12, n02, name, start, cnt);
            for (i = 0; i < n02; ++i) {
                s12[SA12[i]] = i + 1;
            }
        } else {
            for (i = 0; i < n02; ++i) {
                SA12[s12[i] - 1] = i;
            }
        }
        int j2 = 0;
        for (i = 0; i < n02; ++i) {
            if (SA12[i] >= n0) continue;
            s0[j2++] = 3 * SA12[i];
        }
        Skew.radixPass(s0, SA0, s, 0, n0, K, start, cnt);
        int p = 0;
        int t = n0 - n1;
        for (int k = 0; k < n; ++k) {
            int i3 = SA12[t] < n0 ? SA12[t] * 3 + 1 : (SA12[t] - n0) * 3 + 2;
            int j3 = SA0[p];
            if (SA12[t] < n0 ? Skew.leq(s[start + i3], s12[SA12[t] + n0], s[start + j3], s12[j3 / 3]) : Skew.leq(s[start + i3], s[start + i3 + 1], s12[SA12[t] - n0 + 1], s[start + j3], s[start + j3 + 1], s12[j3 / 3 + n0])) {
                SA[k] = i3;
                if (++t != n02) continue;
                ++k;
                while (p < n0) {
                    SA[k] = SA0[p];
                    ++p;
                    ++k;
                }
                continue;
            }
            SA[k] = j3;
            if (++p != n0) continue;
            ++k;
            while (t < n02) {
                SA[k] = SA12[t] < n0 ? SA12[t] * 3 + 1 : (SA12[t] - n0) * 3 + 2;
                ++t;
                ++k;
            }
        }
        return cnt;
    }

    private static final int[] ensureSize(int[] tab, int length) {
        if (tab.length < length) {
            tab = null;
            tab = new int[length];
        }
        return tab;
    }

    @Override
    public int[] buildSuffixArray(int[] input, int start, int length) {
        Tools.assertAlways(input != null, "input must not be null");
        Tools.assertAlways(length >= 2, "input length must be >= 2");
        Tools.assertAlways(input.length >= start + length + 3, "no extra space after input end");
        assert (Tools.allPositive(input, start, length));
        int alphabetSize = Tools.max(input, start, length);
        int[] SA = new int[length + 3];
        int[] tail = new int[3];
        System.arraycopy(input, start + length, tail, 0, 3);
        Arrays.fill(input, start + length, start + length + 3, 0);
        Skew.suffixArray(input, SA, length, alphabetSize, start, new int[alphabetSize + 2]);
        System.arraycopy(tail, 0, input, start + length, 3);
        return SA;
    }
}

