/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.db.model;

import fr.profi.mzdb.db.model.AbstractTableModel;
import fr.profi.mzdb.db.model.params.FileContentParams;
import fr.profi.mzdb.db.model.params.ParamTree;
import fr.profi.mzdb.serialization.SerializationInterface;
import fr.profi.mzdb.serialization.SerializationReader;
import fr.profi.mzdb.serialization.SerializationWriter;
import java.io.IOException;

public class MzDbHeader
extends AbstractTableModel
implements SerializationInterface {
    public static final String TABLE_NAME = "mzdb";
    protected String version;
    protected int creationTimestamp;
    protected FileContentParams fileContent;

    public MzDbHeader(SerializationReader reader) throws IOException {
        this.read(reader);
    }

    public MzDbHeader(String version, int creationTimestamp, ParamTree paramTree, FileContentParams fileContent) {
        super(1L, paramTree);
        this.version = version;
        this.creationTimestamp = creationTimestamp;
        this.fileContent = fileContent;
    }

    public MzDbHeader(String version, int creationTimestamp) {
        this(version, creationTimestamp, null, null);
    }

    public String getVersion() {
        return this.version;
    }

    public FileContentParams getFileContent() {
        return this.fileContent;
    }

    @Override
    public void write(SerializationWriter writer) throws IOException {
        super.write(writer);
        writer.writeString(this.version);
        writer.writeInt32(this.creationTimestamp);
        boolean hasData = this.fileContent != null;
        writer.writeBoolean(hasData);
        if (hasData) {
            this.fileContent.write(writer);
        }
    }

    @Override
    public void read(SerializationReader reader) throws IOException {
        super.read(reader);
        this.version = reader.readString();
        this.creationTimestamp = reader.readInt32();
        boolean hasData = reader.readBoolean();
        this.fileContent = hasData ? new FileContentParams(reader) : null;
    }
}

