/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.io.reader;

import com.almworks.sqlite4java.SQLiteConnection;
import com.almworks.sqlite4java.SQLiteException;
import com.almworks.sqlite4java.SQLiteStatement;
import fr.profi.mzdb.util.sqlite.SQLiteQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MzDbReaderQueries {
    static final Logger logger = LoggerFactory.getLogger(MzDbReaderQueries.class);

    public static String getModelVersion(SQLiteConnection connection) throws SQLiteException {
        String sqlString = "SELECT version FROM mzdb LIMIT 1";
        return new SQLiteQuery(connection, sqlString).extractSingleString();
    }

    public static String getPwizMzDbVersion(SQLiteConnection connection) throws SQLiteException {
        String sqlString = "SELECT version FROM software WHERE name LIKE '%mzDB'";
        return new SQLiteQuery(connection, sqlString).extractSingleString();
    }

    public static float getLastTime(SQLiteConnection connection) throws SQLiteException {
        String sqlString = "SELECT time FROM spectrum ORDER BY id DESC LIMIT 1";
        return (float)new SQLiteQuery(connection, sqlString).extractSingleDouble();
    }

    public static int getMaxMsLevel(SQLiteConnection connection) throws SQLiteException {
        return new SQLiteQuery(connection, "SELECT max(ms_level) FROM run_slice").extractSingleInt();
    }

    public static int[] getMzRange(int msLevel, SQLiteConnection connection) throws SQLiteException {
        SQLiteStatement stmt = connection.prepare("SELECT min(begin_mz), max(end_mz) FROM run_slice WHERE ms_level=?");
        stmt.bind(1, msLevel);
        stmt.step();
        int minMz = stmt.columnInt(0);
        int maxMz = stmt.columnInt(1);
        stmt.dispose();
        int[] mzRange = new int[]{minMz, maxMz};
        return mzRange;
    }

    public static int getBoundingBoxesCount(SQLiteConnection connection) throws SQLiteException {
        return MzDbReaderQueries.getTableRecordsCount("bounding_box", connection);
    }

    public static int getBoundingBoxesCount(int runSliceId, SQLiteConnection connection) throws SQLiteException {
        String queryStr = "SELECT count(*) FROM bounding_box WHERE bounding_box.run_slice_id = ?";
        return new SQLiteQuery(connection, queryStr).bind(1, runSliceId).extractSingleInt();
    }

    public static int getCyclesCount(SQLiteConnection connection) throws SQLiteException {
        String queryStr = "SELECT max(cycle) FROM spectrum";
        return new SQLiteQuery(connection, queryStr).extractSingleInt();
    }

    public static int getDataEncodingsCount(SQLiteConnection connection) throws SQLiteException {
        return MzDbReaderQueries.getTableRecordsCount("data_encoding", connection);
    }

    public static int getSpectraCount(SQLiteConnection connection) throws SQLiteException {
        return MzDbReaderQueries.getTableRecordsCount("spectrum", connection);
    }

    public static int getSpectraCount(int msLevel, SQLiteConnection connection) throws SQLiteException {
        String queryStr = "SELECT count(*) FROM spectrum WHERE ms_level = ?";
        return new SQLiteQuery(connection, queryStr).bind(1, msLevel).extractSingleInt();
    }

    public static int getRunSlicesCount(SQLiteConnection connection) throws SQLiteException {
        return MzDbReaderQueries.getTableRecordsCount("run_slice", connection);
    }

    public static int getTableRecordsCount(String tableName, SQLiteConnection connection) throws SQLiteException {
        return new SQLiteQuery(connection, "SELECT seq FROM sqlite_sequence WHERE name = ?").bind(1, tableName).extractSingleInt();
    }

    public static byte[] getBoundingBoxData(int bbId, SQLiteConnection connection) throws SQLiteException {
        String sqlString = "SELECT data FROM bounding_box WHERE bounding_box.id = ?";
        return new SQLiteQuery(connection, sqlString).bind(1, bbId).extractSingleBlob();
    }

    public static long getBoundingBoxFirstSpectrumId(long spectrumId, SQLiteConnection connection) throws SQLiteException {
        String sqlString = "SELECT bb_first_spectrum_id FROM spectrum WHERE id = ?";
        return new SQLiteQuery(connection, sqlString).bind(1, spectrumId).extractSingleLong();
    }

    public static float getBoundingBoxMinMz(int bbId, SQLiteConnection connection) throws SQLiteException {
        String sqlString = "SELECT min_mz FROM bounding_box_rtree WHERE bounding_box_rtree.id = ?";
        return (float)new SQLiteQuery(connection, sqlString).bind(1, bbId).extractSingleDouble();
    }

    public static float getBoundingBoxMinTime(int bbId, SQLiteConnection connection) throws SQLiteException {
        String sqlString = "SELECT min_time FROM bounding_box_rtree WHERE bounding_box_rtree.id = ?";
        return (float)new SQLiteQuery(connection, sqlString).bind(1, bbId).extractSingleDouble();
    }

    public static int getBoundingBoxMsLevel(int bbId, SQLiteConnection connection) throws SQLiteException {
        String sqlString1 = "SELECT run_slice_id FROM bounding_box WHERE id = ?";
        int runSliceId = new SQLiteQuery(connection, sqlString1).bind(1, bbId).extractSingleInt();
        String sqlString2 = "SELECT ms_level FROM run_slice WHERE run_slice.id = ?";
        return new SQLiteQuery(connection, sqlString2).bind(1, runSliceId).extractSingleInt();
    }
}

