/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.io.writer;

import fr.profi.mzdb.model.DataEncoding;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

class DataEncodingRegistry {
    HashMap<String, DataEncoding> dataEncodingMap = new HashMap();
    private long id = 1L;

    DataEncodingRegistry() {
    }

    public DataEncoding getOrAddDataEncoding(DataEncoding de) {
        String key = de.getMode().name() + de.getPeakEncoding().name();
        if (this.dataEncodingMap.containsKey(key)) {
            return this.dataEncodingMap.get(key);
        }
        DataEncoding newDe = new DataEncoding(this.id++, de.getMode(), de.getPeakEncoding(), de.getCompression(), de.getByteOrder());
        this.dataEncodingMap.put(key, newDe);
        return newDe;
    }

    public List<DataEncoding> getDistinctDataEncoding() {
        ArrayList<DataEncoding> distinctDE = new ArrayList<DataEncoding>();
        distinctDE.addAll(this.dataEncodingMap.values());
        distinctDE.sort((o1, o2) -> {
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            if (o1.getId() < o2.getId()) {
                return -1;
            }
            if (o1.getId() == o2.getId()) {
                return 0;
            }
            return 1;
        });
        return distinctDE;
    }
}

