/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.datatypes;

import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import umich.ms.datatypes.LCMSRange;
import umich.ms.util.DoubleRange;

public class LCMSRangeSet
implements Serializable {
    private static final long serialVersionUID = -2254401763909842422L;
    RangeSet<Integer> anyLvlSet = TreeRangeSet.create();
    Map<Integer, MsLevelRangeSet> lvlMap = new TreeMap<Integer, MsLevelRangeSet>();

    public void add(LCMSRange range) {
        Integer msLevel = range.getMsLevel();
        DoubleRange mzRange = range.getMzRange();
        Range<Integer> scanRange = range.getScanRange();
        if (msLevel == null) {
            this.anyLvlSet.add(scanRange);
            for (Map.Entry<Integer, MsLevelRangeSet> lvlMapEntry : this.lvlMap.entrySet()) {
                MsLevelRangeSet msLevelRangeSet = lvlMapEntry.getValue();
                msLevelRangeSet.removeFromAll(range);
            }
            return;
        }
        TreeRangeSet scanRangeLeft = TreeRangeSet.create();
        scanRangeLeft.removeAll(this.anyLvlSet);
        if (scanRangeLeft.isEmpty()) {
            return;
        }
        MsLevelRangeSet msLvlRanges = this.lvlMap.get(msLevel);
        if (msLvlRanges == null) {
            msLvlRanges = new MsLevelRangeSet();
            this.lvlMap.put(msLevel, msLvlRanges);
        }
        if (mzRange == null) {
            msLvlRanges.anyPrecursorSet.addAll((RangeSet)scanRangeLeft);
            msLvlRanges.removeFromSpecific(range);
            return;
        }
        scanRangeLeft.removeAll(msLvlRanges.anyPrecursorSet);
        if (scanRangeLeft.isEmpty()) {
            return;
        }
        TreeRangeSet rangeSetForMzRange = msLvlRanges.rngMap.get(mzRange);
        if (rangeSetForMzRange == null) {
            rangeSetForMzRange = TreeRangeSet.create();
            msLvlRanges.rngMap.put(mzRange, (RangeSet<Integer>)rangeSetForMzRange);
        }
        rangeSetForMzRange.addAll((RangeSet)scanRangeLeft);
    }

    public void subtract(LCMSRangeSet other) {
        this.anyLvlSet.removeAll(other.anyLvlSet);
        for (Map.Entry<Integer, MsLevelRangeSet> lvlMapEntry : this.lvlMap.entrySet()) {
            Integer msLevel = lvlMapEntry.getKey();
            MsLevelRangeSet msLevelRangeSet = lvlMapEntry.getValue();
            msLevelRangeSet.anyPrecursorSet.removeAll(other.anyLvlSet);
            MsLevelRangeSet otherMsLevelRangeSet = other.lvlMap.get(msLevel);
            msLevelRangeSet.anyPrecursorSet.removeAll(otherMsLevelRangeSet.anyPrecursorSet);
            for (Map.Entry<DoubleRange, RangeSet<Integer>> rngMapEntry : msLevelRangeSet.rngMap.entrySet()) {
                RangeSet<Integer> otherRangeSetAtMsLevelForPrecursorRange;
                if (rngMapEntry.getValue().isEmpty()) continue;
                DoubleRange mzRange = rngMapEntry.getKey();
                RangeSet<Integer> rangeSet = rngMapEntry.getValue();
                rangeSet.removeAll(other.anyLvlSet);
                if (!rangeSet.isEmpty()) {
                    rangeSet.removeAll(otherMsLevelRangeSet.anyPrecursorSet);
                }
                if (rangeSet.isEmpty() || (otherRangeSetAtMsLevelForPrecursorRange = otherMsLevelRangeSet.rngMap.get(mzRange)) == null) continue;
                rangeSet.removeAll(otherRangeSetAtMsLevelForPrecursorRange);
            }
        }
    }

    public boolean isEmpty() {
        if (!this.anyLvlSet.isEmpty()) {
            return false;
        }
        for (Map.Entry<Integer, MsLevelRangeSet> lvlMapEntry : this.lvlMap.entrySet()) {
            MsLevelRangeSet msLevelRangeSet = lvlMapEntry.getValue();
            if (!msLevelRangeSet.anyPrecursorSet.isEmpty()) {
                return false;
            }
            for (Map.Entry<DoubleRange, RangeSet<Integer>> rngMapEntry : msLevelRangeSet.rngMap.entrySet()) {
                if (rngMapEntry.getValue().isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    protected class MsLevelRangeSet {
        RangeSet<Integer> anyPrecursorSet = TreeRangeSet.create();
        Map<DoubleRange, RangeSet<Integer>> rngMap = new HashMap<DoubleRange, RangeSet<Integer>>(3);

        public final void removeFromAll(LCMSRange range) {
            this.anyPrecursorSet.remove(range.getScanRange());
            this.removeFromSpecific(range);
        }

        public final void removeFromSpecific(LCMSRange range) {
            for (Map.Entry<DoubleRange, RangeSet<Integer>> rngMapEntry : this.rngMap.entrySet()) {
                RangeSet<Integer> rangeSet = rngMapEntry.getValue();
                rangeSet.remove(range.getScanRange());
            }
        }
    }
}

