/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.datatypes.lcmsrun;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import umich.ms.datatypes.lcmsrun.MsSoftware;
import umich.ms.datatypes.lcmsrun.OriginalFile;
import umich.ms.datatypes.scan.props.Instrument;

public class LCMSRunInfo
implements Serializable {
    private static final long serialVersionUID = -45967049048809479L;
    protected Map<String, Instrument> instruments = new HashMap<String, Instrument>(2);
    protected String defaultInstrumentID = null;
    protected Boolean isCentroided = null;
    protected boolean isDefaultExplicitlySet = false;
    protected Date date = null;
    protected List<MsSoftware> software = new ArrayList<MsSoftware>(5);
    protected List<OriginalFile> originalFiles = new ArrayList<OriginalFile>(1);

    public static LCMSRunInfo createDummyInfo() {
        LCMSRunInfo lcmsRunInfo = new LCMSRunInfo();
        lcmsRunInfo.addInstrument(Instrument.getDummy(), "ID_UNKNOWN");
        return lcmsRunInfo;
    }

    public Boolean isCentroided() {
        return this.isCentroided;
    }

    public void setCentroided(Boolean isCentroided) {
        this.isCentroided = isCentroided;
    }

    public void addInstrument(Instrument instrument, String id) {
        if (instrument == null || id == null) {
            throw new IllegalArgumentException("Instruemnt and ID must be non-null values.");
        }
        if (this.instruments.size() == 0) {
            this.defaultInstrumentID = id;
        } else if (this.instruments.size() > 0 && !this.isDefaultExplicitlySet) {
            this.unsetDefaultInstrument();
        }
        this.instruments.put(id, instrument);
    }

    public final void removeInstrument(String id) {
        this.instruments.remove(id);
        if (this.defaultInstrumentID != null && this.defaultInstrumentID.equals(id)) {
            this.unsetDefaultInstrument();
        }
    }

    public void removeInstrument(Instrument instrument) {
        String keyToDelete = null;
        for (Map.Entry<String, Instrument> stringInstrumentEntry : this.instruments.entrySet()) {
            String id = stringInstrumentEntry.getKey();
            Instrument existingInstrument = stringInstrumentEntry.getValue();
            if (!existingInstrument.equals(instrument)) continue;
            keyToDelete = id;
            break;
        }
        if (keyToDelete != null) {
            this.removeInstrument(keyToDelete);
        }
    }

    public Map<String, Instrument> getInstruments() {
        return this.instruments;
    }

    public Instrument getInstrument(String id) {
        return this.instruments.get(id);
    }

    public Instrument getDefaultInstrument() {
        return this.instruments.get(this.defaultInstrumentID);
    }

    public String getDefaultInstrumentID() {
        return this.defaultInstrumentID;
    }

    public void setDefaultInstrumentID(String id) {
        if (id == null) {
            this.unsetDefaultInstrument();
            return;
        }
        if (!this.instruments.containsKey(id)) {
            throw new IllegalArgumentException("The instrument map did not contain provided instrument ID, have you added the instrument first?");
        }
        this.defaultInstrumentID = id;
        this.isDefaultExplicitlySet = true;
    }

    private void unsetDefaultInstrument() {
        this.defaultInstrumentID = null;
        this.isDefaultExplicitlySet = false;
    }

    public Date getRunStartTime() {
        return this.date;
    }

    public void setRunStartTime(Date runStartTime) {
        this.date = runStartTime;
    }

    public List<MsSoftware> getSoftware() {
        return this.software;
    }

    public List<OriginalFile> getOriginalFiles() {
        return this.originalFiles;
    }

    public String toString() {
        return "LCMSRunInfo{instruments=" + this.instruments + ", date=" + this.date + ", defaultInstrumentID='" + this.defaultInstrumentID + '\'' + ", isCentroided=" + this.isCentroided + ", isDefaultExplicitlySet=" + this.isDefaultExplicitlySet + '}';
    }
}

