/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.fileio.filetypes.mzxml;

import java.nio.charset.StandardCharsets;
import javolution.text.CharArray;
import javolution.xml.internal.stream.XMLStreamReaderImpl;
import javolution.xml.sax.Attributes;
import javolution.xml.stream.XMLStreamException;
import javolution.xml.stream.XMLUnexpectedEndOfDocumentException;
import javolution.xml.stream.XMLUnexpectedEndTagException;
import org.apache.commons.pool2.ObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import umich.ms.fileio.exceptions.FileParsingException;
import umich.ms.fileio.filetypes.mzxml.MZXMLIndexElement;
import umich.ms.fileio.filetypes.mzxml.MZXMLMultiSpectraParser;
import umich.ms.fileio.filetypes.mzxml.MzxmlVars;
import umich.ms.fileio.filetypes.xmlbased.IndexBuilder;
import umich.ms.logging.LogHelper;
import umich.ms.util.OffsetLength;

public class MZXMLIndexBuilder
implements IndexBuilder<MZXMLIndexElement> {
    private static final Logger logger = LoggerFactory.getLogger(MZXMLIndexBuilder.class);
    private ObjectPool<XMLStreamReaderImpl> pool;
    private IndexBuilder.Info info;
    private MzxmlVars vars;

    public MZXMLIndexBuilder(IndexBuilder.Info info, ObjectPool<XMLStreamReaderImpl> pool) {
        this.info = info;
        this.pool = pool;
        this.vars = new MzxmlVars();
    }

    @Override
    public IndexBuilder.Result<MZXMLIndexElement> call() throws Exception {
        return this.buildIndex(this.info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexBuilder.Result<MZXMLIndexElement> buildIndex(IndexBuilder.Info info) throws Exception {
        IndexBuilder.Result<MZXMLIndexElement> result = new IndexBuilder.Result<MZXMLIndexElement>(info);
        boolean numOpeningScanTagsFound = false;
        this.vars.reset();
        XMLStreamReaderImpl reader = this.pool == null ? new XMLStreamReaderImpl() : (XMLStreamReaderImpl)this.pool.borrowObject();
        try {
            reader.setInput(info.is, StandardCharsets.UTF_8.name());
            LogHelper.setJavolutionLogLevelFatal();
            XMLStreamReaderImpl.LocationImpl location = reader.getLocation();
            int eventType = 8;
            do {
                try {
                    eventType = reader.next();
                }
                catch (XMLStreamException e) {
                    if (e instanceof XMLUnexpectedEndTagException) {
                        eventType = reader.getEventType();
                    }
                    if (e instanceof XMLUnexpectedEndOfDocumentException) {
                        break;
                    }
                    throw new FileParsingException(e);
                }
                switch (eventType) {
                    case 1: {
                        CharArray localName = reader.getLocalName();
                        Attributes attrs = reader.getAttributes();
                        if (!localName.contentEquals((CharSequence)MZXMLMultiSpectraParser.TAG.SCAN.name)) break;
                        if (this.vars.offsetLo != null) {
                            long lastStartTagPos = location.getLastStartTagPos();
                            this.vars.length = (int)(this.vars.offsetLo - lastStartTagPos);
                            this.addAndFlush(result, info.offsetInFile);
                        }
                        this.vars.offsetLo = location.getLastStartTagPos();
                        try {
                            this.vars.scanNumRaw = attrs.getValue((CharSequence)MZXMLMultiSpectraParser.ATTR.SCAN_NUM.name).toInt();
                            break;
                        }
                        catch (NumberFormatException e) {
                            throw new FileParsingException("Malformed scan number while building index", e);
                        }
                    }
                    case 4: {
                        break;
                    }
                    case 2: {
                        CharArray localName = reader.getLocalName();
                        if (!localName.contentEquals((CharSequence)MZXMLMultiSpectraParser.TAG.SCAN.name)) break;
                        this.vars.offsetHi = location.getTotalCharsRead();
                        this.addAndFlush(result, info.offsetInFile);
                    }
                }
            } while (eventType != 8);
        }
        finally {
            this.addAndFlush(result, info.offsetInFile);
            if (this.pool != null && reader != null) {
                this.pool.returnObject((Object)reader);
            }
        }
        return result;
    }

    private void addAndFlush(IndexBuilder.Result<MZXMLIndexElement> result, long offsetInFile) throws FileParsingException {
        if (this.vars.offsetLo != null) {
            if (this.vars.scanNumRaw == -1) {
                throw new IllegalStateException("When building index raw scan number was not found for offset: " + offsetInFile + this.vars.offsetLo);
            }
            if (this.vars.offsetHi != null) {
                long len = this.vars.offsetHi - this.vars.offsetLo;
                if (len < 0L) {
                    throw new FileParsingException("Calculated length was less than zero");
                }
                if (len > Integer.MAX_VALUE) {
                    throw new FileParsingException("Calculated length was larger than Integer.MAX_VALUE");
                }
                result.addIndexElement(new MZXMLIndexElement(this.vars.scanNumRaw, this.vars.scanNumRaw, new OffsetLength(offsetInFile + this.vars.offsetLo, (int)len)));
            } else {
                result.addStartTag(new MZXMLIndexElement(this.vars.scanNumRaw, this.vars.scanNumRaw, new OffsetLength(offsetInFile + this.vars.offsetLo, -1)));
            }
        } else if (this.vars.offsetHi != null) {
            result.addCloseTag(new MZXMLIndexElement(-1, -1, new OffsetLength(offsetInFile + this.vars.offsetHi, 0)));
        }
        this.vars.reset();
        this.vars.reset();
    }
}

