/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.fileio.filetypes.mzxml;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamReader;
import umich.ms.datatypes.lcmsrun.Hash;
import umich.ms.datatypes.lcmsrun.LCMSRunInfo;
import umich.ms.datatypes.lcmsrun.MsSoftware;
import umich.ms.datatypes.lcmsrun.OriginalFile;
import umich.ms.datatypes.scan.props.Instrument;
import umich.ms.fileio.exceptions.RunHeaderParsingException;
import umich.ms.fileio.filetypes.mzml.MZMLRunInfo;
import umich.ms.fileio.filetypes.mzxml.MZXMLFile;
import umich.ms.fileio.filetypes.mzxml.XmlBasedRunHeaderParser;
import umich.ms.fileio.filetypes.mzxml.jaxb.MsRun;
import umich.ms.fileio.filetypes.mzxml.jaxb.OntologyEntryType;
import umich.ms.fileio.filetypes.mzxml.jaxb.Software;
import umich.ms.logging.LogHelper;
import umich.ms.util.OffsetLength;
import umich.ms.util.jaxb.JaxbUtils;
import umich.ms.util.xml.POSITION;
import umich.ms.util.xml.XmlUtils;

public class MZXMLRunHeaderParser
implements XmlBasedRunHeaderParser {
    private static final String TAG_MSRUN = "msRun";
    private static final String TAG_SCAN = "scan";
    protected MZXMLFile source;

    public MZXMLRunHeaderParser(MZXMLFile source) {
        this.source = source;
        LogHelper.setJavolutionLogLevelFatal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LCMSRunInfo parse() throws RunHeaderParsingException {
        List<MsRun.MsInstrument> msInstruments;
        MsRun msRun;
        String header;
        Object suffix;
        Object body;
        OffsetLength loc;
        Charset utf8 = Charset.forName("UTF-8");
        long maxOffset = 0xA00000L;
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(this.source.getPath()));){
            String search1 = "<msRun";
            String search2 = "<scan";
            List<byte[]> targets = Arrays.asList(search1.getBytes(utf8), search2.getBytes(utf8));
            List<POSITION> locations = Arrays.asList(POSITION.START, POSITION.START);
            List<Long> list = XmlUtils.locate(targets, locations, bis, 0xA00000L);
            if (list == null || list.size() != targets.size()) {
                throw new RunHeaderParsingException("Could not locate the header within 10485760 bytes of the file.");
            }
            loc = new OffsetLength(list.get(0), (int)(list.get(1) - list.get(0)));
        }
        catch (IOException | RunHeaderParsingException e) {
            return LCMSRunInfo.createDummyInfo();
        }
        RandomAccessFile raf = null;
        try {
            raf = this.source.getRandomAccessFile();
            raf.seek(loc.offset);
            byte[] bytes = new byte[loc.length];
            raf.readFully(bytes);
            body = new String(bytes, utf8);
            suffix = "</msRun>";
            header = (String)body + (String)suffix;
        }
        catch (IOException e) {
            body = LCMSRunInfo.createDummyInfo();
            return body;
        }
        finally {
            if (raf != null) {
                this.source.close();
            }
        }
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(header.getBytes(Charset.forName("UTF-8")));
            suffix = null;
            try {
                XMLStreamReader xsr = JaxbUtils.createXmlStreamReader(is, false);
                msRun = JaxbUtils.unmarshal(MsRun.class, xsr);
            }
            catch (Throwable xsr) {
                suffix = xsr;
                throw xsr;
            }
            finally {
                if (is != null) {
                    if (suffix != null) {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (Throwable xsr) {
                            ((Throwable)suffix).addSuppressed(xsr);
                        }
                    } else {
                        ((InputStream)is).close();
                    }
                }
            }
        }
        catch (IOException | JAXBException e1) {
            LCMSRunInfo dummyInfo = LCMSRunInfo.createDummyInfo();
            return new MZMLRunInfo(dummyInfo);
        }
        LCMSRunInfo runInfo = new LCMSRunInfo();
        List<MsRun.ParentFile> parentFiles = msRun.getParentFile();
        if (parentFiles != null) {
            for (MsRun.ParentFile parentFile : parentFiles) {
                String file = parentFile.getFileName();
                file = file.replaceAll("\\\\", "/");
                String location = "";
                String fileName = file;
                try {
                    Path path = Paths.get(file, new String[0]);
                    location = path.getParent().toString();
                    fileName = path.getFileName().toString();
                }
                catch (InvalidPathException e) {
                    try {
                        URI uri = URI.create(file).normalize();
                        String uriPath = uri.getPath();
                        while (uriPath.startsWith("/")) {
                            uriPath = uriPath.substring(1);
                        }
                        Path path = Paths.get(uriPath, new String[0]);
                        fileName = path.getFileName().toString();
                        Path parent = path.getParent();
                        if (parent != null) {
                            location = this.toString();
                        }
                    }
                    catch (IllegalArgumentException uri) {
                        // empty catch block
                    }
                }
                Hash hash = null;
                if (parentFile.getFileSha1() != null && !parentFile.getFileSha1().isEmpty()) {
                    hash = new Hash(parentFile.getFileSha1(), Hash.TYPE.SHA1);
                }
                runInfo.getOriginalFiles().add(new OriginalFile(location, fileName, hash));
            }
        }
        if ((msInstruments = msRun.getMsInstrument()) != null && msInstruments.size() > 0) {
            for (MsRun.MsInstrument i : msInstruments) {
                String msInstrumentID;
                if (i.getMsInstrumentID() != null) {
                    msInstrumentID = i.getMsInstrumentID();
                } else if (i.getStringInstrumentID() != null) {
                    msInstrumentID = i.getStringInstrumentID();
                } else if (msInstruments.size() == 1) {
                    msInstrumentID = "ID_UNKNOWN";
                } else {
                    throw new RunHeaderParsingException("Could not find instrument ID attribute. Should be <msInstrument msInstrumentID='xxx'> or <msInstrument id='xxx'>");
                }
                Instrument instrument = new Instrument();
                MsRun.MsInstrument.MsManufacturer msManufacturer = i.getMsManufacturer();
                String manufacturer = msManufacturer != null ? msManufacturer.getValueOntologyEntryType() : "Vendor N/A";
                instrument.setManufacturer(manufacturer);
                OntologyEntryType msModel = i.getMsModel();
                String model = msModel != null ? msModel.getValueOntologyEntryType() : "Model N/A";
                instrument.setModel(model);
                MsRun.MsInstrument.MsMassAnalyzer msMassAnalyzer = i.getMsMassAnalyzer();
                String analyzer = msMassAnalyzer != null ? msMassAnalyzer.getValueOntologyEntryType() : "Analyzer N/A";
                instrument.setAnalyzer(analyzer);
                OntologyEntryType msDetector = i.getMsDetector();
                String detector = msDetector != null ? msDetector.getValueOntologyEntryType() : "Detector N/A";
                instrument.setDetector(detector);
                OntologyEntryType msIonisation = i.getMsIonisation();
                String ionisation = msIonisation != null ? msIonisation.getValueOntologyEntryType() : "Ionisation N/A";
                instrument.setIonisation(ionisation);
                runInfo.addInstrument(instrument, msInstrumentID);
            }
        } else {
            runInfo.addInstrument(Instrument.getDummy(), "ID_UNKNOWN");
        }
        List<MsRun.DataProcessing> list = msRun.getDataProcessing();
        if (list != null) {
            for (MsRun.DataProcessing dataProcessing : list) {
                Software software;
                if (dataProcessing.isCentroided() != null) {
                    runInfo.setCentroided(dataProcessing.isCentroided());
                }
                if ((software = dataProcessing.getSoftware()) == null) continue;
                MsSoftware msSoftware = new MsSoftware(software.getName(), software.getVersion());
                runInfo.getSoftware().add(msSoftware);
            }
        }
        return runInfo;
    }
}

