/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.fileio.filetypes.pepxml.example;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import umich.ms.fileio.exceptions.FileParsingException;
import umich.ms.fileio.filetypes.pepxml.PepXmlParser;
import umich.ms.fileio.filetypes.pepxml.jaxb.standard.MsmsPipelineAnalysis;
import umich.ms.fileio.filetypes.pepxml.jaxb.standard.MsmsRunSummary;
import umich.ms.fileio.filetypes.pepxml.jaxb.standard.SpectrumQuery;

public class PepXmlSimpleExample {
    public static void main(String[] args) throws FileParsingException {
        if (args.length < 1) {
            throw new IllegalArgumentException("You must specify the filepath using command line arguments");
        }
        Path path = Paths.get(args[0], new String[0]);
        MsmsPipelineAnalysis msmsPipelineAnalysis = PepXmlParser.parse(path);
        List<MsmsRunSummary> msmsRunSummaries = msmsPipelineAnalysis.getMsmsRunSummary();
        for (MsmsRunSummary msmsRunSummary : msmsRunSummaries) {
            List<SpectrumQuery> spectrumQueries = msmsRunSummary.getSpectrumQuery();
            System.out.printf("Spectrum queries from MS/MS run summary: %s\n", msmsRunSummary.getBaseName());
            for (SpectrumQuery sq : spectrumQueries) {
                System.out.printf("Spec ID: [%s], RT: [%.2f], precursor neutral mass: [%.3f]\n", sq.getSpectrum(), sq.getRetentionTimeSec(), sq.getPrecursorNeutralMass());
            }
            System.out.printf("Done with MS/MS run summary: %s\n", msmsRunSummary.getBaseName());
        }
        System.out.println();
    }
}

