/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class ReverseLineInputStream
extends InputStream {
    RandomAccessFile in;
    long currentLineStart = -1L;
    long currentLineEnd = -1L;
    long currentPos = -1L;
    long lastPosInFile = -1L;

    public ReverseLineInputStream(RandomAccessFile raf) throws IOException {
        this.in = raf;
        this.currentLineStart = raf.length();
        this.currentLineEnd = raf.length();
        this.lastPosInFile = raf.length() - 1L;
        this.currentPos = this.currentLineEnd;
    }

    public void setFilePointer(long pos) {
        this.currentLineEnd = pos;
        this.currentLineStart = pos;
        this.currentPos = pos;
    }

    public void findPrevLine() throws IOException {
        this.currentLineEnd = this.currentLineStart;
        if (this.currentLineEnd == 0L) {
            this.currentLineEnd = -1L;
            this.currentLineStart = -1L;
            this.currentPos = -1L;
            return;
        }
        long filePointer = this.currentLineStart - 1L;
        while (--filePointer >= 0L) {
            this.in.seek(filePointer);
            byte readByte = this.in.readByte();
            if (readByte != 10 || filePointer == this.lastPosInFile) continue;
            break;
        }
        this.currentPos = this.currentLineStart = filePointer + 1L;
    }

    @Override
    public int read() throws IOException {
        if (this.currentPos < this.currentLineEnd) {
            this.in.seek(this.currentPos++);
            byte readByte = this.in.readByte();
            return readByte;
        }
        if (this.currentPos < 0L) {
            return -1;
        }
        this.findPrevLine();
        return this.read();
    }
}

