/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.util.file;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileListing {
    private static final Logger log = LoggerFactory.getLogger(FileListing.class);
    protected Path path;
    boolean includeDirectories = false;
    boolean includeFiles = true;
    boolean followLinks = false;
    boolean recursive = true;
    Pattern pattern;
    private int MAX_RECURSION_DEPTH = 128;

    public FileListing(Path path, String regex) {
        this.path = path.toAbsolutePath();
        this.pattern = Pattern.compile(regex);
    }

    public boolean isFollowLinks() {
        return this.followLinks;
    }

    public void setFollowLinks(boolean followLinks) {
        this.followLinks = followLinks;
    }

    public boolean isIncludeFiles() {
        return this.includeFiles;
    }

    public void setIncludeFiles(boolean includeFiles) {
        this.includeFiles = includeFiles;
    }

    public Path getPath() {
        return this.path;
    }

    public void setPath(Path path) {
        this.path = path.toAbsolutePath();
    }

    public boolean isIncludeDirectories() {
        return this.includeDirectories;
    }

    public void setIncludeDirectories(boolean includeDirectories) {
        this.includeDirectories = includeDirectories;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public List<Path> findFiles() {
        LinkOption[] options = this.followLinks ? new LinkOption[]{} : new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
        if (this.includeFiles && !Files.isDirectory(this.path, options)) {
            if (this.matches(this.path)) {
                return Collections.singletonList(this.path);
            }
        } else {
            ArrayList<Path> result = new ArrayList<Path>();
            if (this.includeDirectories && this.matches(this.path)) {
                result.add(this.path);
            }
            this.findFiles(this.path, result, options, 0);
            return result;
        }
        return Collections.emptyList();
    }

    private void findFiles(Path path, List<Path> matching, LinkOption[] options, int recursionLevel) {
        if (recursionLevel > this.MAX_RECURSION_DEPTH) {
            return;
        }
        try {
            DirectoryStream<Path> paths = Files.newDirectoryStream(path);
            for (Path p : paths) {
                if (Files.isDirectory(p, options)) {
                    if (this.includeDirectories && this.matches(p)) {
                        matching.add(p);
                    }
                    this.findFiles(p, matching, options, recursionLevel);
                    continue;
                }
                if (!this.includeFiles || !this.matches(p)) continue;
                matching.add(p);
            }
        }
        catch (IOException e) {
            log.error("Could not list files in directory '{}'", (Object)path.toString());
        }
    }

    private boolean matches(Path s) {
        Matcher matcher = this.pattern.matcher(s.toString());
        return matcher.matches();
    }
}

