/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.chemistry.model;

import fr.profi.chemistry.model.IMolecularEntity;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class AbundanceMapOps$ {
    public static AbundanceMapOps$ MODULE$;

    static {
        new AbundanceMapOps$();
    }

    public <M extends IMolecularEntity> float sumAbundances(HashMap<M, Object> abundanceMap) {
        return BoxesRunTime.unboxToFloat((Object)abundanceMap.foldLeft((Object)BoxesRunTime.boxToFloat((float)0.0f), (Function2 & Serializable & scala.Serializable)(sum, ab) -> BoxesRunTime.boxToFloat((float)AbundanceMapOps$.$anonfun$sumAbundances$1(BoxesRunTime.unboxToFloat((Object)sum), ab))));
    }

    public <M extends IMolecularEntity> float sumAbsoluteAbundances(HashMap<M, Object> abundanceMap) {
        return BoxesRunTime.unboxToFloat((Object)abundanceMap.foldLeft((Object)BoxesRunTime.boxToFloat((float)0.0f), (Function2 & Serializable & scala.Serializable)(sum, ab) -> BoxesRunTime.boxToFloat((float)AbundanceMapOps$.$anonfun$sumAbsoluteAbundances$1(BoxesRunTime.unboxToFloat((Object)sum), ab))));
    }

    public <M extends IMolecularEntity> double calcMass(HashMap<M, Object> abundanceMap, Function1<IMolecularEntity, Object> massExtractor) {
        DoubleRef mass = DoubleRef.create((double)0.0);
        abundanceMap.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)AbundanceMapOps$.$anonfun$calcMass$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            AbundanceMapOps$.$anonfun$calcMass$2(massExtractor, mass, x$1);
            return BoxedUnit.UNIT;
        });
        return mass.elem;
    }

    public <M extends IMolecularEntity> double calcMonoMass(HashMap<M, Object> abundanceMap) {
        return this.calcMass(abundanceMap, (Function1<IMolecularEntity, Object>)(Function1 & Serializable & scala.Serializable)entity -> BoxesRunTime.boxToDouble((double)entity.monoMass()));
    }

    public <M extends IMolecularEntity> double calcAverageMass(HashMap<M, Object> abundanceMap) {
        return this.calcMass(abundanceMap, (Function1<IMolecularEntity, Object>)(Function1 & Serializable & scala.Serializable)entity -> BoxesRunTime.boxToDouble((double)entity.averageMass()));
    }

    public <M extends IMolecularEntity> void multiplyBy(HashMap<M, Object> abundanceMap, float number) {
        AbundanceMapOps$ abundanceMapOps$ = this;
        synchronized (abundanceMapOps$) {
            abundanceMap.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)AbundanceMapOps$.$anonfun$multiplyBy$1(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                AbundanceMapOps$.$anonfun$multiplyBy$2(abundanceMap, number, x$2);
                return BoxedUnit.UNIT;
            });
        }
    }

    public synchronized <M extends IMolecularEntity> void divideBy(HashMap<M, Object> abundanceMap, float number) {
        abundanceMap.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)AbundanceMapOps$.$anonfun$divideBy$1(check$ifrefutable$3))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            AbundanceMapOps$.$anonfun$divideBy$2(abundanceMap, number, x$3);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized <M extends IMolecularEntity> void addAbundanceMap(HashMap<M, Object> abundanceMap, Map<M, Object> otherAbundanceMap) {
        otherAbundanceMap.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)AbundanceMapOps$.$anonfun$addAbundanceMap$1(check$ifrefutable$4))).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            AbundanceMapOps$.$anonfun$addAbundanceMap$2(abundanceMap, x$4);
            return BoxedUnit.UNIT;
        });
    }

    public <M extends IMolecularEntity> String stringifyToFormula(HashMap<M, Object> abundanceMap) {
        List sortedAtoms = (List)abundanceMap.keys().toList().sortBy((Function1 & Serializable & scala.Serializable)x$5 -> x$5.symbol(), (Ordering)Ordering.String$.MODULE$);
        List strings = (List)sortedAtoms.flatMap((Function1 & Serializable & scala.Serializable)entity -> Option$.MODULE$.option2Iterable(abundanceMap.get(entity).map((Function1)(JFunction1.mcIF.sp & Serializable & scala.Serializable)x$6 -> (int)x$6).withFilter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)abundance -> abundance != 0).map((Function1 & Serializable & scala.Serializable)abundance -> AbundanceMapOps$.$anonfun$stringifyToFormula$5(entity, BoxesRunTime.unboxToInt((Object)abundance)))), List$.MODULE$.canBuildFrom());
        return strings.mkString(" ");
    }

    public static final /* synthetic */ float $anonfun$sumAbundances$1(float sum, Tuple2 ab) {
        return sum + BoxesRunTime.unboxToFloat((Object)ab._2());
    }

    public static final /* synthetic */ float $anonfun$sumAbsoluteAbundances$1(float sum, Tuple2 ab) {
        return sum + package$.MODULE$.abs(BoxesRunTime.unboxToFloat((Object)ab._2()));
    }

    public static final /* synthetic */ boolean $anonfun$calcMass$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$calcMass$2(Function1 massExtractor$1, DoubleRef mass$1, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            IMolecularEntity entity = (IMolecularEntity)tuple2._1();
            float entityAb = BoxesRunTime.unboxToFloat((Object)tuple2._2());
            double entityMass = BoxesRunTime.unboxToDouble((Object)massExtractor$1.apply((Object)entity));
            mass$1.elem += (double)entityAb * entityMass;
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$multiplyBy$1(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$multiplyBy$2(HashMap abundanceMap$1, float number$1, Tuple2 x$2) {
        Tuple2 tuple2 = x$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        IMolecularEntity key = (IMolecularEntity)tuple2._1();
        abundanceMap$1.update((Object)key, (Object)BoxesRunTime.boxToFloat((float)(BoxesRunTime.unboxToFloat((Object)abundanceMap$1.apply((Object)key)) * number$1)));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$divideBy$1(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$divideBy$2(HashMap abundanceMap$2, float number$2, Tuple2 x$3) {
        Tuple2 tuple2 = x$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        IMolecularEntity key = (IMolecularEntity)tuple2._1();
        abundanceMap$2.update((Object)key, (Object)BoxesRunTime.boxToFloat((float)(BoxesRunTime.unboxToFloat((Object)abundanceMap$2.apply((Object)key)) / number$2)));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$addAbundanceMap$1(Tuple2 check$ifrefutable$4) {
        Tuple2 tuple2 = check$ifrefutable$4;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$addAbundanceMap$2(HashMap abundanceMap$3, Tuple2 x$4) {
        Tuple2 tuple2 = x$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        IMolecularEntity key = (IMolecularEntity)tuple2._1();
        float value = BoxesRunTime.unboxToFloat((Object)tuple2._2());
        abundanceMap$3.getOrElseUpdate((Object)key, (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> 0.0f);
        abundanceMap$3.update((Object)key, (Object)BoxesRunTime.boxToFloat((float)(BoxesRunTime.unboxToFloat((Object)abundanceMap$3.apply((Object)key)) + value)));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ String $anonfun$stringifyToFormula$5(IMolecularEntity entity$1, int abundance) {
        Object object;
        StringBuilder sb = new StringBuilder();
        if (abundance != 0) {
            sb.append(entity$1.symbol());
            object = abundance != 1 ? sb.append("(").append(abundance).append(")") : BoxedUnit.UNIT;
        } else {
            object = BoxedUnit.UNIT;
        }
        return sb.toString();
    }

    private AbundanceMapOps$() {
        MODULE$ = this;
    }
}

