/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.cli.enzymes;

import com.compomics.cli.enzymes.EnzymesCLIParams;
import com.compomics.software.cli.CommandLineUtils;
import com.compomics.software.cli.CommandParameter;
import com.compomics.util.experiment.biology.AminoAcid;
import com.compomics.util.experiment.biology.Enzyme;
import com.compomics.util.experiment.biology.EnzymeFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;

public class EnzymesCLIInputBean {
    private File fileIn = null;
    private File fileOut = null;
    private boolean list = false;
    private String enzymeToRemove = null;
    private Enzyme enzymeToAdd = null;

    public static boolean isValidStartup(CommandLine aLine) {
        String arg;
        Enzyme enzyme;
        String arg2;
        if (aLine.getOptions().length == 0) {
            return false;
        }
        EnzymeFactory enzymeFactory = null;
        if (aLine.hasOption(EnzymesCLIParams.IN.id)) {
            arg2 = aLine.getOptionValue(EnzymesCLIParams.IN.id);
            if (arg2.equals("")) {
                System.out.println(System.getProperty("line.separator") + "No input file specified!" + System.getProperty("line.separator"));
                return false;
            }
            File fileIn = new File(arg2);
            if (!fileIn.exists()) {
                System.out.println(System.getProperty("line.separator") + "File " + fileIn + " not found." + System.getProperty("line.separator"));
                return false;
            }
            try {
                enzymeFactory = EnzymeFactory.loadFromFile(fileIn);
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing " + fileIn + "." + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(EnzymesCLIParams.LIST.id)) {
            return true;
        }
        if (aLine.hasOption(EnzymesCLIParams.RM.id) && (enzyme = enzymeFactory.getEnzyme(arg2 = aLine.getOptionValue(EnzymesCLIParams.RM.id))) == null) {
            String file = aLine.getOptionValue(EnzymesCLIParams.IN.id);
            System.out.println(System.getProperty("line.separator") + "Enzyme " + arg2 + " not found in " + file + "." + System.getProperty("line.separator"));
            return false;
        }
        boolean name = aLine.hasOption(EnzymesCLIParams.NAME.id);
        boolean attributes = false;
        char[] aminoAcids = AminoAcid.getUniqueAminoAcids();
        ArrayList<String> possibilities = new ArrayList<String>(aminoAcids.length);
        for (char aa : aminoAcids) {
            possibilities.add(aa + "");
        }
        if (aLine.hasOption(EnzymesCLIParams.RESTRICTION_BEFORE.id)) {
            if (!name) {
                System.out.println(System.getProperty("line.separator") + "No name provided for the enzyme to add." + System.getProperty("line.separator"));
                return false;
            }
            arg = aLine.getOptionValue(EnzymesCLIParams.RESTRICTION_BEFORE.id);
            ArrayList<String> aaInput = CommandLineUtils.splitInput(arg);
            for (String aa : aaInput) {
                if (CommandParameter.isInList(EnzymesCLIParams.RESTRICTION_BEFORE.id, aa, aaInput)) continue;
                return false;
            }
            attributes = true;
        }
        if (aLine.hasOption(EnzymesCLIParams.RESTRICTION_AFTER.id)) {
            if (!name) {
                System.out.println(System.getProperty("line.separator") + "No name provided for the enzyme to add." + System.getProperty("line.separator"));
                return false;
            }
            arg = aLine.getOptionValue(EnzymesCLIParams.RESTRICTION_AFTER.id);
            ArrayList<String> aaInput = CommandLineUtils.splitInput(arg);
            for (String aa : aaInput) {
                if (CommandParameter.isInList(EnzymesCLIParams.RESTRICTION_AFTER.id, aa, aaInput)) continue;
                return false;
            }
            attributes = true;
        }
        if (aLine.hasOption(EnzymesCLIParams.CLEAVE_BEFORE.id)) {
            if (!name) {
                System.out.println(System.getProperty("line.separator") + "No name provided for the enzyme to add." + System.getProperty("line.separator"));
                return false;
            }
            arg = aLine.getOptionValue(EnzymesCLIParams.CLEAVE_BEFORE.id);
            ArrayList<String> aaInput = CommandLineUtils.splitInput(arg);
            for (String aa : aaInput) {
                if (CommandParameter.isInList(EnzymesCLIParams.CLEAVE_BEFORE.id, aa, aaInput)) continue;
                return false;
            }
            attributes = true;
        }
        if (aLine.hasOption(EnzymesCLIParams.CLEAVE_AFTER.id)) {
            if (!name) {
                System.out.println(System.getProperty("line.separator") + "No name provided for the enzyme to add." + System.getProperty("line.separator"));
                return false;
            }
            arg = aLine.getOptionValue(EnzymesCLIParams.CLEAVE_AFTER.id);
            ArrayList<String> aaInput = CommandLineUtils.splitInput(arg);
            for (String aa : aaInput) {
                if (CommandParameter.isInList(EnzymesCLIParams.CLEAVE_AFTER.id, aa, aaInput)) continue;
                return false;
            }
            attributes = true;
        }
        if (name && !attributes) {
            System.out.println(System.getProperty("line.separator") + "No cleavage properties provided for the enzyme to add." + System.getProperty("line.separator"));
            return false;
        }
        return true;
    }

    public EnzymesCLIInputBean(CommandLine aLine) throws IOException {
        String arg;
        if (aLine.hasOption(EnzymesCLIParams.IN.id)) {
            arg = aLine.getOptionValue(EnzymesCLIParams.IN.id);
            this.fileIn = new File(arg);
        }
        if (aLine.hasOption(EnzymesCLIParams.LIST.id)) {
            this.list = true;
            return;
        }
        if (aLine.hasOption(EnzymesCLIParams.OUT.id)) {
            arg = aLine.getOptionValue(EnzymesCLIParams.OUT.id);
            this.fileOut = new File(arg);
        }
        if (aLine.hasOption(EnzymesCLIParams.RM.id)) {
            this.enzymeToRemove = aLine.getOptionValue(EnzymesCLIParams.RM.id);
        }
        if (aLine.hasOption(EnzymesCLIParams.NAME.id)) {
            ArrayList<String> aaInput;
            String arg2;
            String enzymeName = aLine.getOptionValue(EnzymesCLIParams.NAME.id);
            this.enzymeToAdd = new Enzyme(enzymeName);
            if (aLine.hasOption(EnzymesCLIParams.RESTRICTION_BEFORE.id)) {
                arg2 = aLine.getOptionValue(EnzymesCLIParams.RESTRICTION_BEFORE.id);
                aaInput = CommandLineUtils.splitInput(arg2);
                for (String aa : aaInput) {
                    this.enzymeToAdd.addRestrictionBefore(Character.valueOf(aa.charAt(0)));
                }
            }
            if (aLine.hasOption(EnzymesCLIParams.RESTRICTION_AFTER.id)) {
                arg2 = aLine.getOptionValue(EnzymesCLIParams.RESTRICTION_AFTER.id);
                aaInput = CommandLineUtils.splitInput(arg2);
                for (String aa : aaInput) {
                    this.enzymeToAdd.addRestrictionAfter(Character.valueOf(aa.charAt(0)));
                }
            }
            if (aLine.hasOption(EnzymesCLIParams.CLEAVE_BEFORE.id)) {
                arg2 = aLine.getOptionValue(EnzymesCLIParams.CLEAVE_BEFORE.id);
                aaInput = CommandLineUtils.splitInput(arg2);
                for (String aa : aaInput) {
                    this.enzymeToAdd.addAminoAcidBefore(Character.valueOf(aa.charAt(0)));
                }
            }
            if (aLine.hasOption(EnzymesCLIParams.CLEAVE_AFTER.id)) {
                arg2 = aLine.getOptionValue(EnzymesCLIParams.CLEAVE_AFTER.id);
                aaInput = CommandLineUtils.splitInput(arg2);
                for (String aa : aaInput) {
                    this.enzymeToAdd.addAminoAcidAfter(Character.valueOf(aa.charAt(0)));
                }
            }
        }
    }

    public File getFileIn() {
        return this.fileIn;
    }

    public File getFileOut() {
        return this.fileOut;
    }

    public boolean isList() {
        return this.list;
    }

    public String getEnzymeToRemove() {
        return this.enzymeToRemove;
    }

    public Enzyme getEnzymeToAdd() {
        return this.enzymeToAdd;
    }
}

