/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.cli.modifications;

import org.apache.commons.cli.Options;

public enum ModificationsCLIParams {
    IN("in", "An input file (.json).", false, true),
    LIST("l", "Lists all modifications implemented. All other options than " + ModificationsCLIParams.IN.id + " will be ignored.", false, false),
    OUT("out", "The destination modifications file (.json).", true, true),
    RM("rm", "The name of a modification to remove.", false, true),
    TYPE("type", "The typr of the modification to add. 0: Modification at particular amino acids; 1: Modification at the N terminus of a protein; 2: Modification at the N terminus of a protein at particular amino acids; 3: Modification at the C terminus of a protein; 4: Modification at the C terminus of a protein at particular amino acids; 5: Modification at the N terminus of a peptide; 6: Modification at the N terminus of a peptide at particular amino acids; 7: Modification at the C terminus of a peptide; 8: Modification at the C terminus of a peptide at particular amino acids.", false, true),
    NAME("name", "The name of a modification to add.", false, true),
    SHORT_NAME("short_name", "The short name of the modification to add.", false, true),
    COMPOSITION_ADDED("composition_added", "The atomic composition of the modification to add.", false, true),
    COMPOSITION_REMOVED("composition_removed", "The atomic composition of the modification to remove.", false, true),
    PATTERN("pattern", "For modifications that target specific amino-acids, the pattern of amino-acids targetted. E.g. N[ACDEFGHIKLMNQRSTYUOVW][ST] for a modification targetting N followed by any amino acid but P followed by S or T.", false, true),
    PATTERN_INDEX("pattern_index", "For modifications targetting a pattern of amino-acids longer than one amino acid, the index on the patter where the modification is located, 0 being the first amino acid. E.g. 0 in N[ACDEFGHIKLMNQRSTYUOVW][ST] means that the modification is located on N, 2 means that the modification is located on S or T. 0 by default.", false, true);

    public final String id;
    public final String description;
    public final boolean mandatory;
    public final boolean hasArgument;

    private ModificationsCLIParams(String id, String description, boolean mandatory, boolean hasArgument) {
        this.id = id;
        this.description = description;
        this.mandatory = mandatory;
        this.hasArgument = hasArgument;
    }

    public static void createOptionsCLI(Options aOptions) {
        for (ModificationsCLIParams option : ModificationsCLIParams.values()) {
            aOptions.addOption(option.id, option.hasArgument, option.description);
        }
    }

    public static String getOptionsAsString() {
        String output = "";
        output = output + "Input-Output:\n\n";
        output = output + "-" + String.format("%-35s", ModificationsCLIParams.IN.id) + " " + ModificationsCLIParams.IN.description + "\n";
        output = output + "-" + String.format("%-35s", ModificationsCLIParams.OUT.id) + " " + ModificationsCLIParams.OUT.description + "\n";
        output = output + "-" + String.format("%-35s", ModificationsCLIParams.LIST.id) + " " + ModificationsCLIParams.LIST.description + "\n";
        output = output + "\n\nRemove modification:\n";
        output = output + "-" + String.format("%-35s", ModificationsCLIParams.RM.id) + " " + ModificationsCLIParams.RM.description + "\n";
        output = output + "\n\nAdd modification:\n";
        output = output + "-" + String.format("%-35s", ModificationsCLIParams.TYPE.id) + " " + ModificationsCLIParams.TYPE.description + "\n";
        output = output + "-" + String.format("%-35s", ModificationsCLIParams.NAME.id) + " " + ModificationsCLIParams.NAME.description + "\n";
        output = output + "-" + String.format("%-35s", ModificationsCLIParams.SHORT_NAME.id) + " " + ModificationsCLIParams.SHORT_NAME.description + "\n";
        output = output + "-" + String.format("%-35s", ModificationsCLIParams.COMPOSITION_ADDED.id) + " " + ModificationsCLIParams.COMPOSITION_ADDED.description + "\n";
        output = output + "-" + String.format("%-35s", ModificationsCLIParams.COMPOSITION_REMOVED.id) + " " + ModificationsCLIParams.COMPOSITION_REMOVED.description + "\n";
        output = output + "-" + String.format("%-35s", ModificationsCLIParams.PATTERN.id) + " " + ModificationsCLIParams.PATTERN.description + "\n";
        output = output + "-" + String.format("%-35s", ModificationsCLIParams.PATTERN_INDEX.id) + " " + ModificationsCLIParams.PATTERN_INDEX.description + "\n";
        return output;
    }
}

