/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.software.autoupdater;

import com.compomics.software.autoupdater.CompareVersionNumbers;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class MetaDataXMLParser {
    private String highestVersionNumber;
    private XMLEvent XMLEvent;

    public MetaDataXMLParser(XMLEventReader xmlReader) throws XMLStreamException {
        while (xmlReader.hasNext()) {
            this.XMLEvent = xmlReader.nextEvent();
            if (!this.XMLEvent.isStartElement() || !this.XMLEvent.asStartElement().getName().getLocalPart().equalsIgnoreCase("versions")) continue;
            this.parseVersionNumbers(xmlReader);
            break;
        }
    }

    public String getHighestVersionNumber() {
        return this.highestVersionNumber;
    }

    private void parseVersionNumbers(XMLEventReader xmlReader) throws XMLStreamException {
        CompareVersionNumbers versionNumberComparator = new CompareVersionNumbers();
        while (xmlReader.hasNext()) {
            this.XMLEvent = xmlReader.nextEvent();
            if (this.XMLEvent.isStartElement()) {
                String currentVersionNumber;
                if (!this.XMLEvent.asStartElement().getName().getLocalPart().equalsIgnoreCase("version") || (currentVersionNumber = xmlReader.nextEvent().asCharacters().getData()).contains("b") || currentVersionNumber.contains("beta")) continue;
                if (this.highestVersionNumber == null) {
                    this.highestVersionNumber = currentVersionNumber;
                    continue;
                }
                if (versionNumberComparator.compare(this.highestVersionNumber, currentVersionNumber) != 1) continue;
                this.highestVersionNumber = currentVersionNumber;
                continue;
            }
            if (!this.XMLEvent.isEndElement() || !this.XMLEvent.asEndElement().getName().getLocalPart().equalsIgnoreCase("versions")) continue;
            break;
        }
    }
}

