/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology;

import com.compomics.util.experiment.biology.AtomChain;
import com.compomics.util.experiment.biology.aminoacids.Alanine;
import com.compomics.util.experiment.biology.aminoacids.Arginine;
import com.compomics.util.experiment.biology.aminoacids.Asparagine;
import com.compomics.util.experiment.biology.aminoacids.AsparticAcid;
import com.compomics.util.experiment.biology.aminoacids.B;
import com.compomics.util.experiment.biology.aminoacids.Cysteine;
import com.compomics.util.experiment.biology.aminoacids.GlutamicAcid;
import com.compomics.util.experiment.biology.aminoacids.Glutamine;
import com.compomics.util.experiment.biology.aminoacids.Glycine;
import com.compomics.util.experiment.biology.aminoacids.Histidine;
import com.compomics.util.experiment.biology.aminoacids.Isoleucine;
import com.compomics.util.experiment.biology.aminoacids.J;
import com.compomics.util.experiment.biology.aminoacids.Leucine;
import com.compomics.util.experiment.biology.aminoacids.Lysine;
import com.compomics.util.experiment.biology.aminoacids.Methionine;
import com.compomics.util.experiment.biology.aminoacids.Phenylalanine;
import com.compomics.util.experiment.biology.aminoacids.Proline;
import com.compomics.util.experiment.biology.aminoacids.Pyrrolysine;
import com.compomics.util.experiment.biology.aminoacids.Selenocysteine;
import com.compomics.util.experiment.biology.aminoacids.Serine;
import com.compomics.util.experiment.biology.aminoacids.Threonine;
import com.compomics.util.experiment.biology.aminoacids.Tryptophan;
import com.compomics.util.experiment.biology.aminoacids.Tyrosine;
import com.compomics.util.experiment.biology.aminoacids.Valine;
import com.compomics.util.experiment.biology.aminoacids.X;
import com.compomics.util.experiment.biology.aminoacids.Z;
import com.compomics.util.preferences.SequenceMatchingPreferences;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class AminoAcid
implements Serializable {
    static final long serialVersionUID = -3158896310928354857L;
    public static final AminoAcid A = new Alanine();
    public static final AminoAcid C = new Cysteine();
    public static final AminoAcid D = new AsparticAcid();
    public static final AminoAcid E = new GlutamicAcid();
    public static final AminoAcid F = new Phenylalanine();
    public static final AminoAcid G = new Glycine();
    public static final AminoAcid H = new Histidine();
    public static final AminoAcid I = new Isoleucine();
    public static final AminoAcid K = new Lysine();
    public static final AminoAcid L = new Leucine();
    public static final AminoAcid M = new Methionine();
    public static final AminoAcid N = new Asparagine();
    public static final AminoAcid P = new Proline();
    public static final AminoAcid Q = new Glutamine();
    public static final AminoAcid R = new Arginine();
    public static final AminoAcid S = new Serine();
    public static final AminoAcid T = new Threonine();
    public static final AminoAcid V = new Valine();
    public static final AminoAcid W = new Tryptophan();
    public static final AminoAcid Y = new Tyrosine();
    public static final AminoAcid U = new Selenocysteine();
    public static final AminoAcid O = new Pyrrolysine();
    public static final AminoAcid B = new B();
    public static final AminoAcid J = new J();
    public static final AminoAcid Z = new Z();
    public static final AminoAcid X = new X();
    public String singleLetterCode;
    public String threeLetterCode;
    public String name;
    public double averageMass;
    protected Double monoisotopicMass;
    protected AtomChain monoisotopicAtomChain;
    private Double indistinguishableAACacheMass = null;
    protected char[] subAminoAcidsWithoutCombination;
    protected char[] subAminoAcidsWithCombination;
    protected char[] aminoAcidCombinations;
    protected String[] standardGeneticCode;
    private static final char[] aminoAcidChars = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    private static final char[] uniqueAminoAcidChars = new char[]{'A', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'Y'};
    public static final String[] aminoAcidStrings = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    private static final int[] aaIndexes = new int[]{0, -1, 1, 2, 3, 4, 5, 6, 7, -1, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, -1, 21, -1};

    public static char[] getAminoAcids() {
        return aminoAcidChars;
    }

    public char getSingleLetterCodeAsChar() {
        return this.singleLetterCode.charAt(0);
    }

    public static List<String> getAminoAcidsList() {
        return Arrays.asList(aminoAcidStrings);
    }

    public static char[] getUniqueAminoAcids() {
        return uniqueAminoAcidChars;
    }

    public static AminoAcid getAminoAcid(String aa) {
        return AminoAcid.getAminoAcid(aa.charAt(0));
    }

    public static AminoAcid getAminoAcid(char aa) {
        switch (aa) {
            case 'A': 
            case 'a': {
                return A;
            }
            case 'C': 
            case 'c': {
                return C;
            }
            case 'D': 
            case 'd': {
                return D;
            }
            case 'E': 
            case 'e': {
                return E;
            }
            case 'F': 
            case 'f': {
                return F;
            }
            case 'G': 
            case 'g': {
                return G;
            }
            case 'H': 
            case 'h': {
                return H;
            }
            case 'I': 
            case 'i': {
                return I;
            }
            case 'K': 
            case 'k': {
                return K;
            }
            case 'L': 
            case 'l': {
                return L;
            }
            case 'M': 
            case 'm': {
                return M;
            }
            case 'N': 
            case 'n': {
                return N;
            }
            case 'P': 
            case 'p': {
                return P;
            }
            case 'Q': 
            case 'q': {
                return Q;
            }
            case 'R': 
            case 'r': {
                return R;
            }
            case 'S': 
            case 's': {
                return S;
            }
            case 'T': 
            case 't': {
                return T;
            }
            case 'V': 
            case 'v': {
                return V;
            }
            case 'W': 
            case 'w': {
                return W;
            }
            case 'Y': 
            case 'y': {
                return Y;
            }
            case 'B': 
            case 'b': {
                return B;
            }
            case 'Z': 
            case 'z': {
                return Z;
            }
            case 'X': 
            case 'x': {
                return X;
            }
            case 'U': 
            case 'u': {
                return U;
            }
            case 'J': 
            case 'j': {
                return J;
            }
            case 'O': 
            case 'o': {
                return O;
            }
        }
        throw new IllegalArgumentException("No amino acid found for letter " + aa + ".");
    }

    public abstract boolean iscombination();

    public char[] getSubAminoAcids() {
        return this.getSubAminoAcids(true);
    }

    public char[] getSubAminoAcids(boolean includeCombinations) {
        if (includeCombinations) {
            return this.subAminoAcidsWithCombination;
        }
        return this.subAminoAcidsWithoutCombination;
    }

    public char[] getCombinations() {
        return this.aminoAcidCombinations;
    }

    public static char getMatchingAminoAcid(char aa, SequenceMatchingPreferences sequenceMatchingPreferences) {
        if (sequenceMatchingPreferences.getSequenceMatchingType() == SequenceMatchingPreferences.MatchingType.indistiguishableAminoAcids && aa == 'L') {
            return 'I';
        }
        return aa;
    }

    public static String getMatchingSequence(String sequence, SequenceMatchingPreferences sequenceMatchingPreferences) {
        if (sequenceMatchingPreferences.getSequenceMatchingType() != SequenceMatchingPreferences.MatchingType.indistiguishableAminoAcids) {
            return sequence;
        }
        char[] aas = sequence.toCharArray();
        for (int i = 0; i < aas.length; ++i) {
            if (aas[i] != 'L') continue;
            aas[i] = 73;
        }
        return new String(aas);
    }

    public String[] getStandardGeneticCode() {
        return this.standardGeneticCode;
    }

    public static AminoAcid getAminoAcidFromGeneticCode(String geneticCode) {
        if (geneticCode.equals("TTT") || geneticCode.equals("TTC")) {
            return F;
        }
        if (geneticCode.equals("TTA") || geneticCode.equals("TTG") || geneticCode.equals("CTT") || geneticCode.equals("CTC") || geneticCode.equals("CTA") || geneticCode.equals("CTG")) {
            return L;
        }
        if (geneticCode.equals("ATT") || geneticCode.equals("ATC") || geneticCode.equals("ATA")) {
            return I;
        }
        if (geneticCode.equals("ATG")) {
            return M;
        }
        if (geneticCode.startsWith("GT")) {
            return V;
        }
        if (geneticCode.startsWith("TC")) {
            return S;
        }
        if (geneticCode.startsWith("CC")) {
            return P;
        }
        if (geneticCode.startsWith("AC")) {
            return T;
        }
        if (geneticCode.startsWith("GC")) {
            return A;
        }
        if (geneticCode.equals("TAT") || geneticCode.equals("TAC")) {
            return Y;
        }
        if (geneticCode.equals("CAT") || geneticCode.equals("CAC")) {
            return H;
        }
        if (geneticCode.equals("CAA") || geneticCode.equals("CAG")) {
            return Q;
        }
        if (geneticCode.equals("AAT") || geneticCode.equals("AAC")) {
            return N;
        }
        if (geneticCode.equals("AAA") || geneticCode.equals("AAG")) {
            return K;
        }
        if (geneticCode.equals("GAT") || geneticCode.equals("GAC")) {
            return D;
        }
        if (geneticCode.equals("GAA") || geneticCode.equals("GAG")) {
            return E;
        }
        if (geneticCode.equals("TGT") || geneticCode.equals("TGC")) {
            return C;
        }
        if (geneticCode.equals("TGG")) {
            return W;
        }
        if (geneticCode.startsWith("CG")) {
            return R;
        }
        if (geneticCode.equals("AGT") || geneticCode.equals("AGC")) {
            return S;
        }
        if (geneticCode.equals("AGA") || geneticCode.equals("AGG")) {
            return R;
        }
        if (geneticCode.startsWith("GG")) {
            return G;
        }
        if (geneticCode.equals("TAG")) {
            return O;
        }
        if (geneticCode.equals("TGA")) {
            return U;
        }
        return null;
    }

    protected String[] getStandardGeneticCodeForCombination() {
        ArrayList<String> uniqueCodes = new ArrayList<String>();
        for (char aa : this.getSubAminoAcids()) {
            AminoAcid aminoAcid = AminoAcid.getAminoAcid(aa);
            if (aminoAcid.iscombination()) continue;
            for (String code : aminoAcid.getStandardGeneticCode()) {
                if (uniqueCodes.contains(code)) continue;
                uniqueCodes.add(code);
            }
        }
        return uniqueCodes.toArray(new String[uniqueCodes.size()]);
    }

    public AtomChain getMonoisotopicAtomChain() {
        return this.monoisotopicAtomChain;
    }

    public double getMonoisotopicMass() {
        if (this.monoisotopicAtomChain == null) {
            return this.monoisotopicMass;
        }
        return this.monoisotopicAtomChain.getMass();
    }

    public abstract double getHydrophobicity();

    public abstract double getHelicity();

    public abstract double getBasicity();

    public abstract double getPI();

    public abstract double getPK1();

    public abstract double getPK2();

    public abstract double getPKa();

    public abstract int getVanDerWaalsVolume();

    public double getProperty(Property property) {
        switch (property) {
            case mass: {
                return this.getMonoisotopicMass();
            }
            case hydrophobicity: {
                return this.getHydrophobicity();
            }
            case helicity: {
                return this.getHelicity();
            }
            case basicity: {
                return this.getBasicity();
            }
            case pI: {
                return this.getPI();
            }
            case pK1: {
                return this.getPK1();
            }
            case pK2: {
                return this.getPK2();
            }
            case pKa: {
                return this.getPKa();
            }
            case vanDerWaalsVolume: {
                return this.getVanDerWaalsVolume();
            }
        }
        throw new UnsupportedOperationException("Property " + (Object)((Object)property) + " not implemented.");
    }

    public static int getNUnique() {
        return 22;
    }

    public static int getUniqueIndex(char aa) {
        int index = aa - 65;
        return aaIndexes[index];
    }

    public static int getIndex(char aa) {
        return aa - 65;
    }

    public static boolean isAa(char aa) {
        char aaInt = aa;
        return aaInt >= 'A' && aaInt <= 'Z';
    }

    public static boolean isUniqueAa(char aa) {
        char aaInt = aa;
        return aaInt >= 'A' && aaInt <= 'Z' && aaInt != 'B' && aaInt != 'J' && aaInt != 'X';
    }

    public boolean equals(Object obj) {
        if (obj instanceof AminoAcid) {
            return ((AminoAcid)obj).singleLetterCode.equalsIgnoreCase(this.singleLetterCode);
        }
        return false;
    }

    public static enum Property {
        mass("Mass"),
        hydrophobicity("Hydrophobicity"),
        helicity("Helicity"),
        basicity("Basicity"),
        pI("pI"),
        pK1("pK1"),
        pK2("pK2"),
        pKa("pKa"),
        vanDerWaalsVolume("Van der Waals volume");

        public final String name;

        private Property(String name) {
            this.name = name;
        }

        public static int getNProperties() {
            return Property.values().length;
        }

        public Property getProperty(int index) {
            return Property.values()[index];
        }
    }
}

