/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology;

import com.compomics.util.experiment.biology.Atom;
import com.compomics.util.experiment.biology.AtomImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class AtomChain
implements Serializable {
    static final long serialVersionUID = 2222259572093523514L;
    private ArrayList<AtomImpl> atomChain = new ArrayList(4);
    private Double mass = null;
    private double mass1 = -1.0;
    private String stringValue = null;
    private String stringValue1 = null;

    public static AtomChain getAtomChain(String atomChainAsString) {
        AtomChain atomChain = new AtomChain();
        char[] atomChainAsStringCharArray = atomChainAsString.toCharArray();
        for (int i = 0; i < atomChainAsStringCharArray.length; ++i) {
            char character = atomChainAsStringCharArray[i];
            if (character == ' ') continue;
            if (character == '-') {
                throw new IllegalArgumentException("Negative isotope found in " + atomChainAsString + ". Please use the atom number, e.g. 13 for 13C.");
            }
            Integer isotopeNumber = 0;
            int charAsInt = Character.getNumericValue(character);
            while (charAsInt >= 0 && charAsInt <= 9) {
                isotopeNumber = 10 * isotopeNumber + charAsInt;
                if (++i == atomChainAsStringCharArray.length) {
                    throw new IllegalArgumentException("Reached the end of the atom chain while parsing isotope number in " + atomChainAsString + ".");
                }
                character = atomChainAsStringCharArray[i];
                charAsInt = Character.getNumericValue(character);
            }
            StringBuilder atomName = new StringBuilder();
            atomName.append(character);
            Integer occurrence = null;
            if (i + 1 < atomChainAsStringCharArray.length) {
                char nextCharacter = atomChainAsStringCharArray[i + 1];
                while (Character.isLowerCase(nextCharacter)) {
                    atomName.append(nextCharacter);
                    if (++i + 1 >= atomChainAsStringCharArray.length) break;
                    nextCharacter = atomChainAsStringCharArray[i + 1];
                }
                if (nextCharacter == '(') {
                    ++i;
                    if (++i == atomChainAsStringCharArray.length) {
                        throw new IllegalArgumentException("Reached the end of the atom chain while parsing occurrence of " + atomName + " in " + atomChainAsString + ".");
                    }
                    character = atomChainAsStringCharArray[i];
                    if (character == '-') {
                        throw new IllegalArgumentException("Negative occurrence found for " + atomName + " in " + atomChainAsString + ".");
                    }
                    while (character != ')') {
                        charAsInt = Character.getNumericValue(character);
                        if (charAsInt < 0 || charAsInt > 9) {
                            throw new IllegalArgumentException("Encountered unexpected character " + character + " while parsing occurrence of " + atomName + " in " + atomChainAsString + ".");
                        }
                        occurrence = occurrence == null ? Integer.valueOf(charAsInt) : Integer.valueOf(10 * occurrence + charAsInt);
                        if (++i == atomChainAsStringCharArray.length) {
                            throw new IllegalArgumentException("Reached the end of the atom chain while parsing occurrence of " + atomName + " in " + atomChainAsString + ".");
                        }
                        character = atomChainAsStringCharArray[i];
                    }
                }
            }
            if (occurrence == null) {
                occurrence = 1;
            }
            Atom atom = Atom.getAtom(atomName.toString());
            AtomImpl atomImpl = new AtomImpl(atom, isotopeNumber);
            if (isotopeNumber != 0) {
                if ((isotopeNumber = atomImpl.getIsotopeNumber(isotopeNumber)) == null) {
                    throw new UnsupportedOperationException("An error occurred while parsing atom chain " + atomChainAsString + "Isotope " + isotopeNumber + " not supported for atom " + atom + ".");
                }
                atomImpl.setIsotope(isotopeNumber);
            }
            atomChain.append(atomImpl, occurrence);
        }
        return atomChain;
    }

    public void append(AtomImpl atom) {
        this.atomChain.add(atom);
        this.stringValue1 = null;
    }

    public void append(AtomImpl atom, int occurrence) {
        if (occurrence < 0) {
            throw new IllegalArgumentException("Negative occurrence");
        }
        for (int i = 0; i < occurrence; ++i) {
            this.atomChain.add(atom);
        }
        this.stringValue1 = null;
    }

    public ArrayList<AtomImpl> getAtomChain() {
        return this.atomChain;
    }

    public double getMass() {
        if (this.mass1 == -1.0) {
            this.estimateMass();
        }
        return this.mass1;
    }

    public int size() {
        return this.atomChain.size();
    }

    private synchronized void estimateMass() {
        if (this.mass1 == -1.0) {
            double tempMass = 0.0;
            for (AtomImpl atom : this.atomChain) {
                tempMass += atom.getMass().doubleValue();
            }
            this.mass1 = tempMass;
        }
    }

    private synchronized String getStringValue(boolean includeSpaces) {
        if (this.stringValue1 == null) {
            HashMap<String, Integer> composition = new HashMap<String, Integer>(this.atomChain.size());
            HashMap<String, HashMap<Integer, String>> isotopeMap = new HashMap<String, HashMap<Integer, String>>(this.atomChain.size());
            for (AtomImpl atomImpl : this.atomChain) {
                String atomImplName = atomImpl.toString();
                Integer occurrence = (Integer)composition.get(atomImplName);
                if (occurrence == null) {
                    occurrence = 0;
                }
                composition.put(atomImplName, occurrence + 1);
                String atomSymbol = atomImpl.getAtomSymbol();
                HashMap<Integer, String> atomIsotopes = (HashMap<Integer, String>)isotopeMap.get(atomSymbol);
                if (atomIsotopes == null) {
                    atomIsotopes = new HashMap<Integer, String>(1);
                    isotopeMap.put(atomSymbol, atomIsotopes);
                }
                Integer isotope = atomImpl.getIsotope();
                atomIsotopes.put(isotope, atomImplName);
            }
            StringBuilder compositionAsString = new StringBuilder(composition.size());
            ArrayList atomNames = new ArrayList(isotopeMap.keySet());
            Collections.sort(atomNames);
            for (String atomLetter : atomNames) {
                HashMap atomIsotopes = (HashMap)isotopeMap.get(atomLetter);
                ArrayList isotopes = new ArrayList(atomIsotopes.keySet());
                Collections.sort(isotopes);
                for (Integer isotope : isotopes) {
                    String atomName = (String)atomIsotopes.get(isotope);
                    if (includeSpaces && compositionAsString.length() > 0) {
                        compositionAsString.append(" ");
                    }
                    compositionAsString.append(atomName);
                    Integer occurrence = (Integer)composition.get(atomName);
                    if (occurrence <= 1) continue;
                    compositionAsString.append("(").append(occurrence).append(")");
                }
            }
            this.stringValue1 = compositionAsString.toString();
        }
        return this.stringValue1;
    }

    public int getOccurrence(Atom atom, Integer isotope) {
        int occurrence = 0;
        AtomImpl atom1 = new AtomImpl(atom, isotope);
        for (AtomImpl atom2 : this.atomChain) {
            if (!atom1.isSameAs(atom2)) continue;
            ++occurrence;
        }
        return occurrence;
    }

    public void remove(Atom atom, Integer isotope) {
        ArrayList<AtomImpl> newAtomChain = new ArrayList<AtomImpl>(this.atomChain.size());
        AtomImpl atom1 = new AtomImpl(atom, isotope);
        for (AtomImpl atom2 : this.atomChain) {
            if (atom1.isSameAs(atom2)) continue;
            newAtomChain.add(atom2);
        }
        this.atomChain = newAtomChain;
        this.mass1 = -1.0;
        this.stringValue1 = null;
    }

    public void setOccurrence(Atom atom, Integer isotope, Integer occurrence) {
        this.remove(atom, isotope);
        this.append(new AtomImpl(atom, isotope), occurrence);
        this.mass1 = -1.0;
        this.stringValue1 = null;
    }

    public boolean isSameCompositionAs(AtomChain anotherChain) {
        if (!this.atomChain.isEmpty() && (anotherChain == null || anotherChain.getAtomChain().isEmpty())) {
            return false;
        }
        if (this.atomChain.isEmpty() && anotherChain == null) {
            return true;
        }
        return anotherChain.toString().equals(this.toString());
    }

    public String toString() {
        if (this.stringValue1 == null) {
            return this.getStringValue(false);
        }
        return this.stringValue1;
    }

    public AtomChain clone() {
        AtomChain result = new AtomChain();
        for (AtomImpl atom : this.atomChain) {
            result.append(new AtomImpl(atom.getAtomSymbol(), atom.getIsotope()));
        }
        return result;
    }
}

