/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.peptide_fragmentation.models.ms2pip.features_configuration;

import com.compomics.util.experiment.identification.peptide_fragmentation.models.ms2pip.features_configuration.Ms2pipFeature;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;

public class FeaturesMap {
    public static final int currentVersion = 0;
    private final int version = 0;
    private final HashMap<String, Ms2pipFeature[]> featuresMap = new HashMap(4);
    private String[] sortedFeaturesList;
    private int nFeatures = 0;

    public FeaturesMap() {
        Class[] implementations = Ms2pipFeature.implementations;
        this.sortedFeaturesList = new String[implementations.length];
        for (int i = 0; i < implementations.length; ++i) {
            Class implementedFeature = implementations[i];
            String featureName = implementedFeature.getSimpleName();
            this.featuresMap.put(featureName, new Ms2pipFeature[0]);
            this.sortedFeaturesList[i] = featureName;
        }
    }

    public int getVersion() {
        return 0;
    }

    public void addFeature(Ms2pipFeature ms2pipFeature) {
        String category = ms2pipFeature.getCategory();
        Ms2pipFeature[] categoryFeatures = this.featuresMap.get(category);
        categoryFeatures = Arrays.copyOf(categoryFeatures, categoryFeatures.length + 1);
        categoryFeatures[categoryFeatures.length - 1] = ms2pipFeature;
        this.featuresMap.put(category, categoryFeatures);
        ++this.nFeatures;
    }

    public Set<String> getCategories() {
        return this.featuresMap.keySet();
    }

    public String[] getSortedFeaturesList() {
        return this.sortedFeaturesList;
    }

    public Ms2pipFeature[] getFeatures(String category) {
        return this.featuresMap.get(category);
    }

    public int getnFeatures() {
        return this.nFeatures;
    }
}

