/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.peptide_fragmentation.models.ms2pip.features_generation;

import com.compomics.util.experiment.biology.AminoAcid;
import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.PTMFactory;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.peptide_fragmentation.models.ms2pip.features_configuration.FeaturesMap;
import com.compomics.util.experiment.identification.peptide_fragmentation.models.ms2pip.features_configuration.Ms2pipFeature;
import com.compomics.util.experiment.identification.peptide_fragmentation.models.ms2pip.features_configuration.MultipleAAPropertyFeature;
import com.compomics.util.experiment.identification.peptide_fragmentation.models.ms2pip.features_configuration.SingleAAPropertyFeature;
import com.compomics.util.experiment.identification.peptide_fragmentation.models.ms2pip.features_configuration.features.AAIdentityFeatureAbsolute;
import com.compomics.util.experiment.identification.peptide_fragmentation.models.ms2pip.features_configuration.features.AAIdentityFeatureRelative;
import com.compomics.util.experiment.identification.peptide_fragmentation.models.ms2pip.features_configuration.features.AAPropertyFeatureAbsolute;
import com.compomics.util.experiment.identification.peptide_fragmentation.models.ms2pip.features_configuration.features.AAPropertyFeatureRelative;
import com.compomics.util.experiment.identification.peptide_fragmentation.models.ms2pip.features_configuration.features.AAPropertyRelationshipFeature;
import com.compomics.util.experiment.identification.peptide_fragmentation.models.ms2pip.features_configuration.features.ComplementaryIonAminoAcidFeature;
import com.compomics.util.experiment.identification.peptide_fragmentation.models.ms2pip.features_configuration.features.ComplementaryIonFeature;
import com.compomics.util.experiment.identification.peptide_fragmentation.models.ms2pip.features_configuration.features.ForwardIonAminoAcidFeature;
import com.compomics.util.experiment.identification.peptide_fragmentation.models.ms2pip.features_configuration.features.ForwardIonFeature;
import com.compomics.util.experiment.identification.peptide_fragmentation.models.ms2pip.features_configuration.features.ModificationFeature;
import com.compomics.util.experiment.identification.peptide_fragmentation.models.ms2pip.features_configuration.features.PeptideAminoAcidFeature;
import com.compomics.util.experiment.identification.peptide_fragmentation.models.ms2pip.features_configuration.features.PeptideFeature;
import com.compomics.util.experiment.identification.peptide_fragmentation.models.ms2pip.features_configuration.features.generic.AAPropertyFeature;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public class FeaturesGenerator {
    private PTMFactory ptmFactory = PTMFactory.getInstance();
    private final FeaturesMap featuresMap;

    public FeaturesGenerator(FeaturesMap featuresMap) {
        this.featuresMap = featuresMap;
    }

    public int[] getForwardIonsFeatures(Peptide peptide, int charge, int ionIndex) {
        char[] peptideSequence = peptide.getSequence().toCharArray();
        ArrayList<ModificationMatch> modificationMatches = peptide.getModificationMatches();
        return this.getIonsFeatures(peptideSequence, modificationMatches, charge, ionIndex);
    }

    public int[] getComplementaryIonsFeatures(Peptide peptide, int charge, int ionIndex) {
        ArrayList<ModificationMatch> reversedModificationMatches;
        char[] peptideSequence = peptide.getSequence().toCharArray();
        int sequenceLength = peptideSequence.length;
        char[] reversedSequence = new char[sequenceLength];
        for (int i = 0; i < sequenceLength; ++i) {
            reversedSequence[i] = peptideSequence[sequenceLength - i - 1];
        }
        ArrayList<ModificationMatch> modificationMatches = peptide.getModificationMatches();
        if (modificationMatches != null) {
            reversedModificationMatches = new ArrayList<ModificationMatch>(modificationMatches.size());
            for (ModificationMatch modificationMatch : modificationMatches) {
                ModificationMatch reversedModificationMatch = new ModificationMatch(modificationMatch.getTheoreticPtm(), modificationMatch.isVariable(), sequenceLength - modificationMatch.getModificationSite() + 1);
                reversedModificationMatches.add(reversedModificationMatch);
            }
        } else {
            reversedModificationMatches = null;
        }
        return this.getIonsFeatures(reversedSequence, reversedModificationMatches, charge, ionIndex);
    }

    private int[] getIonsFeatures(char[] peptideSequence, ArrayList<ModificationMatch> modificationMatches, int charge, int ionIndex) {
        AminoAcid.Property[] peptideProperties = this.getAaProperties(PeptideAminoAcidFeature.class);
        AminoAcid.Property[] forwardIonProperties = this.getAaProperties(ForwardIonAminoAcidFeature.class);
        AminoAcid.Property[] complementaryIonProperties = this.getAaProperties(ComplementaryIonAminoAcidFeature.class);
        AminoAcid.Property[] individualAaProperties = this.getAaProperties(AAPropertyFeatureAbsolute.class, AAPropertyFeatureRelative.class, AAPropertyRelationshipFeature.class);
        PeptideAttributes peptideAttributes = new PeptideAttributes(peptideSequence, modificationMatches, peptideProperties, forwardIonProperties, complementaryIonProperties, individualAaProperties);
        int[] features = new int[this.featuresMap.getnFeatures()];
        int featureIndex = 0;
        for (String category : this.featuresMap.getSortedFeaturesList()) {
            for (Ms2pipFeature ms2pipFeature : this.featuresMap.getFeatures(category)) {
                features[featureIndex++] = this.getFeatureValue(ms2pipFeature, peptideSequence, charge, peptideAttributes, ionIndex);
            }
        }
        return features;
    }

    private AminoAcid.Property[] getAaProperties(Class ... categories) {
        HashSet<Integer> indexes = new HashSet<Integer>(4);
        for (Class category : categories) {
            Ms2pipFeature[] features;
            for (Ms2pipFeature ms2pipFeature : features = this.featuresMap.getFeatures(category.getSimpleName())) {
                if (ms2pipFeature instanceof SingleAAPropertyFeature) {
                    SingleAAPropertyFeature singleAAPropertyFeature = (SingleAAPropertyFeature)((Object)ms2pipFeature);
                    AminoAcid.Property property = singleAAPropertyFeature.getAminoAcidProperty();
                    indexes.add(property.ordinal());
                    continue;
                }
                if (ms2pipFeature instanceof MultipleAAPropertyFeature) {
                    MultipleAAPropertyFeature multipleAAPropertyFeature = (MultipleAAPropertyFeature)((Object)ms2pipFeature);
                    for (AminoAcid.Property property : multipleAAPropertyFeature.getAminoAcidProperties()) {
                        indexes.add(property.ordinal());
                    }
                    continue;
                }
                throw new UnsupportedOperationException("Properties extraction not implemented for feature of class " + ms2pipFeature.getCategory() + ".");
            }
        }
        AminoAcid.Property[] aminoAcidProperties = AminoAcid.Property.values();
        AminoAcid.Property[] peptideAminoAcidProperties = new AminoAcid.Property[indexes.size()];
        int cpt = 0;
        Iterator iterator = indexes.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            peptideAminoAcidProperties[cpt++] = aminoAcidProperties[index];
        }
        return peptideAminoAcidProperties;
    }

    private int getFeatureValue(Ms2pipFeature ms2pipFeature, char[] peptideSequence, int charge, PeptideAttributes peptideAttributes, int aaIndex) {
        switch (ms2pipFeature.getIndex()) {
            case 0: {
                PeptideFeature peptideFeature = (PeptideFeature)ms2pipFeature;
                return this.getPeptideFeature(peptideFeature, peptideSequence.length, charge, peptideAttributes);
            }
            case 1: {
                PeptideAminoAcidFeature peptideAminoAcidFeature = (PeptideAminoAcidFeature)ms2pipFeature;
                return this.getPeptideAminoAcidFeature(peptideAminoAcidFeature, peptideSequence.length, peptideAttributes);
            }
            case 2: {
                ForwardIonFeature forwardIonFeature = (ForwardIonFeature)ms2pipFeature;
                return this.getForwardIonFeature(forwardIonFeature, peptideSequence.length, peptideAttributes, aaIndex);
            }
            case 4: {
                ForwardIonAminoAcidFeature forwardIonAminoAcidFeature = (ForwardIonAminoAcidFeature)ms2pipFeature;
                return this.getForwardIonAminoAcidFeature(forwardIonAminoAcidFeature, peptideAttributes, aaIndex);
            }
            case 3: {
                ComplementaryIonFeature complementaryIonFeature = (ComplementaryIonFeature)ms2pipFeature;
                return this.getComplementaryIonFeature(complementaryIonFeature, peptideSequence.length, peptideAttributes, aaIndex);
            }
            case 5: {
                ComplementaryIonAminoAcidFeature complementaryIonAminoAcidFeature = (ComplementaryIonAminoAcidFeature)ms2pipFeature;
                return this.getComplementaryIonAminoAcidFeature(complementaryIonAminoAcidFeature, peptideSequence.length, peptideAttributes, aaIndex);
            }
            case 6: {
                AAPropertyFeatureAbsolute aaPropertyFeatureAbsolute = (AAPropertyFeatureAbsolute)ms2pipFeature;
                return this.getAAPropertyFeatureAbsolute(aaPropertyFeatureAbsolute, peptideSequence.length, peptideAttributes);
            }
            case 7: {
                AAPropertyFeatureRelative aaPropertyFeatureRelative = (AAPropertyFeatureRelative)ms2pipFeature;
                return this.getAAPropertyFeatureRelative(aaPropertyFeatureRelative, peptideSequence.length, peptideAttributes, aaIndex);
            }
            case 8: {
                AAPropertyRelationshipFeature aaPropertyRelationshipFeature = (AAPropertyRelationshipFeature)ms2pipFeature;
                return this.getAAPropertyRelationshipFeature(aaPropertyRelationshipFeature, peptideSequence.length, peptideAttributes, aaIndex);
            }
            case 9: {
                AAIdentityFeatureAbsolute aaIdentityFeatureAbsolute = (AAIdentityFeatureAbsolute)ms2pipFeature;
                return this.getAAIdentityFeatureAbsolute(aaIdentityFeatureAbsolute, peptideSequence);
            }
            case 10: {
                AAIdentityFeatureRelative aaIdentityFeatureRelative = (AAIdentityFeatureRelative)ms2pipFeature;
                return this.getAAIdentityFeatureRelative(aaIdentityFeatureRelative, peptideSequence, aaIndex);
            }
            case 11: {
                ModificationFeature modificationFeature = (ModificationFeature)ms2pipFeature;
                return this.getModificationFeature(modificationFeature, peptideAttributes, aaIndex);
            }
        }
        throw new UnsupportedOperationException("Feature " + ms2pipFeature.getClass().getSimpleName() + " not implemented.");
    }

    private int getPeptideFeature(PeptideFeature feature, int sequenceLength, int charge, PeptideAttributes peptideAttributes) {
        switch (feature.getProperty()) {
            case charge: {
                return charge;
            }
            case length: {
                return sequenceLength;
            }
            case mass: {
                return (int)peptideAttributes.getPeptideMass();
            }
        }
        throw new UnsupportedOperationException("Feature " + feature.getDescription() + " not implemented.");
    }

    private int getPeptideAminoAcidFeature(PeptideAminoAcidFeature feature, int sequenceLength, PeptideAttributes peptideAttributes) {
        switch (feature.getFunction()) {
            case sum: {
                return (int)peptideAttributes.getSumPeptideAminoAcidProperties(feature.getAminoAcidProperty());
            }
            case mean: {
                double value = peptideAttributes.getSumPeptideAminoAcidProperties(feature.getAminoAcidProperty());
                return (int)(value / (double)sequenceLength);
            }
            case minimum: {
                return (int)peptideAttributes.getMinPeptideAminoAcidProperties(feature.getAminoAcidProperty());
            }
            case maximum: {
                return (int)peptideAttributes.getMaxPeptideAminoAcidProperties(feature.getAminoAcidProperty());
            }
        }
        throw new UnsupportedOperationException("Feature " + feature.getDescription() + " not implemented.");
    }

    private int getForwardIonFeature(ForwardIonFeature feature, int sequenceLength, PeptideAttributes peptideAttributes, int aaIndex) {
        switch (feature.getFeature()) {
            case mass: {
                return (int)peptideAttributes.getForwardIonMass(aaIndex);
            }
            case massOverLength: {
                double value = peptideAttributes.getForwardIonMass(aaIndex);
                int ionLength = aaIndex + 1;
                return (int)(value / (double)ionLength);
            }
            case length: {
                return aaIndex + 1;
            }
            case relativeLength: {
                return (int)(100.0 * (double)(aaIndex + 1) / (double)sequenceLength);
            }
        }
        throw new UnsupportedOperationException("Feature " + feature.getDescription() + " not implemented.");
    }

    private int getForwardIonAminoAcidFeature(ForwardIonAminoAcidFeature feature, PeptideAttributes peptideAttributes, int aaIndex) {
        switch (feature.getFunction()) {
            case sum: {
                return (int)peptideAttributes.getSumForwardIonAminoAcidProperties(feature.getAminoAcidProperty(), aaIndex);
            }
            case mean: {
                double value = peptideAttributes.getSumForwardIonAminoAcidProperties(feature.getAminoAcidProperty(), aaIndex);
                int ionLength = aaIndex + 1;
                return (int)(value / (double)ionLength);
            }
            case minimum: {
                return (int)peptideAttributes.getMinForwardIonAminoAcidProperties(feature.getAminoAcidProperty(), aaIndex);
            }
            case maximum: {
                return (int)peptideAttributes.getMaxForwardIonAminoAcidProperties(feature.getAminoAcidProperty(), aaIndex);
            }
        }
        throw new UnsupportedOperationException("Feature " + feature.getDescription() + " not implemented.");
    }

    private int getComplementaryIonFeature(ComplementaryIonFeature feature, int sequenceLength, PeptideAttributes peptideAttributes, int aaIndex) {
        switch (feature.getFeature()) {
            case mass: {
                double value = peptideAttributes.getPeptideMass() - peptideAttributes.getForwardIonMass(aaIndex);
                return (int)value;
            }
            case massOverLength: {
                double value = peptideAttributes.getPeptideMass() - peptideAttributes.getForwardIonMass(aaIndex);
                int ionLength = sequenceLength - aaIndex - 1;
                return (int)(value / (double)ionLength);
            }
            case length: {
                return aaIndex + 1;
            }
            case relativeLength: {
                int ionLength = sequenceLength - aaIndex - 1;
                return (int)(100.0 * (double)ionLength / (double)sequenceLength);
            }
        }
        throw new UnsupportedOperationException("Feature " + feature.getDescription() + " not implemented.");
    }

    private int getComplementaryIonAminoAcidFeature(ComplementaryIonAminoAcidFeature feature, int sequenceLength, PeptideAttributes peptideAttributes, int aaIndex) {
        switch (feature.getFunction()) {
            case sum: {
                return (int)peptideAttributes.getSumComplementaryIonAminoAcidProperties(feature.getAminoAcidProperty(), aaIndex);
            }
            case mean: {
                double value = peptideAttributes.getSumComplementaryIonAminoAcidProperties(feature.getAminoAcidProperty(), aaIndex);
                int ionLength = sequenceLength - aaIndex - 1;
                return (int)(value / (double)ionLength);
            }
            case minimum: {
                return (int)peptideAttributes.getMinComplementaryIonAminoAcidProperties(feature.getAminoAcidProperty(), aaIndex);
            }
            case maximum: {
                return (int)peptideAttributes.getMaxComplementaryIonAminoAcidProperties(feature.getAminoAcidProperty(), aaIndex);
            }
        }
        throw new UnsupportedOperationException("Feature " + feature.getDescription() + " not implemented.");
    }

    private int getAAPropertyFeatureAbsolute(AAPropertyFeatureAbsolute feature, int sequenceLength, PeptideAttributes peptideAttributes) {
        int sequenceIndex = this.getSequenceIndexAbsolute(feature.getAaIndex(), sequenceLength);
        return (int)peptideAttributes.getAminoAcidProperties(feature.getAminoAcidProperty(), sequenceIndex);
    }

    private int getAAPropertyFeatureRelative(AAPropertyFeatureRelative feature, int sequenceLength, PeptideAttributes peptideAttributes, int aaIndex) {
        int sequenceIndex = this.getSequenceIndexRelative(feature.getAaIndex(), sequenceLength, aaIndex);
        return (int)peptideAttributes.getAminoAcidProperties(feature.getAminoAcidProperty(), sequenceIndex);
    }

    private int getAAPropertyRelationshipFeature(AAPropertyRelationshipFeature feature, int sequenceLength, PeptideAttributes peptideAttributes, int aaIndex) {
        double value2;
        double value1;
        int sequenceIndex;
        AAPropertyFeature subFeature;
        AAPropertyFeature aaPropertyFeature1 = feature.getAminoAcidFeature1();
        if (aaPropertyFeature1 instanceof AAPropertyFeatureAbsolute) {
            subFeature = (AAPropertyFeatureAbsolute)aaPropertyFeature1;
            sequenceIndex = this.getSequenceIndexAbsolute(subFeature.getAaIndex(), sequenceLength);
            value1 = peptideAttributes.getAminoAcidProperties(subFeature.getAminoAcidProperty(), sequenceIndex);
        } else if (aaPropertyFeature1 instanceof AAPropertyFeatureRelative) {
            subFeature = (AAPropertyFeatureRelative)aaPropertyFeature1;
            sequenceIndex = this.getSequenceIndexRelative(subFeature.getAaIndex(), sequenceLength, aaIndex);
            value1 = peptideAttributes.getAminoAcidProperties(subFeature.getAminoAcidProperty(), sequenceIndex);
        } else {
            throw new UnsupportedOperationException("Feature " + aaPropertyFeature1.getDescription() + " not implemented.");
        }
        AAPropertyFeature aaPropertyFeature2 = feature.getAminoAcidFeature2();
        if (aaPropertyFeature2 instanceof AAPropertyFeatureAbsolute) {
            AAPropertyFeatureAbsolute subFeature2 = (AAPropertyFeatureAbsolute)aaPropertyFeature2;
            int sequenceIndex2 = this.getSequenceIndexAbsolute(subFeature2.getAaIndex(), sequenceLength);
            value2 = peptideAttributes.getAminoAcidProperties(subFeature2.getAminoAcidProperty(), sequenceIndex2);
        } else if (aaPropertyFeature2 instanceof AAPropertyFeatureRelative) {
            AAPropertyFeatureRelative subFeature3 = (AAPropertyFeatureRelative)aaPropertyFeature2;
            int sequenceIndex3 = this.getSequenceIndexRelative(subFeature3.getAaIndex(), sequenceLength, aaIndex);
            value2 = peptideAttributes.getAminoAcidProperties(subFeature3.getAminoAcidProperty(), sequenceIndex3);
        } else {
            throw new UnsupportedOperationException("Feature " + aaPropertyFeature2.getDescription() + " not implemented.");
        }
        switch (feature.getRelationship()) {
            case addition: {
                return (int)(value1 + value2);
            }
            case multiplication: {
                return (int)(value1 * value2);
            }
            case subtraction: {
                return (int)(value1 - value2);
            }
        }
        throw new UnsupportedOperationException("Operation " + (Object)((Object)feature.getRelationship()) + " not implemented.");
    }

    private int getAAIdentityFeatureAbsolute(AAIdentityFeatureAbsolute feature, char[] peptideSequence) {
        int sequenceIndex = this.getSequenceIndexAbsolute(feature.getAaIndex(), peptideSequence.length);
        return peptideSequence[sequenceIndex] == feature.getAminoAcid() ? 1 : 0;
    }

    private int getAAIdentityFeatureRelative(AAIdentityFeatureRelative feature, char[] peptideSequence, int aaIndex) {
        int sequenceIndex = this.getSequenceIndexRelative(feature.getAaIndex(), peptideSequence.length, aaIndex);
        return peptideSequence[sequenceIndex] == feature.getAminoAcid() ? 1 : 0;
    }

    private int getModificationFeature(ModificationFeature feature, PeptideAttributes peptideAttributes, int aaIndex) {
        switch (feature.getProperty()) {
            case mass: {
                return (int)peptideAttributes.getModificationMass(aaIndex);
            }
        }
        throw new UnsupportedOperationException("Feature " + feature.getDescription() + " not implemented.");
    }

    private int getSequenceIndexAbsolute(int featureIndex, int sequenceLength) {
        int sequenceIndex = featureIndex;
        if (sequenceIndex < 0) {
            sequenceIndex = sequenceLength + sequenceIndex;
        }
        return sequenceIndex;
    }

    private int getSequenceIndexRelative(int featureIndex, int sequenceLength, int aaIndex) {
        int sequenceIndex = aaIndex + featureIndex;
        if (sequenceIndex < 0) {
            sequenceIndex = 0;
        }
        if (sequenceIndex >= sequenceLength) {
            sequenceIndex = sequenceLength - 1;
        }
        return sequenceIndex;
    }

    private class PeptideAttributes {
        private double peptideMass = 0.0;
        private double[] minPeptideAminoAcidProperties;
        private double[] maxPeptideAminoAcidProperties;
        private double[] sumPeptideAminoAcidProperties;
        private double[][] minForwardIonAminoAcidProperties;
        private double[][] maxForwardIonAminoAcidProperties;
        private double[][] sumForwardIonAminoAcidProperties;
        private double[][] minComplementaryIonAminoAcidProperties;
        private double[][] maxComplementaryIonAminoAcidProperties;
        private double[][] sumComplementaryIonAminoAcidProperties;
        private double[] forwardIonMass;
        private double[][] aminoAcidProperties;
        private double[] modificationsMasses;

        private PeptideAttributes(char[] peptideSequence, ArrayList<ModificationMatch> modificationMatches, AminoAcid.Property[] peptideAminoAcidProperties, AminoAcid.Property[] forwardIonAminoAcidProperties, AminoAcid.Property[] complementaryIonAminoAcidProperties, AminoAcid.Property[] individualAminoAcidProperties) {
            double value;
            int nPossibleProperties = AminoAcid.Property.getNProperties();
            this.minPeptideAminoAcidProperties = new double[nPossibleProperties];
            this.maxPeptideAminoAcidProperties = new double[nPossibleProperties];
            this.sumPeptideAminoAcidProperties = new double[nPossibleProperties];
            this.minForwardIonAminoAcidProperties = new double[peptideSequence.length][nPossibleProperties];
            this.maxForwardIonAminoAcidProperties = new double[peptideSequence.length][nPossibleProperties];
            this.sumForwardIonAminoAcidProperties = new double[peptideSequence.length][nPossibleProperties];
            this.minComplementaryIonAminoAcidProperties = new double[peptideSequence.length][nPossibleProperties];
            this.maxComplementaryIonAminoAcidProperties = new double[peptideSequence.length][nPossibleProperties];
            this.sumComplementaryIonAminoAcidProperties = new double[peptideSequence.length][nPossibleProperties];
            this.forwardIonMass = new double[peptideSequence.length];
            this.modificationsMasses = new double[peptideSequence.length];
            this.aminoAcidProperties = new double[peptideSequence.length][nPossibleProperties];
            char aa = peptideSequence[0];
            AminoAcid aminoAcid = AminoAcid.getAminoAcid(aa);
            this.peptideMass += aminoAcid.getMonoisotopicMass();
            this.forwardIonMass[0] = this.peptideMass;
            for (AminoAcid.Property property : peptideAminoAcidProperties) {
                this.minPeptideAminoAcidProperties[property.ordinal()] = value = aminoAcid.getProperty(property);
                this.maxPeptideAminoAcidProperties[property.ordinal()] = value;
                this.sumPeptideAminoAcidProperties[property.ordinal()] = value;
            }
            for (AminoAcid.Property property : forwardIonAminoAcidProperties) {
                this.minForwardIonAminoAcidProperties[0][property.ordinal()] = value = aminoAcid.getProperty(property);
                this.maxForwardIonAminoAcidProperties[0][property.ordinal()] = value;
                this.sumForwardIonAminoAcidProperties[0][property.ordinal()] = value;
            }
            for (AminoAcid.Property property : individualAminoAcidProperties) {
                this.aminoAcidProperties[0][property.ordinal()] = value = aminoAcid.getProperty(property);
            }
            aa = peptideSequence[peptideSequence.length - 1];
            aminoAcid = AminoAcid.getAminoAcid(aa);
            for (AminoAcid.Property property : complementaryIonAminoAcidProperties) {
                this.minComplementaryIonAminoAcidProperties[peptideSequence.length - 1][property.ordinal()] = value = aminoAcid.getProperty(property);
                this.maxComplementaryIonAminoAcidProperties[peptideSequence.length - 1][property.ordinal()] = value;
                this.sumComplementaryIonAminoAcidProperties[peptideSequence.length - 1][property.ordinal()] = value;
            }
            for (int forwardI = 1; forwardI < peptideSequence.length; ++forwardI) {
                double value2;
                aa = peptideSequence[forwardI];
                aminoAcid = AminoAcid.getAminoAcid(aa);
                this.peptideMass += aminoAcid.getMonoisotopicMass();
                this.forwardIonMass[forwardI] = this.peptideMass;
                for (AminoAcid.Property property : peptideAminoAcidProperties) {
                    value2 = aminoAcid.getProperty(property);
                    if (value2 < this.minPeptideAminoAcidProperties[property.ordinal()]) {
                        this.minPeptideAminoAcidProperties[property.ordinal()] = value2;
                    }
                    if (value2 > this.maxPeptideAminoAcidProperties[property.ordinal()]) {
                        this.maxPeptideAminoAcidProperties[property.ordinal()] = value2;
                    }
                    int n = property.ordinal();
                    this.sumPeptideAminoAcidProperties[n] = this.sumPeptideAminoAcidProperties[n] + value2;
                }
                for (AminoAcid.Property property : forwardIonAminoAcidProperties) {
                    value2 = aminoAcid.getProperty(property);
                    double previousValue = this.minForwardIonAminoAcidProperties[forwardI - 1][property.ordinal()];
                    this.minForwardIonAminoAcidProperties[forwardI][property.ordinal()] = value2 < previousValue ? value2 : previousValue;
                    previousValue = this.maxForwardIonAminoAcidProperties[forwardI - 1][property.ordinal()];
                    this.maxForwardIonAminoAcidProperties[forwardI][property.ordinal()] = value2 > previousValue ? value2 : previousValue;
                    this.sumForwardIonAminoAcidProperties[forwardI][property.ordinal()] = this.sumForwardIonAminoAcidProperties[forwardI - 1][property.ordinal()] + value2;
                }
                for (AminoAcid.Property property : individualAminoAcidProperties) {
                    this.aminoAcidProperties[forwardI][property.ordinal()] = value2 = aminoAcid.getProperty(property);
                }
                int complementaryI = peptideSequence.length - 1 - forwardI;
                aa = peptideSequence[complementaryI];
                aminoAcid = AminoAcid.getAminoAcid(aa);
                for (AminoAcid.Property property : complementaryIonAminoAcidProperties) {
                    double value3 = aminoAcid.getProperty(property);
                    double previousValue = this.minComplementaryIonAminoAcidProperties[complementaryI + 1][property.ordinal()];
                    this.minComplementaryIonAminoAcidProperties[complementaryI][property.ordinal()] = value3 < previousValue ? value3 : previousValue;
                    previousValue = this.maxComplementaryIonAminoAcidProperties[complementaryI + 1][property.ordinal()];
                    this.maxComplementaryIonAminoAcidProperties[complementaryI][property.ordinal()] = value3 > previousValue ? value3 : previousValue;
                    this.sumComplementaryIonAminoAcidProperties[complementaryI][property.ordinal()] = this.sumComplementaryIonAminoAcidProperties[complementaryI + 1][property.ordinal()] + value3;
                }
            }
            if (modificationMatches != null) {
                for (ModificationMatch modificationMatch : modificationMatches) {
                    String modificationName = modificationMatch.getTheoreticPtm();
                    PTM modification = FeaturesGenerator.this.ptmFactory.getPTM(modificationName);
                    double modificationMass = modification.getMass();
                    int modificationSite = modificationMatch.getModificationSite();
                    this.peptideMass += modificationMass;
                    int n = modificationSite - 1;
                    this.modificationsMasses[n] = this.modificationsMasses[n] + modificationMass;
                    int i = modificationSite - 1;
                    while (i < peptideSequence.length) {
                        int n2 = i++;
                        this.forwardIonMass[n2] = this.forwardIonMass[n2] + modificationMass;
                    }
                }
            }
        }

        public double getPeptideMass() {
            return this.peptideMass;
        }

        public double getMinPeptideAminoAcidProperties(AminoAcid.Property property) {
            return this.minPeptideAminoAcidProperties[property.ordinal()];
        }

        public double getMaxPeptideAminoAcidProperties(AminoAcid.Property property) {
            return this.maxPeptideAminoAcidProperties[property.ordinal()];
        }

        public double getSumPeptideAminoAcidProperties(AminoAcid.Property property) {
            return this.sumPeptideAminoAcidProperties[property.ordinal()];
        }

        public double getMinForwardIonAminoAcidProperties(AminoAcid.Property property, int aaIndex) {
            return this.minForwardIonAminoAcidProperties[aaIndex][property.ordinal()];
        }

        public double getMaxForwardIonAminoAcidProperties(AminoAcid.Property property, int aaIndex) {
            return this.maxForwardIonAminoAcidProperties[aaIndex][property.ordinal()];
        }

        public double getSumForwardIonAminoAcidProperties(AminoAcid.Property property, int aaIndex) {
            return this.sumForwardIonAminoAcidProperties[aaIndex][property.ordinal()];
        }

        public double getMinComplementaryIonAminoAcidProperties(AminoAcid.Property property, int aaIndex) {
            return this.minComplementaryIonAminoAcidProperties[aaIndex][property.ordinal()];
        }

        public double getMaxComplementaryIonAminoAcidProperties(AminoAcid.Property property, int aaIndex) {
            return this.maxComplementaryIonAminoAcidProperties[aaIndex][property.ordinal()];
        }

        public double getSumComplementaryIonAminoAcidProperties(AminoAcid.Property property, int aaIndex) {
            return this.sumComplementaryIonAminoAcidProperties[aaIndex][property.ordinal()];
        }

        public double getForwardIonMass(int aaIndex) {
            return this.forwardIonMass[aaIndex];
        }

        public double getAminoAcidProperties(AminoAcid.Property property, int aaIndex) {
            return this.aminoAcidProperties[aaIndex][property.ordinal()];
        }

        public double getModificationMass(int aaIndex) {
            return this.modificationsMasses[aaIndex];
        }
    }
}

