/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.identifications.idfilereaders;

import com.compomics.util.Util;
import com.compomics.util.experiment.biology.AminoAcidSequence;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.amino_acid_tags.Tag;
import com.compomics.util.experiment.identification.identification_parameters.SearchParameters;
import com.compomics.util.experiment.identification.identification_parameters.tool_specific.PNovoParameters;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.spectrum_assumptions.TagAssumption;
import com.compomics.util.experiment.io.identifications.IdfileReader;
import com.compomics.util.experiment.massspectrometry.Charge;
import com.compomics.util.experiment.massspectrometry.Spectrum;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.preferences.SequenceMatchingPreferences;
import com.compomics.util.waiting.WaitingHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URLDecoder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import javax.xml.bind.JAXBException;
import uk.ac.ebi.pride.tools.braf.BufferedRandomAccessFile;

public class PNovoIdfileReader
extends ExperimentObject
implements IdfileReader {
    private HashMap<String, Long> index;
    private BufferedRandomAccessFile bufferedRandomAccessFile = null;
    private String fileName;

    public PNovoIdfileReader() {
    }

    public PNovoIdfileReader(File identificationFile) throws FileNotFoundException, IOException {
        this(identificationFile, null);
    }

    public PNovoIdfileReader(File identificationFile, WaitingHandler waitingHandler) throws FileNotFoundException, IOException {
        String line;
        long progressUnit;
        this.bufferedRandomAccessFile = new BufferedRandomAccessFile(identificationFile, "r", 102400);
        this.fileName = Util.getFileName(identificationFile);
        if (waitingHandler != null) {
            waitingHandler.resetSecondaryProgressCounter();
            waitingHandler.setMaxSecondaryProgressCounter(100);
        }
        if ((progressUnit = this.bufferedRandomAccessFile.length() / 100L) == 0L) {
            progressUnit = 1L;
        }
        this.index = new HashMap();
        while ((line = this.bufferedRandomAccessFile.readLine()) != null) {
            if (!line.startsWith("S")) continue;
            long currentIndex = this.bufferedRandomAccessFile.getFilePointer();
            String[] splitLine = line.split("\\t");
            String spectrumTitle = splitLine[1].trim();
            this.index.put(spectrumTitle, currentIndex);
            if (waitingHandler == null) continue;
            if (waitingHandler.isRunCanceled()) break;
            waitingHandler.setSecondaryProgressCounter((int)(currentIndex / progressUnit));
        }
    }

    @Override
    public LinkedList<SpectrumMatch> getAllSpectrumMatches(WaitingHandler waitingHandler, SearchParameters searchParameters) throws IOException, IllegalArgumentException, SQLException, ClassNotFoundException, InterruptedException, JAXBException {
        return this.getAllSpectrumMatches(waitingHandler, searchParameters, null, false);
    }

    @Override
    public LinkedList<SpectrumMatch> getAllSpectrumMatches(WaitingHandler waitingHandler, SearchParameters searchParameters, SequenceMatchingPreferences sequenceMatchingPreferences, boolean expandAaCombinations) throws IOException, IllegalArgumentException, SQLException, ClassNotFoundException, InterruptedException, JAXBException {
        if (this.bufferedRandomAccessFile == null) {
            throw new IllegalStateException("The identification file was not set. Please use the appropriate constructor.");
        }
        LinkedList<SpectrumMatch> spectrumMatches = new LinkedList<SpectrumMatch>();
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(false);
            waitingHandler.resetSecondaryProgressCounter();
            waitingHandler.setMaxSecondaryProgressCounter(this.index.size());
        }
        for (String title : this.index.keySet()) {
            String decodedTitle = URLDecoder.decode(title, "utf-8");
            SpectrumMatch currentMatch = new SpectrumMatch(Spectrum.getSpectrumKey(this.getMgfFileName(), decodedTitle));
            int cpt = 1;
            this.bufferedRandomAccessFile.seek(this.index.get(title).longValue());
            String line = this.bufferedRandomAccessFile.getNextLine().trim();
            boolean solutionsFound = false;
            if (line.startsWith("P")) {
                solutionsFound = true;
            }
            while (line != null && line.startsWith("P")) {
                currentMatch.addHit(Advocate.pNovo.getIndex(), this.getAssumptionFromLine(line, cpt, searchParameters), true);
                ++cpt;
                line = this.bufferedRandomAccessFile.getNextLine();
            }
            if (solutionsFound) {
                spectrumMatches.add(currentMatch);
            }
            if (waitingHandler == null) continue;
            if (waitingHandler.isRunCanceled()) break;
            waitingHandler.increaseSecondaryProgressCounter();
        }
        return spectrumMatches;
    }

    public String getMgfFileName() {
        return this.fileName.substring(0, this.fileName.length() - ".pnovo.txt".length()) + ".mgf";
    }

    @Override
    public String getExtension() {
        return ".pnovo.txt";
    }

    @Override
    public void close() throws IOException {
        this.bufferedRandomAccessFile.close();
    }

    private TagAssumption getAssumptionFromLine(String line, int rank, SearchParameters searchParameters) {
        String[] lineComponents = line.trim().split("\t");
        Double pNovoScore = new Double(lineComponents[2]);
        String pNovoSequence = lineComponents[1];
        String peptideSequence = "";
        ArrayList<ModificationMatch> modificationMatches = new ArrayList<ModificationMatch>();
        PNovoParameters pNovoParameters = (PNovoParameters)searchParameters.getIdentificationAlgorithmParameter(Advocate.pNovo.getIndex());
        if (pNovoParameters != null) {
            for (int i = 0; i < pNovoSequence.length(); ++i) {
                char currentChar = pNovoSequence.charAt(i);
                if (pNovoParameters.getPtmResidue(Character.valueOf(currentChar)) != null) {
                    modificationMatches.add(new ModificationMatch(pNovoParameters.getUtilitiesPtmName(Character.valueOf(currentChar)), true, i + 1));
                    peptideSequence = peptideSequence + pNovoParameters.getPtmResidue(Character.valueOf(currentChar));
                    continue;
                }
                peptideSequence = peptideSequence + currentChar;
            }
        }
        AminoAcidSequence aminoAcidSequence = new AminoAcidSequence(peptideSequence);
        for (ModificationMatch modificationMatch : modificationMatches) {
            aminoAcidSequence.addModificationMatch(modificationMatch.getModificationSite(), modificationMatch);
        }
        Tag tag = new Tag(0.0, aminoAcidSequence, 0.0);
        TagAssumption tagAssumption = new TagAssumption(Advocate.pNovo.getIndex(), rank, tag, new Charge(1, 1), pNovoScore);
        return tagAssumption;
    }

    @Override
    public HashMap<String, ArrayList<String>> getSoftwareVersions() {
        HashMap<String, ArrayList<String>> result = new HashMap<String, ArrayList<String>>();
        ArrayList<String> versions = new ArrayList<String>();
        versions.add("unknown");
        result.put("pNovo+", versions);
        return result;
    }

    @Override
    public boolean hasDeNovoTags() {
        return true;
    }
}

