/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.massspectrometry;

import com.compomics.util.experiment.personalization.ExperimentObject;
import java.util.ArrayList;
import java.util.HashMap;

public class MgfIndex
extends ExperimentObject {
    private HashMap<String, Long> indexMap;
    private HashMap<String, Integer> spectrumNumberIndexMap;
    private ArrayList<String> spectrumTitles = null;
    private HashMap<String, Integer> duplicatedSpectrumTitles = null;
    private HashMap<Integer, Double> precursorMzMap = null;
    private String fileName;
    private Long lastModified;
    private Double maxRT;
    private Double minRT;
    private Double maxMz;
    private Double maxIntensity;
    private Integer maxCharge;
    private Integer maxPeakCount;
    private Boolean peakPicked = null;
    private Integer spectrumCount = null;
    private Boolean precursorChargesMissing = null;

    public MgfIndex(ArrayList<String> spectrumTitles, HashMap<String, Long> indexMap, HashMap<String, Integer> spectrumNumberIndexMap, HashMap<Integer, Double> precursorMzMap, String fileName, double minRT, double maxRT, double maxMz, double maxIntensity, int maxCharge, int maxPeakCount, boolean peakPicked, boolean precursorChargesMissing, long lastModified) {
        this.spectrumTitles = spectrumTitles;
        this.duplicatedSpectrumTitles = null;
        this.indexMap = indexMap;
        this.spectrumNumberIndexMap = spectrumNumberIndexMap;
        this.precursorMzMap = precursorMzMap;
        this.fileName = fileName;
        this.maxRT = maxRT;
        this.minRT = minRT;
        this.maxMz = maxMz;
        this.maxIntensity = maxIntensity;
        this.maxCharge = maxCharge;
        this.maxPeakCount = maxPeakCount;
        this.peakPicked = peakPicked;
        this.precursorChargesMissing = precursorChargesMissing;
        this.lastModified = lastModified;
    }

    public MgfIndex(ArrayList<String> spectrumTitles, HashMap<String, Integer> duplicatedSpectrumTitles, HashMap<String, Long> indexMap, HashMap<String, Integer> spectrumNumberIndexMap, HashMap<Integer, Double> precursorMzMap, String fileName, double minRT, double maxRT, double maxMz, double maxIntensity, int maxCharge, int maxPeakCount, boolean peakPicked, boolean precursorChargesMissing, long lastModified, int spectrumCount) {
        this.spectrumTitles = spectrumTitles;
        this.duplicatedSpectrumTitles = duplicatedSpectrumTitles;
        this.indexMap = indexMap;
        this.spectrumNumberIndexMap = spectrumNumberIndexMap;
        this.precursorMzMap = precursorMzMap;
        this.fileName = fileName;
        this.maxRT = maxRT;
        this.minRT = minRT;
        this.maxMz = maxMz;
        this.maxIntensity = maxIntensity;
        this.maxCharge = maxCharge;
        this.maxPeakCount = maxPeakCount;
        this.peakPicked = peakPicked;
        this.precursorChargesMissing = precursorChargesMissing;
        this.lastModified = lastModified;
        this.spectrumCount = spectrumCount;
    }

    public Long getIndex(String spectrumTitle) {
        return this.indexMap.get(spectrumTitle);
    }

    public Integer getSpectrumIndex(String spectrumTitle) {
        if (this.spectrumNumberIndexMap == null) {
            return null;
        }
        Integer index = this.spectrumNumberIndexMap.get(spectrumTitle);
        if (index == null) {
            return -1;
        }
        return index;
    }

    public Double getPrecursorMz(int spectrumIndex) {
        if (this.precursorMzMap == null) {
            return null;
        }
        Double mz = this.precursorMzMap.get(spectrumIndex);
        if (mz == null) {
            return null;
        }
        return mz;
    }

    public String getSpectrumTitle(int number) {
        return this.spectrumTitles.get(number);
    }

    public boolean containsSpectrum(String spectrumTitle) {
        return this.indexMap.containsKey(spectrumTitle);
    }

    public ArrayList<String> getSpectrumTitles() {
        if (this.spectrumTitles != null) {
            return this.spectrumTitles;
        }
        return new ArrayList<String>(this.indexMap.keySet());
    }

    public HashMap<String, Integer> getDuplicatedSpectrumTitles() {
        return this.duplicatedSpectrumTitles;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Double getMaxRT() {
        return this.maxRT;
    }

    public void setMaxRT(Double maxRT) {
        this.maxRT = maxRT;
    }

    public Double getMaxMz() {
        return this.maxMz;
    }

    public void setMaxCharge(Integer maxCharge) {
        this.maxCharge = maxCharge;
    }

    public Integer getMaxCharge() {
        return this.maxCharge;
    }

    public void setMaxMz(Double maxMz) {
        this.maxMz = maxMz;
    }

    public Double getMaxIntensity() {
        return this.maxIntensity;
    }

    public void setMaxIntensity(Double maxIntensity) {
        this.maxIntensity = maxIntensity;
    }

    public Double getMinRT() {
        return this.minRT;
    }

    public void setMinRT(Double minRT) {
        this.minRT = minRT;
    }

    public Integer getMaxPeakCount() {
        return this.maxPeakCount;
    }

    public void setMaxPeakCount(Integer maxPeakCount) {
        this.maxPeakCount = maxPeakCount;
    }

    public int getNSpectra() {
        if (this.spectrumCount == null) {
            this.spectrumCount = this.spectrumTitles.size();
        }
        return this.spectrumCount;
    }

    public Long getLastModified() {
        return this.lastModified;
    }

    public Boolean isPeakPicked() {
        if (this.peakPicked == null) {
            this.peakPicked = true;
        }
        return this.peakPicked;
    }

    public void setPeakPicked(Boolean peakPicked) {
        this.peakPicked = peakPicked;
    }

    public Boolean isPrecursorChargesMissing() {
        return this.precursorChargesMissing;
    }

    public void setPrecursorChargesMissing(Boolean precursorChargesMissing) {
        this.precursorChargesMissing = precursorChargesMissing;
    }
}

