/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.math.statistics.distributions;

import com.compomics.util.math.statistics.Distribution;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.BinomialDistributionImpl;
import org.apache.commons.math.special.Beta;

public class BinomialDistribution
implements Distribution {
    private BinomialDistributionImpl binomialDistributionImpl;
    private int n;
    private double p;
    private int cacheSize = 1000;
    private HashMap<Integer, Double> pCache = new HashMap();
    private HashMap<Integer, Double> descendingCumulativePCache = new HashMap();

    public BinomialDistribution(int n, double p) {
        this.n = n;
        this.p = p;
        this.binomialDistributionImpl = new BinomialDistributionImpl(n, p);
    }

    @Override
    public Double getProbabilityAt(double x) {
        if (x < 0.0 || x > (double)this.n) {
            return 0.0;
        }
        int k = (int)x;
        Double result = this.pCache.get(k);
        if (result == null) {
            result = this.binomialDistributionImpl.probability(k);
            this.addPToCache(k, result);
        }
        return result;
    }

    private synchronized void addPToCache(int k, Double p) {
        if (this.pCache.size() >= this.cacheSize) {
            HashSet<Integer> keys = new HashSet<Integer>(this.pCache.keySet());
            for (Integer key : keys) {
                this.pCache.remove(key);
                if (this.pCache.size() >= this.cacheSize) continue;
                break;
            }
        }
        this.pCache.put(k, p);
    }

    @Override
    public Double getCumulativeProbabilityAt(double x) throws MathException {
        return 1.0 - this.getDescendingCumulativeProbabilityAt(x);
    }

    @Override
    public Double getDescendingCumulativeProbabilityAt(double x) throws MathException {
        int k = (int)x;
        if (k > this.n) {
            return 0.0;
        }
        if (k < 0) {
            return 1.0;
        }
        Double result = this.pCache.get(k);
        if (result == null) {
            result = Beta.regularizedBeta((double)this.p, (double)(x + 1.0), (double)((double)this.n - x));
            this.addDescendingCumulativePToCache(k, result);
        }
        return result;
    }

    private synchronized void addDescendingCumulativePToCache(int k, Double p) {
        if (this.descendingCumulativePCache.size() >= this.cacheSize) {
            HashSet<Integer> keys = new HashSet<Integer>(this.descendingCumulativePCache.keySet());
            for (Integer key : keys) {
                this.descendingCumulativePCache.remove(key);
                if (this.descendingCumulativePCache.size() >= this.cacheSize) continue;
                break;
            }
        }
        this.descendingCumulativePCache.put(k, p);
    }

    public boolean isCacheEmpty() {
        return this.pCache.isEmpty() && this.descendingCumulativePCache.isEmpty();
    }

    @Override
    public Double getSmallestCumulativeProbabilityAt(double x) throws MathException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Double getMaxValueForProbability(double p) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public Double getMinValueForProbability(double p) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public Double getValueAtCumulativeProbability(double p) throws MathException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public Double getValueAtDescendingCumulativeProbability(double p) throws MathException {
        throw new UnsupportedOperationException("Not supported.");
    }
}

