/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.preferences;

import com.compomics.util.Util;
import com.compomics.util.experiment.biology.NeutralLoss;
import com.compomics.util.experiment.identification.filtering.PeptideAssumptionFilter;
import com.compomics.util.experiment.identification.identification_parameters.SearchParameters;
import com.compomics.util.experiment.identification.spectrum_annotation.AnnotationSettings;
import com.compomics.util.io.SerializationUtils;
import com.compomics.util.io.json.marshallers.IdentificationParametersMarshaller;
import com.compomics.util.preferences.DummyParameters;
import com.compomics.util.preferences.FractionSettings;
import com.compomics.util.preferences.GenePreferences;
import com.compomics.util.preferences.IdMatchValidationPreferences;
import com.compomics.util.preferences.MarshallableParameter;
import com.compomics.util.preferences.PTMScoringPreferences;
import com.compomics.util.preferences.PeptideVariantsPreferences;
import com.compomics.util.preferences.ProteinInferencePreferences;
import com.compomics.util.preferences.PsmScoringPreferences;
import com.compomics.util.preferences.SequenceMatchingPreferences;
import com.compomics.util.preferences.ValidationQCPreferences;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;

public class IdentificationParameters
implements Serializable,
MarshallableParameter {
    static final long serialVersionUID = -5516259326385167746L;
    private String marshallableParameterType = null;
    private String name;
    private String description;
    private Boolean defaultDescription = true;
    private SearchParameters searchParameters;
    private AnnotationSettings annotationSettings;
    private SequenceMatchingPreferences sequenceMatchingPreferences;
    private PeptideVariantsPreferences peptideVariantsPreferences;
    private GenePreferences genePreferences;
    private PsmScoringPreferences psmScoringPreferences;
    private PeptideAssumptionFilter peptideAssumptionFilter;
    private PTMScoringPreferences ptmScoringPreferences;
    private ProteinInferencePreferences proteinInferencePreferences;
    private IdMatchValidationPreferences idValidationPreferences;
    private FractionSettings fractionSettings;

    public IdentificationParameters() {
    }

    public IdentificationParameters(SearchParameters searchParameters) {
        this.searchParameters = searchParameters;
        this.setParametersFromSearch(searchParameters);
    }

    public IdentificationParameters(String name, String description, SearchParameters searchParameters, AnnotationSettings annotationSettings, SequenceMatchingPreferences sequenceMatchingPreferences, PeptideVariantsPreferences peptideVariantsPreferences, GenePreferences genePreferences, PsmScoringPreferences psmScoringPreferences, PeptideAssumptionFilter peptideAssumptionFilter, PTMScoringPreferences ptmScoringPreferences, ProteinInferencePreferences proteinInferencePreferences, IdMatchValidationPreferences idValidationPreferences, FractionSettings fractionSettings) {
        this.name = name;
        this.description = description;
        this.searchParameters = searchParameters;
        this.annotationSettings = annotationSettings;
        this.sequenceMatchingPreferences = sequenceMatchingPreferences;
        this.peptideVariantsPreferences = peptideVariantsPreferences;
        this.genePreferences = genePreferences;
        this.psmScoringPreferences = psmScoringPreferences;
        this.peptideAssumptionFilter = peptideAssumptionFilter;
        this.ptmScoringPreferences = ptmScoringPreferences;
        this.proteinInferencePreferences = proteinInferencePreferences;
        this.idValidationPreferences = idValidationPreferences;
        this.fractionSettings = fractionSettings;
    }

    public SearchParameters getSearchParameters() {
        return this.searchParameters;
    }

    public void setSearchParameters(SearchParameters searchParameters) {
        this.searchParameters = searchParameters;
        if (this.defaultDescription.booleanValue() || this.description == null || this.description.length() == 0) {
            this.setDescription(searchParameters.getShortDescription(), true);
        }
    }

    public static double getPpmTolerance(double daltonTolerance, double refMass) {
        double result = daltonTolerance / refMass * 1000000.0;
        return result;
    }

    public static double getDaTolerance(double ppmTolerance, double refMass) {
        double result = ppmTolerance / 1000000.0 * refMass;
        return result;
    }

    public AnnotationSettings getAnnotationPreferences() {
        if (this.annotationSettings == null) {
            this.annotationSettings = new AnnotationSettings();
            this.annotationSettings.setPreferencesFromSearchParameters(this.searchParameters);
        }
        return this.annotationSettings;
    }

    public void setAnnotationSettings(AnnotationSettings annotationSettings) {
        this.annotationSettings = annotationSettings;
    }

    public PeptideAssumptionFilter getPeptideAssumptionFilter() {
        return this.peptideAssumptionFilter;
    }

    public void setIdFilter(PeptideAssumptionFilter peptideAssumptionFilter) {
        this.peptideAssumptionFilter = peptideAssumptionFilter;
    }

    public PsmScoringPreferences getPsmScoringPreferences() {
        return this.psmScoringPreferences;
    }

    public void setPsmScoringPreferences(PsmScoringPreferences psmScoringPreferences) {
        this.psmScoringPreferences = psmScoringPreferences;
    }

    public PTMScoringPreferences getPtmScoringPreferences() {
        return this.ptmScoringPreferences;
    }

    public void setPtmScoringPreferences(PTMScoringPreferences ptmScoringPreferences) {
        this.ptmScoringPreferences = ptmScoringPreferences;
    }

    public SequenceMatchingPreferences getSequenceMatchingPreferences() {
        return this.sequenceMatchingPreferences;
    }

    public void setSequenceMatchingPreferences(SequenceMatchingPreferences sequenceMatchingPreferences) {
        this.sequenceMatchingPreferences = sequenceMatchingPreferences;
    }

    public PeptideVariantsPreferences getPeptideVariantsPreferences() {
        if (this.peptideVariantsPreferences == null) {
            this.peptideVariantsPreferences = PeptideVariantsPreferences.getNoVariantPreferences();
        }
        return this.peptideVariantsPreferences;
    }

    public void setPeptideVariantsPreferences(PeptideVariantsPreferences peptideVariantsPreferences) {
        this.peptideVariantsPreferences = peptideVariantsPreferences;
    }

    public IdMatchValidationPreferences getIdValidationPreferences() {
        return this.idValidationPreferences;
    }

    public void setIdValidationPreferences(IdMatchValidationPreferences idValidationPreferences) {
        this.idValidationPreferences = idValidationPreferences;
    }

    public ProteinInferencePreferences getProteinInferencePreferences() {
        return this.proteinInferencePreferences;
    }

    public void setProteinInferencePreferences(ProteinInferencePreferences proteinInferencePreferences) {
        this.proteinInferencePreferences = proteinInferencePreferences;
    }

    public GenePreferences getGenePreferences() {
        return this.genePreferences;
    }

    public void setGenePreferences(GenePreferences genePreferences) {
        this.genePreferences = genePreferences;
    }

    public FractionSettings getFractionSettings() {
        if (this.fractionSettings == null) {
            return new FractionSettings();
        }
        return this.fractionSettings;
    }

    public void setFractionSettings(FractionSettings fractionSettings) {
        this.fractionSettings = fractionSettings;
    }

    public static IdentificationParameters getIdentificationParameters(File identificationParametersFile) throws IOException, ClassNotFoundException {
        IdentificationParameters identificationParameters;
        Object savedObject;
        block10: {
            try {
                IdentificationParametersMarshaller jsonMarshaller = new IdentificationParametersMarshaller();
                Class expectedObjectType = DummyParameters.class;
                Object object = jsonMarshaller.fromJson(expectedObjectType, identificationParametersFile);
                DummyParameters dummyParameters = (DummyParameters)object;
                if (dummyParameters.getType() == MarshallableParameter.Type.search_parameters) {
                    expectedObjectType = SearchParameters.class;
                    savedObject = jsonMarshaller.fromJson(expectedObjectType, identificationParametersFile);
                    break block10;
                }
                if (dummyParameters.getType() == MarshallableParameter.Type.identification_parameters) {
                    expectedObjectType = IdentificationParameters.class;
                    savedObject = jsonMarshaller.fromJson(expectedObjectType, identificationParametersFile);
                    break block10;
                }
                throw new IllegalArgumentException("Parameters file " + identificationParametersFile + " not recognized.");
            }
            catch (Exception e1) {
                try {
                    savedObject = SerializationUtils.readObject(identificationParametersFile);
                }
                catch (Exception e2) {
                    e1.printStackTrace();
                    e2.printStackTrace();
                    throw new IllegalArgumentException("Parameters file " + identificationParametersFile + " not recognized.");
                }
            }
        }
        if (savedObject instanceof SearchParameters) {
            SearchParameters searchParameters = (SearchParameters)savedObject;
            identificationParameters = new IdentificationParameters(searchParameters);
            identificationParameters.setName(Util.removeExtension(identificationParametersFile.getName()));
        } else if (savedObject instanceof IdentificationParameters) {
            identificationParameters = (IdentificationParameters)savedObject;
        } else {
            throw new UnsupportedOperationException("Parameters of type " + savedObject.getClass() + " not supported.");
        }
        identificationParameters.getSearchParameters().getDigestionPreferences();
        return identificationParameters;
    }

    public static void saveIdentificationParameters(IdentificationParameters identificationParameters, File identificationParametersFile) throws IOException {
        ValidationQCPreferences validationQCPreferences;
        IdMatchValidationPreferences idMatchValidationPreferences = identificationParameters.getIdValidationPreferences();
        if (idMatchValidationPreferences != null && (validationQCPreferences = idMatchValidationPreferences.getValidationQCPreferences()) != null) {
            idMatchValidationPreferences = new IdMatchValidationPreferences(idMatchValidationPreferences);
            idMatchValidationPreferences.setValidationQCPreferences(new ValidationQCPreferences());
            identificationParameters = new IdentificationParameters(identificationParameters.getName(), identificationParameters.getDescription(), identificationParameters.getSearchParameters(), identificationParameters.getAnnotationPreferences(), identificationParameters.getSequenceMatchingPreferences(), identificationParameters.getPeptideVariantsPreferences(), identificationParameters.getGenePreferences(), identificationParameters.getPsmScoringPreferences(), identificationParameters.getPeptideAssumptionFilter(), identificationParameters.ptmScoringPreferences, identificationParameters.getProteinInferencePreferences(), idMatchValidationPreferences, identificationParameters.getFractionSettings());
        }
        IdentificationParametersMarshaller jsonMarshaller = new IdentificationParametersMarshaller();
        identificationParameters.setType();
        jsonMarshaller.saveObjectToJson(identificationParameters, identificationParametersFile);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public Boolean getDefaultDescription() {
        if (this.defaultDescription == null) {
            return false;
        }
        return this.defaultDescription;
    }

    public void setDescription(String description, boolean automaticallyGenerated) {
        this.description = description;
        this.defaultDescription = automaticallyGenerated;
    }

    public void setParametersFromSearch(SearchParameters searchParameters) {
        this.setSearchParameters(searchParameters);
        this.annotationSettings = new AnnotationSettings();
        this.annotationSettings.addNeutralLoss(NeutralLoss.H2O);
        this.annotationSettings.addNeutralLoss(NeutralLoss.NH3);
        if (searchParameters != null) {
            this.annotationSettings.setPreferencesFromSearchParameters(searchParameters);
        }
        this.annotationSettings.setIntensityLimit(0.75);
        this.annotationSettings.setAutomaticAnnotation(true);
        this.peptideAssumptionFilter = new PeptideAssumptionFilter();
        if (searchParameters != null) {
            this.peptideAssumptionFilter.setFilterFromSearchParameters(searchParameters);
        }
        if (this.psmScoringPreferences == null) {
            this.psmScoringPreferences = new PsmScoringPreferences();
        }
        if (this.ptmScoringPreferences == null) {
            this.ptmScoringPreferences = new PTMScoringPreferences();
        }
        if (this.sequenceMatchingPreferences == null) {
            this.sequenceMatchingPreferences = SequenceMatchingPreferences.getDefaultSequenceMatching();
        }
        if (this.peptideVariantsPreferences == null) {
            this.peptideVariantsPreferences = new PeptideVariantsPreferences();
        }
        if (this.genePreferences == null) {
            this.genePreferences = new GenePreferences();
            this.genePreferences.setPreferencesFromSearchParameters(searchParameters);
        }
        if (this.proteinInferencePreferences == null) {
            this.proteinInferencePreferences = new ProteinInferencePreferences();
            if (searchParameters != null && searchParameters.getFastaFile() != null) {
                this.proteinInferencePreferences.setProteinSequenceDatabase(searchParameters.getFastaFile());
            }
        }
        if (this.idValidationPreferences == null) {
            this.idValidationPreferences = new IdMatchValidationPreferences();
        }
        if (this.fractionSettings == null) {
            this.fractionSettings = new FractionSettings();
        }
        if (searchParameters != null) {
            this.setDescription(searchParameters.getShortDescription(), true);
        }
    }

    @Override
    public void setType() {
        this.marshallableParameterType = MarshallableParameter.Type.identification_parameters.name();
    }

    @Override
    public MarshallableParameter.Type getType() {
        if (this.marshallableParameterType == null) {
            return null;
        }
        return MarshallableParameter.Type.valueOf(this.marshallableParameterType);
    }

    public boolean equals(IdentificationParameters otherIdentificationParameters) {
        if (otherIdentificationParameters == null) {
            return false;
        }
        if (!this.idValidationPreferences.equals(otherIdentificationParameters.getIdValidationPreferences())) {
            return false;
        }
        return this.equalsExceptValidationPreferences(otherIdentificationParameters);
    }

    public boolean equalsExceptValidationPreferences(IdentificationParameters otherIdentificationParameters) {
        if (otherIdentificationParameters == null) {
            return false;
        }
        if (!this.searchParameters.equals(otherIdentificationParameters.getSearchParameters())) {
            return false;
        }
        if (!this.annotationSettings.isSameAs(otherIdentificationParameters.getAnnotationPreferences())) {
            return false;
        }
        if (!this.sequenceMatchingPreferences.isSameAs(otherIdentificationParameters.getSequenceMatchingPreferences())) {
            return false;
        }
        if (!this.getPeptideVariantsPreferences().isSameAs(otherIdentificationParameters.getPeptideVariantsPreferences())) {
            return false;
        }
        if (!this.genePreferences.equals(otherIdentificationParameters.getGenePreferences())) {
            return false;
        }
        if (!this.psmScoringPreferences.equals(otherIdentificationParameters.getPsmScoringPreferences())) {
            return false;
        }
        if (!this.peptideAssumptionFilter.isSameAs(otherIdentificationParameters.getPeptideAssumptionFilter())) {
            return false;
        }
        if (!this.ptmScoringPreferences.equals(otherIdentificationParameters.getPtmScoringPreferences())) {
            return false;
        }
        if (!this.proteinInferencePreferences.equals(otherIdentificationParameters.getProteinInferencePreferences())) {
            return false;
        }
        return this.fractionSettings.isSameAs(otherIdentificationParameters.getFractionSettings());
    }
}

