/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.waiting;

import com.compomics.util.Util;

public class Duration {
    private Long start = null;
    private Long end = null;

    public Duration() {
    }

    public Duration(long start, long end) {
        this.start = start;
        this.end = end;
    }

    public void start() {
        this.start = System.currentTimeMillis();
    }

    public void end() {
        this.end = System.currentTimeMillis();
    }

    public long getDuration() {
        return this.end - this.start;
    }

    public String toString() {
        if (this.start == null) {
            throw new IllegalArgumentException("Start time not set.");
        }
        if (this.end == null) {
            throw new IllegalArgumentException("End time not set.");
        }
        long processingTimeMilliseconds = this.end - this.start;
        double processingTimeSeconds = (double)processingTimeMilliseconds / 1000.0;
        int nSeconds = (int)processingTimeSeconds;
        double restMilliseconds = processingTimeMilliseconds - (long)(1000 * nSeconds);
        double processingTimeMinutes = processingTimeSeconds / 60.0;
        int nMinutes = (int)processingTimeMinutes;
        double restSeconds = processingTimeSeconds - (double)(60 * nMinutes);
        double processingTimeHours = (double)nMinutes / 60.0;
        int nHours = (int)processingTimeHours;
        int restMinutes = nMinutes - 60 * nHours;
        double processingTimeDays = (double)nHours / 24.0;
        int nDays = (int)processingTimeDays;
        int restHours = nHours - 24 * nDays;
        StringBuilder result = new StringBuilder();
        if (nDays > 0) {
            result.append(nDays);
            if (nDays == 1) {
                result.append(" day ");
            } else {
                result.append(" days ");
            }
        }
        if (restHours > 0) {
            result.append(restHours);
            if (restHours == 1) {
                result.append(" hour ");
            } else {
                result.append(" hours ");
            }
        }
        if (restMinutes > 0) {
            result.append(restMinutes);
            if (restMinutes == 1) {
                result.append(" minute ");
            } else {
                result.append(" minutes ");
            }
        }
        if (restSeconds < 1.0) {
            result.append(restMilliseconds).append(" milliseconds");
        } else if (restMinutes < 1) {
            result.append(Util.roundDouble(processingTimeSeconds, 1)).append(" seconds");
        } else {
            result.append(Util.roundDouble(restSeconds, 0)).append(" seconds");
        }
        return result.toString();
    }
}

