/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.datatypes.scan.impl;

import java.lang.ref.Reference;
import umich.ms.datatypes.scan.AbstractScan;
import umich.ms.datatypes.scan.StorageStrategy;
import umich.ms.datatypes.scancollection.IScanCollection;
import umich.ms.datatypes.spectrum.ISpectrum;
import umich.ms.fileio.exceptions.FileParsingException;

public class ScanDefault
extends AbstractScan {
    protected Reference<ISpectrum> spectrumRef;

    public ScanDefault(int num) {
        super(num);
        this.init();
        this.spectrumRef = this.storageStrategy.getRef(null);
    }

    public ScanDefault(IScanCollection scans, int num) {
        this(num);
        this.scans = scans;
    }

    public ScanDefault(int num, double rt, int msLevel, boolean isCentroided) {
        this(num);
        this.rt = rt;
        this.msLevel = msLevel;
        this.isCentroided = isCentroided;
    }

    public ScanDefault(IScanCollection scans, int num, double rt, int msLevel, boolean isCentroided) {
        this(num, rt, msLevel, isCentroided);
        this.scans = scans;
    }

    private void init() {
        this.storageStrategy = StorageStrategy.STRONG;
    }

    @Override
    public Double getRt() {
        return this.rt;
    }

    public IScanCollection getScans() {
        return this.scans;
    }

    public void setScans(IScanCollection scans) {
        this.scans = scans;
    }

    public Reference<ISpectrum> getSpectrumRef() {
        return this.spectrumRef;
    }

    @Override
    public ISpectrum getSpectrum() {
        return this.spectrumRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISpectrum fetchSpectrum() throws FileParsingException {
        ISpectrum spec = this.spectrumRef.get();
        if (spec == null) {
            ScanDefault scanDefault = this;
            synchronized (scanDefault) {
                spec = this.spectrumRef.get();
                if (spec == null && this.scans != null && this.scans.isAutoloadSpectra() && (spec = this.scans.getDataSource().parseSpectrum(this.num)) != null) {
                    this.setSpectrum(spec, true);
                }
            }
        }
        return spec;
    }

    @Override
    protected void setSpectrumImpl(ISpectrum spectrum) {
        this.spectrumRef = this.storageStrategy.getRef(spectrum);
    }
}

