/*
 * Decompiled with CFR 0.152.
 */
package jwave.transforms;

import java.util.Arrays;
import jwave.exceptions.JWaveException;
import jwave.exceptions.JWaveFailure;
import jwave.transforms.WaveletTransform;
import jwave.transforms.wavelets.Wavelet;

public class FastWaveletTransform
extends WaveletTransform {
    public FastWaveletTransform(Wavelet wavelet) {
        super(wavelet);
        this._name = "Fast Wavelet Transform";
    }

    @Override
    public double[] forward(double[] arrTime, int level) throws JWaveException {
        if (!this.isBinary(arrTime.length)) {
            throw new JWaveFailure("FastWaveletTransform#forward - given array length is not 2^p | p \u20ac N ... = 1, 2, 4, 8, 16, 32, .. please use the Ancient Egyptian Decomposition for any other array length!");
        }
        int noOfLevels = this.calcExponent(arrTime.length);
        if (level < 0 || level > noOfLevels) {
            throw new JWaveFailure("FastWaveletTransform#forward - given level is out of range for given array");
        }
        double[] arrHilb = Arrays.copyOf(arrTime, arrTime.length);
        int l = 0;
        int transformWavelength = this._wavelet.getTransformWavelength();
        for (int h = arrHilb.length; h >= transformWavelength && l < level; h >>= 1, ++l) {
            double[] arrTempPart = this._wavelet.forward(arrHilb, h);
            System.arraycopy(arrTempPart, 0, arrHilb, 0, h);
        }
        return arrHilb;
    }

    @Override
    public double[] reverse(double[] arrHilb, int level) throws JWaveException {
        int transformWavelength;
        if (!this.isBinary(arrHilb.length)) {
            throw new JWaveFailure("FastWaveletTransform#reverse - given array length is not 2^p | p \u20ac N ... = 1, 2, 4, 8, 16, 32, .. please use the Ancient Egyptian Decomposition for any other array length!");
        }
        int noOfLevels = this.calcExponent(arrHilb.length);
        if (level < 0 || level > noOfLevels) {
            throw new JWaveFailure("FastWaveletTransform#reverse - given level is out of range for given array");
        }
        int length = arrHilb.length;
        double[] arrTime = Arrays.copyOf(arrHilb, length);
        int h = transformWavelength = this._wavelet.getTransformWavelength();
        int steps = this.calcExponent(length);
        for (int l = level; l < steps; ++l) {
            h <<= 1;
        }
        while (h <= arrTime.length && h >= transformWavelength) {
            double[] arrTempPart = this._wavelet.reverse(arrTime, h);
            System.arraycopy(arrTempPart, 0, arrTime, 0, h);
            h <<= 1;
        }
        return arrTime;
    }
}

