/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.model;

import fr.profi.mzdb.XicMethod;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class ExtractionRequest {
    private Object source;
    private final double minMz;
    private final double maxMz;
    private final double mz;
    private final float mzTolPPM;
    private final Type mzRequestType;
    private final float elutionTimeLowerBound;
    private final float elutionTimeUpperBound;
    private final float elutionTime;
    private final double fragmentMz;
    private final double fragmentMinMz;
    private final double fragmentMaxMz;
    private final Type fragmentRequestType;
    private final float fragmentMzTolPPM;
    private final double mobility;
    private final double minMobility;
    private final double maxMobility;
    private final float mobilityTol;
    private final Type mobilityRequestType;
    private final int msLevel;
    private final XicMethod method;

    protected ExtractionRequest(Builder builder) {
        this.mz = builder.mz;
        this.maxMz = builder.maxMz;
        this.minMz = builder.minMz;
        this.mzTolPPM = builder.mzTolPPM;
        this.mzRequestType = builder.mzRequestType;
        this.elutionTimeLowerBound = builder.elutionTimeLowerBound;
        this.elutionTimeUpperBound = builder.elutionTimeUpperBound;
        this.elutionTime = builder.elutionTime;
        this.fragmentMz = builder.fragmentMz;
        this.fragmentMinMz = builder.fragmentMinMz;
        this.fragmentMaxMz = builder.fragmentMaxMz;
        this.fragmentMzTolPPM = builder.fragmentMzTolPPM;
        this.fragmentRequestType = builder.fragmentRequestType;
        this.mobility = builder.mobility;
        this.minMobility = builder.minMobility;
        this.maxMobility = builder.maxMobility;
        this.mobilityTol = builder.mobilityTol;
        this.mobilityRequestType = builder.mobilityRequestType;
        this.method = builder.method;
        this.msLevel = builder.msLevel;
        this.source = builder.source;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static Builder<?> builder(Object source) {
        Builder builder = new Builder();
        builder.setSource(source);
        return builder;
    }

    public double getMinMz() {
        return this.minMz;
    }

    public double getMaxMz() {
        return this.maxMz;
    }

    public double getMz() {
        return this.mz;
    }

    public Type getMzRequestType() {
        return this.mzRequestType;
    }

    public float getElutionTimeLowerBound() {
        return this.elutionTimeLowerBound;
    }

    public float getElutionTimeUpperBound() {
        return this.elutionTimeUpperBound;
    }

    public float getElutionTime() {
        return this.elutionTime;
    }

    public double getFragmentMz() {
        return this.fragmentMz;
    }

    public double getFragmentMinMz() {
        return this.fragmentMinMz;
    }

    public double getFragmentMaxMz() {
        return this.fragmentMaxMz;
    }

    public Type getFragmentRequestType() {
        return this.fragmentRequestType;
    }

    public int getMsLevel() {
        return this.msLevel;
    }

    public double getMobility() {
        return this.mobility;
    }

    public double getMinMobility() {
        return this.minMobility;
    }

    public double getMaxMobility() {
        return this.maxMobility;
    }

    public float getMobilityTol() {
        return this.mobilityTol;
    }

    public Type getMobilityRequestType() {
        return this.mobilityRequestType;
    }

    public float getMzTolPPM() {
        return this.mzTolPPM;
    }

    public float getFragmentMzTolPPM() {
        return this.fragmentMzTolPPM;
    }

    public XicMethod getMethod() {
        return this.method;
    }

    public boolean isMsnExtraction() {
        return this.msLevel > 1;
    }

    public Object getSource() {
        return this.source;
    }

    public static class Builder<T extends Builder<T>> {
        Object source = null;
        double mz = -1.0;
        double minMz = -1.0;
        double maxMz = -1.0;
        float mzTolPPM = 10.0f;
        Type mzRequestType = Type.NONE;
        float elutionTime = -1.0f;
        float elutionTimeLowerBound = -1.0f;
        float elutionTimeUpperBound = -1.0f;
        double fragmentMz = -1.0;
        double fragmentMinMz = -1.0;
        double fragmentMaxMz = -1.0;
        float fragmentMzTolPPM = 50.0f;
        Type fragmentRequestType = Type.NONE;
        double mobility = -1.0;
        double minMobility = -1.0;
        double maxMobility = -1.0;
        float mobilityTol = -1.0f;
        Type mobilityRequestType = Type.NONE;
        int msLevel = 1;
        XicMethod method = XicMethod.MAX;

        protected T self() {
            return (T)this;
        }

        public void setSource(Object source) {
            this.source = source;
        }

        public T setElutionTimeLowerBound(float startRT) {
            this.elutionTimeLowerBound = startRT;
            return this.self();
        }

        public T setElutionTimeUpperBound(float stopRT) {
            this.elutionTimeUpperBound = stopRT;
            return this.self();
        }

        public T setElutionTime(float rt) {
            this.elutionTime = rt;
            return this.self();
        }

        public T setMsLevel(int level) {
            this.msLevel = level;
            return this.self();
        }

        public T setMzTolPPM(float mzTolPPM) {
            this.mzRequestType = Type.CENTERED;
            this.mzTolPPM = mzTolPPM;
            if (this.mz > 0.0) {
                this.maxMz = this.mz + this.mz * (double)mzTolPPM / 1000000.0;
                this.minMz = this.mz - this.mz * (double)mzTolPPM / 1000000.0;
            }
            return this.self();
        }

        public T setMz(double mz) {
            this.mzRequestType = Type.CENTERED;
            this.mz = mz;
            this.maxMz = mz + mz * (double)this.mzTolPPM / 1000000.0;
            this.minMz = mz - mz * (double)this.mzTolPPM / 1000000.0;
            return this.self();
        }

        public T setMaxMz(double maxMz) {
            this.mzRequestType = Type.RANGE;
            this.maxMz = maxMz;
            if (this.minMz > 0.0) {
                this.mz = (maxMz + this.minMz) / 2.0;
                this.mzTolPPM = (float)(1000000.0 * (maxMz - this.minMz) / (2.0 * this.mz));
            }
            return this.self();
        }

        public T setMinMz(double minMz) {
            this.mzRequestType = Type.RANGE;
            this.minMz = minMz;
            if (this.maxMz > 0.0) {
                this.mz = (this.maxMz + minMz) / 2.0;
                this.mzTolPPM = (float)(1000000.0 * (this.maxMz - minMz) / (2.0 * this.mz));
            }
            return this.self();
        }

        public T setFragmentMz(double mz) {
            this.fragmentRequestType = Type.CENTERED;
            this.fragmentMz = mz;
            this.fragmentMaxMz = this.fragmentMz + this.fragmentMz * (double)this.fragmentMzTolPPM / 1000000.0;
            this.fragmentMinMz = this.fragmentMz - this.fragmentMz * (double)this.fragmentMzTolPPM / 1000000.0;
            this.setMsLevel(2);
            return this.self();
        }

        public T setFragmentMaxMz(double maxMz) {
            this.fragmentRequestType = Type.RANGE;
            this.fragmentMaxMz = maxMz;
            if (this.fragmentMinMz > 0.0) {
                this.fragmentMz = (this.fragmentMaxMz + this.fragmentMinMz) / 2.0;
                this.fragmentMzTolPPM = (float)(1000000.0 * (this.fragmentMaxMz - this.fragmentMinMz) / (2.0 * this.fragmentMz));
            }
            this.setMsLevel(2);
            return this.self();
        }

        public T setFragmentMinMz(double minMz) {
            this.fragmentRequestType = Type.RANGE;
            this.fragmentMinMz = minMz;
            if (this.fragmentMaxMz > 0.0) {
                this.fragmentMz = (this.fragmentMaxMz + this.fragmentMinMz) / 2.0;
                this.fragmentMzTolPPM = (float)(1000000.0 * (this.fragmentMaxMz - this.fragmentMinMz) / (2.0 * this.fragmentMz));
            }
            this.setMsLevel(2);
            return this.self();
        }

        public T setFragmentMzTolPPM(float mzTolPPM) {
            this.fragmentRequestType = Type.CENTERED;
            this.fragmentMzTolPPM = mzTolPPM;
            if (this.fragmentMz > 0.0) {
                this.fragmentMaxMz = this.fragmentMz + this.fragmentMz * (double)this.fragmentMzTolPPM / 1000000.0;
                this.fragmentMinMz = this.fragmentMz - this.fragmentMz * (double)this.fragmentMzTolPPM / 1000000.0;
            }
            this.setMsLevel(2);
            return this.self();
        }

        public T setMethod(XicMethod method) {
            this.method = method;
            return this.self();
        }

        public void setMobility(double mobility) {
            this.mobilityRequestType = Type.CENTERED;
            this.mobility = mobility;
            if (this.mobilityTol > 0.0f) {
                this.minMobility = mobility - (double)this.mobilityTol;
                this.maxMobility = mobility + (double)this.mobilityTol;
            }
        }

        public void setMinMobility(double minMobility) {
            this.mobilityRequestType = Type.RANGE;
            this.minMobility = minMobility;
            if (this.maxMobility > 0.0) {
                this.mobilityTol = (float)((this.maxMobility - minMobility) / 2.0);
            }
        }

        public void setMaxMobility(double maxMobility) {
            this.mobilityRequestType = Type.RANGE;
            this.maxMobility = maxMobility;
            if (this.minMobility > 0.0) {
                this.mobilityTol = (float)((maxMobility - this.minMobility) / 2.0);
            }
        }

        public void setMobilityTol(float mobilityTol) {
            this.mobilityRequestType = Type.CENTERED;
            this.mobilityTol = mobilityTol;
            if (this.mobility > 0.0) {
                this.minMobility = this.mobility - (double)mobilityTol;
                this.maxMobility = this.mobility + (double)mobilityTol;
            }
        }

        public ExtractionRequest build() {
            return new ExtractionRequest(this);
        }
    }

    public static enum Type {
        NONE,
        RANGE,
        CENTERED;

    }
}

