/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.processing;

import fr.profi.ms.algo.IsotopePatternEstimator;
import fr.profi.ms.model.TheoreticalIsotopePattern;
import fr.profi.mzdb.model.SpectrumData;
import fr.proline.mzscope.processing.Scorer;
import fr.proline.mzscope.processing.SpectrumUtils;
import org.apache.commons.math3.stat.inference.TestUtils;
import scala.Tuple2;

public class ChiSquareScorer
implements Scorer {
    @Override
    public Tuple2<Double, TheoreticalIsotopePattern> score(SpectrumData currentSpectrum, double intialMz, int shift, int charge, double ppmTol) {
        double score = 0.0;
        double mz = intialMz - (double)shift * IsotopePatternEstimator.avgIsoMassDiff() / (double)charge;
        TheoreticalIsotopePattern pattern = IsotopePatternEstimator.getTheoreticalPattern((double)mz, (int)charge);
        Double ipMoz = mz;
        long[] observed = new long[pattern.mzAbundancePairs().length];
        double[] expected = new double[pattern.mzAbundancePairs().length];
        for (int rank = 0; rank < pattern.mzAbundancePairs().length; ++rank) {
            ipMoz = rank == 0 ? ipMoz : ipMoz + IsotopePatternEstimator.avgIsoMassDiff() / (double)charge;
            int nearestPeakIdx = SpectrumUtils.getNearestPeakIndex(currentSpectrum.getMzList(), ipMoz);
            observed[rank] = 1000000.0 * Math.abs(currentSpectrum.getMzList()[nearestPeakIdx] - ipMoz) / ipMoz < ppmTol ? (long)currentSpectrum.getIntensityList()[nearestPeakIdx] : 0L;
            expected[rank] = ((Float)pattern.mzAbundancePairs()[rank]._2).floatValue();
        }
        double ratio = (double)observed[shift] / expected[shift];
        for (int k = 0; k < observed.length; ++k) {
            observed[k] = (long)Math.ceil((double)observed[k] / ratio);
        }
        score = TestUtils.chiSquareTest((double[])expected, (long[])observed);
        return new Tuple2((Object)(1.0 - score), (Object)pattern);
    }
}

