/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.processing;

import fr.profi.ms.algo.IsotopePatternEstimator;
import fr.profi.ms.model.TheoreticalIsotopePattern;
import fr.profi.mzdb.model.SpectrumData;
import fr.proline.mzscope.processing.Scorer;
import fr.proline.mzscope.processing.SpectrumUtils;
import scala.Tuple2;

class ProlineLikeScorer
implements Scorer {
    ProlineLikeScorer() {
    }

    @Override
    public Tuple2<Double, TheoreticalIsotopePattern> score(SpectrumData currentSpectrum, double intialMz, int shift, int charge, double ppmTol) {
        double score = 0.0;
        double mz = intialMz - (double)shift * IsotopePatternEstimator.avgIsoMassDiff() / (double)charge;
        TheoreticalIsotopePattern pattern = IsotopePatternEstimator.getTheoreticalPattern((double)mz, (int)charge);
        double normalisationRatio = -1.0;
        Double ipMoz = mz;
        int matchingPeaksCount = 0;
        for (int rank = 0; rank < pattern.mzAbundancePairs().length; ++rank) {
            ipMoz = rank == 0 ? ipMoz : ipMoz + IsotopePatternEstimator.avgIsoMassDiff() / (double)charge;
            int nearestPeakIdx = SpectrumUtils.getNearestPeakIndex(currentSpectrum.getMzList(), ipMoz);
            if (normalisationRatio < 0.0) {
                normalisationRatio = currentSpectrum.getIntensityList()[nearestPeakIdx] / ((Float)pattern.mzAbundancePairs()[0]._2).floatValue();
            }
            double ipAbundance = (double)((Float)pattern.mzAbundancePairs()[rank]._2).floatValue() * normalisationRatio;
            double penality = Math.min(100.0, 1.0E-4 * Math.pow(10.0, rank * 2));
            double abundance = 1000000.0 * Math.abs(currentSpectrum.getMzList()[nearestPeakIdx] - ipMoz) / ipMoz < ppmTol ? (double)currentSpectrum.getIntensityList()[nearestPeakIdx] : ipAbundance / 100.0;
            double d = (ipAbundance - abundance) / Math.min(abundance, ipAbundance) * 1.0 / penality;
            score += d * d;
            if (!(1000000.0 * Math.abs(currentSpectrum.getMzList()[nearestPeakIdx] - ipMoz) / ipMoz < ppmTol)) continue;
            ++matchingPeaksCount;
            ipMoz = currentSpectrum.getMzList()[nearestPeakIdx];
        }
        score = Math.log10(score) - (double)matchingPeaksCount;
        return new Tuple2((Object)score, (Object)pattern);
    }
}

