/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.ui;

import fr.proline.mzscope.model.ExtractionRequest;
import fr.proline.mzscope.ui.IMzScopeController;
import fr.proline.mzscope.ui.IRawFileViewer;
import fr.proline.mzscope.ui.model.MzScopePreferences;
import fr.proline.mzscope.utils.Display;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractionToolbar
extends JPanel
implements PropertyChangeListener {
    private static final int COMPONENTS_HEIGHT = 16;
    private static final int COMPONENTS_GAP = 3;
    private static Logger logger = LoggerFactory.getLogger(ExtractionToolbar.class);
    private static DecimalFormat PRECISION_DF = new DecimalFormat("#.####");
    private static DecimalFormat SINGLE_DIGIT_DF = new DecimalFormat("#.#");
    private JTextField massRangeTF;
    private JTextField toleranceTF;
    private JTextField fragmentMassRangeTF;
    private JTextField fragmentToleranceTF;
    private final IMzScopeController appController;
    private JTextField mobilityToleranceTF;
    private JTextField mobilityRangeTF;

    public ExtractionToolbar(IMzScopeController appController) {
        this.initComponents();
        this.appController = appController;
        appController.addPropertyChangeListener("currentRawFileViewer", this);
        MzScopePreferences.getInstance().addPropertyChangeListener(MzScopePreferences.LAST_EXTRACTION_REQUEST, this);
        this.toleranceTF.setText(Integer.toString(Math.round(MzScopePreferences.getInstance().getMzPPMTolerance())));
        this.fragmentToleranceTF.setText(Integer.toString(Math.round(MzScopePreferences.getInstance().getFragmentMzPPMTolerance())));
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel(new FlowLayout(3, 0, 3));
        JPanel massRangePanel = new JPanel();
        massRangePanel.setLayout(new FlowLayout(3, 3, 0));
        massRangePanel.add(new JLabel("Precursor m/z:"));
        massRangePanel.add(this.getMassRangeTF());
        massRangePanel.add(new JLabel("+/-"));
        massRangePanel.add(this.getToleranceTF());
        massRangePanel.add(new JLabel("ppm,"));
        mainPanel.add(massRangePanel);
        JPanel fragmentMassRangePanel = new JPanel();
        fragmentMassRangePanel.setLayout(new FlowLayout(3, 3, 0));
        fragmentMassRangePanel.add(new JLabel("Fragment m/z:"));
        fragmentMassRangePanel.add(this.getFragmentMassRangeTF());
        fragmentMassRangePanel.add(new JLabel("+/-"));
        fragmentMassRangePanel.add(this.getFragmentToleranceTF());
        fragmentMassRangePanel.add(new JLabel("ppm,"));
        mainPanel.add(fragmentMassRangePanel);
        JPanel mobilityRangePanel = new JPanel();
        mobilityRangePanel.setLayout(new FlowLayout(3, 3, 0));
        mobilityRangePanel.add(new JLabel("Ion mobility:"));
        mobilityRangePanel.add(this.getMobilityRangeTF());
        mobilityRangePanel.add(new JLabel("+/-"));
        mobilityRangePanel.add(this.getMobilityToleranceTF());
        mainPanel.add(mobilityRangePanel);
        this.add((Component)mainPanel, "West");
    }

    private JTextField getMassRangeTF() {
        if (this.massRangeTF == null) {
            this.massRangeTF = new JTextField();
            this.massRangeTF.setToolTipText("<html><p width=\"500\">Precursor mass range to extract. A single value can be entered (the following tolerance value will be used) or a range of values using '-' delimiter</p></html>");
            this.massRangeTF.setColumns(10);
            this.massRangeTF.setPreferredSize(new Dimension(this.massRangeTF.getPreferredSize().width, 16));
            this.massRangeTF.addActionListener(evt -> this.startExtraction());
        }
        return this.massRangeTF;
    }

    private JTextField getToleranceTF() {
        if (this.toleranceTF == null) {
            this.toleranceTF = new JTextField();
            this.toleranceTF.setColumns(5);
            this.toleranceTF.setPreferredSize(new Dimension(this.toleranceTF.getPreferredSize().width, 16));
            this.toleranceTF.setToolTipText("Precursor mass tolerance in ppm");
            this.toleranceTF.addActionListener(evt -> this.startExtraction());
        }
        return this.toleranceTF;
    }

    private JTextField getFragmentMassRangeTF() {
        if (this.fragmentMassRangeTF == null) {
            this.fragmentMassRangeTF = new JTextField();
            this.fragmentMassRangeTF.setToolTipText("<html><p width=\"500\">Fragment mass range to extract. A single value can be entered (the following tolerance value will be used) or a range of values using '-' delimiter</p></html>");
            this.fragmentMassRangeTF.setColumns(10);
            this.fragmentMassRangeTF.setPreferredSize(new Dimension(this.fragmentMassRangeTF.getPreferredSize().width, 16));
            this.fragmentMassRangeTF.addActionListener(evt -> this.startExtraction());
        }
        return this.fragmentMassRangeTF;
    }

    private JTextField getFragmentToleranceTF() {
        if (this.fragmentToleranceTF == null) {
            this.fragmentToleranceTF = new JTextField();
            this.fragmentToleranceTF.setColumns(5);
            this.fragmentToleranceTF.setPreferredSize(new Dimension(this.fragmentToleranceTF.getPreferredSize().width, 16));
            this.fragmentToleranceTF.setToolTipText("Fragment mass tolerance in ppm");
            this.fragmentToleranceTF.addActionListener(evt -> this.startExtraction());
        }
        return this.fragmentToleranceTF;
    }

    private JTextField getMobilityRangeTF() {
        if (this.mobilityRangeTF == null) {
            this.mobilityRangeTF = new JTextField();
            this.mobilityRangeTF.setToolTipText("<html><p width=\"500\">Ion mobility mass range to extract. A single value can be entered (the following tolerance value will be used) or a range of values using '-' delimiter</p></html>");
            this.mobilityRangeTF.setColumns(12);
            this.mobilityRangeTF.setPreferredSize(new Dimension(this.mobilityRangeTF.getPreferredSize().width, 16));
            this.mobilityRangeTF.addActionListener(evt -> this.startExtraction());
        }
        return this.mobilityRangeTF;
    }

    private JTextField getMobilityToleranceTF() {
        if (this.mobilityToleranceTF == null) {
            this.mobilityToleranceTF = new JTextField();
            this.mobilityToleranceTF.setColumns(5);
            this.mobilityToleranceTF.setPreferredSize(new Dimension(this.mobilityToleranceTF.getPreferredSize().width, 16));
            this.mobilityToleranceTF.setToolTipText("Ion mobility tolerance (abs)");
            this.mobilityToleranceTF.addActionListener(evt -> this.startExtraction());
        }
        return this.mobilityToleranceTF;
    }

    private void startExtraction() {
        IRawFileViewer currentViewer;
        float toleranceValue;
        String[] stringValues;
        String text;
        ExtractionRequest.Builder<?> builder = ExtractionRequest.builder(this);
        double firstValue = Double.NaN;
        double secondValue = Double.NaN;
        if (this.massRangeTF.isEnabled() && this.massRangeTF.getText() != null && !this.massRangeTF.getText().isEmpty()) {
            text = this.massRangeTF.getText().trim();
            stringValues = text.split("-");
            try {
                firstValue = Double.parseDouble(stringValues[0]);
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this, "The mass value is incorrect: " + stringValues[0]);
                return;
            }
            try {
                toleranceValue = Float.parseFloat(this.toleranceTF.getText().trim());
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this, "The tolerance value is incorrect: " + this.toleranceTF.getText().trim());
                return;
            }
            if (stringValues.length == 1) {
                builder.setMz(firstValue);
                builder.setMzTolPPM(toleranceValue);
            } else {
                try {
                    secondValue = Double.parseDouble(stringValues[1]);
                    builder.setMinMz(firstValue);
                    builder.setMaxMz(secondValue);
                }
                catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(this, "The max mass value is incorrect: " + stringValues[1]);
                    return;
                }
            }
        }
        if (this.fragmentMassRangeTF.isEnabled() && this.fragmentMassRangeTF.getText() != null && !this.fragmentMassRangeTF.getText().isEmpty()) {
            text = this.fragmentMassRangeTF.getText().trim();
            stringValues = text.split("-");
            try {
                firstValue = Double.parseDouble(stringValues[0]);
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this, "The mass value is incorrect: " + stringValues[0]);
                return;
            }
            try {
                toleranceValue = Float.parseFloat(this.fragmentToleranceTF.getText().trim());
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this, "The tolerance value is incorrect: " + this.fragmentToleranceTF.getText().trim());
                return;
            }
            if (stringValues.length == 1) {
                builder.setFragmentMz(firstValue);
                builder.setFragmentMzTolPPM(toleranceValue);
            } else {
                try {
                    secondValue = Double.parseDouble(stringValues[1]);
                    builder.setFragmentMinMz(firstValue);
                    builder.setFragmentMaxMz(secondValue);
                }
                catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(this, "The max mass value is incorrect: " + stringValues[1]);
                    return;
                }
            }
        }
        if (this.mobilityRangeTF.isEnabled() && this.mobilityRangeTF.getText() != null && !this.mobilityRangeTF.getText().isEmpty()) {
            text = this.mobilityRangeTF.getText().trim();
            stringValues = text.split("-");
            try {
                firstValue = Double.parseDouble(stringValues[0]);
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this, "The mobility value is incorrect: " + stringValues[0]);
                return;
            }
            if (stringValues.length == 1) {
                try {
                    toleranceValue = Float.parseFloat(this.mobilityToleranceTF.getText().trim());
                }
                catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(this, "The tolerance value is incorrect: " + this.mobilityToleranceTF.getText().trim());
                    return;
                }
                builder.setMobility(firstValue);
                builder.setMobilityTol(toleranceValue);
            } else {
                try {
                    secondValue = Double.parseDouble(stringValues[1]);
                    builder.setMinMobility(firstValue);
                    builder.setMaxMobility(secondValue);
                }
                catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(this, "The max mobility value is incorrect: " + stringValues[1]);
                    return;
                }
            }
        }
        if ((currentViewer = this.appController.getCurrentRawFileViewer()) != null) {
            currentViewer.extractAndDisplay(builder.build(), new Display(currentViewer.getChromatogramDisplayMode()), null);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == "currentRawFileViewer") {
            IRawFileViewer viewer = (IRawFileViewer)evt.getNewValue();
            this.getFragmentMassRangeTF().setEnabled(viewer.getCurrentRawfile().isDIAFile());
            this.getFragmentToleranceTF().setEditable(viewer.getCurrentRawfile().isDIAFile());
            this.getMobilityRangeTF().setEnabled(viewer.getCurrentRawfile().hasIonMobilitySeparation());
            this.getMobilityToleranceTF().setEditable(viewer.getCurrentRawfile().hasIonMobilitySeparation());
        } else if (evt.getPropertyName() == MzScopePreferences.LAST_EXTRACTION_REQUEST) {
            ExtractionRequest request = (ExtractionRequest)evt.getNewValue();
            if (request.getMsLevel() == 1) {
                switch (request.getMzRequestType()) {
                    case CENTERED: {
                        this.getToleranceTF().setText(SINGLE_DIGIT_DF.format(request.getMzTolPPM()));
                        this.getMassRangeTF().setText(PRECISION_DF.format(request.getMz()));
                        break;
                    }
                    case RANGE: {
                        this.getMassRangeTF().setText(PRECISION_DF.format(request.getMinMz()) + "-" + PRECISION_DF.format(request.getMaxMz()));
                        this.getToleranceTF().setText("");
                        break;
                    }
                    default: {
                        this.getMassRangeTF().setText("");
                        this.getToleranceTF().setText("");
                    }
                }
            }
            if (request.getMsLevel() == 2) {
                this.getToleranceTF().setText(Double.toString(request.getMzTolPPM()));
                this.getMassRangeTF().setText(PRECISION_DF.format(request.getMz()));
                switch (request.getFragmentRequestType()) {
                    case CENTERED: {
                        this.getFragmentToleranceTF().setText(SINGLE_DIGIT_DF.format(request.getFragmentMzTolPPM()));
                        this.getFragmentMassRangeTF().setText(PRECISION_DF.format(request.getFragmentMz()));
                        break;
                    }
                    case RANGE: {
                        this.getFragmentMassRangeTF().setText(PRECISION_DF.format(request.getFragmentMinMz() + "-" + request.getFragmentMaxMz()));
                        this.getFragmentToleranceTF().setText("");
                        break;
                    }
                    default: {
                        this.getFragmentMassRangeTF().setText("");
                        this.getFragmentToleranceTF().setText("");
                    }
                }
            }
            switch (request.getMobilityRequestType()) {
                case CENTERED: {
                    this.getMobilityRangeTF().setText(PRECISION_DF.format(request.getMobility()));
                    this.getMobilityToleranceTF().setText(PRECISION_DF.format(request.getMobilityTol()));
                    break;
                }
                case RANGE: {
                    this.getMobilityRangeTF().setText(PRECISION_DF.format(request.getMinMobility()) + "-" + PRECISION_DF.format(request.getMaxMobility()));
                    this.getMobilityToleranceTF().setText("");
                }
            }
        }
    }
}

