/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.ui.model;

import fr.proline.mzscope.model.AnnotatedChromatogram;
import fr.proline.mzscope.model.ExtractionObject;
import fr.proline.mzscope.model.IRawFile;
import fr.proline.mzscope.ui.StatusRenderer;
import fr.proline.studio.export.ExportFontData;
import fr.proline.studio.export.ExportModelUtilities;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.ExtraDataType;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.filter.Filter;
import fr.proline.studio.graphics.PlotInformation;
import fr.proline.studio.graphics.PlotType;
import fr.proline.studio.table.DecoratedTableModel;
import fr.proline.studio.table.LazyData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractionResultsTableModel
extends DecoratedTableModel
implements GlobalTableModelInterface {
    private static final Logger logger = LoggerFactory.getLogger(ExtractionResultsTableModel.class);
    private final HashMap<Integer, TableCellRenderer> m_rendererMap = new HashMap();
    private List<IRawFile> m_rawFiles = new ArrayList<IRawFile>();
    private List<ExtractionObject> m_extractionObjects = new ArrayList<ExtractionObject>(0);

    public void setRawFiles(List<IRawFile> rawFiles) {
        this.m_rawFiles = rawFiles;
    }

    public ExtractionObject getExtractionResultAt(int rowId) {
        if (rowId > -1 && rowId < this.m_extractionObjects.size()) {
            return this.m_extractionObjects.get(rowId);
        }
        return null;
    }

    public void setExtractions(List<ExtractionObject> extractionObjects) {
        this.m_extractionObjects = extractionObjects;
        this.fireTableDataChanged();
    }

    private Pair<IRawFile, EColumn> getColumnContent(int columnIndex) {
        int eCount = EColumn.values().length;
        int cCount = Column.values().length;
        int rawFileIdx = (columnIndex - cCount) / eCount;
        int columnIdx = (columnIndex - cCount - rawFileIdx * eCount) % eCount;
        return new ImmutablePair((Object)this.m_rawFiles.get(rawFileIdx), (Object)EColumn.values()[columnIdx]);
    }

    public int getRowCount() {
        return this.m_extractionObjects.size();
    }

    public int getColumnCount() {
        return Column.values().length + this.m_rawFiles.size() * EColumn.values().length;
    }

    public String getColumnName(int column) {
        if (column < Column.values().length) {
            return Column.values()[column].getName();
        }
        Pair<IRawFile, EColumn> index = this.getColumnContent(column);
        return ((IRawFile)index.getLeft()).getName() + "." + ((EColumn)((Object)index.getRight())).name().toLowerCase();
    }

    public Class getColumnClass(int col) {
        if (col == Column.MZ.id) {
            return Double.class;
        }
        if (col == Column.STATUS.id) {
            return ExtractionObject.Status.class;
        }
        Pair<IRawFile, EColumn> index = this.getColumnContent(col);
        if (index.getRight() == EColumn.INTENSITY || index.getRight() == EColumn.AREA) {
            return Double.class;
        }
        return Integer.class;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        int valuesCount = Column.values().length;
        if (columnIndex < valuesCount) {
            switch (Column.values()[columnIndex]) {
                case MZ: {
                    return this.m_extractionObjects.get(rowIndex).getMz();
                }
                case STATUS: {
                    return this.m_extractionObjects.get(rowIndex).getStatus();
                }
            }
        } else {
            Pair<IRawFile, EColumn> index = this.getColumnContent(columnIndex);
            AnnotatedChromatogram chromatogram = (AnnotatedChromatogram)this.m_extractionObjects.get(rowIndex).getChromatogram((IRawFile)index.getLeft());
            if (chromatogram == null) {
                return null;
            }
            if (index.getRight() == EColumn.INTENSITY) {
                if (chromatogram.getAnnotation() != null) {
                    return Float.valueOf(chromatogram.getAnnotation().getApexIntensity());
                }
                return chromatogram.getMaxIntensity();
            }
            if (index.getRight() == EColumn.SCANS_COUNT) {
                if (chromatogram.getAnnotation() != null) {
                    return chromatogram.getAnnotation().getScanCount();
                }
                return null;
            }
            if (index.getRight() == EColumn.AREA) {
                if (chromatogram.getAnnotation() != null) {
                    return Float.valueOf(chromatogram.getAnnotation().getArea());
                }
                return null;
            }
        }
        return null;
    }

    public String getToolTipForHeader(int column) {
        if (column < Column.values().length) {
            return Column.values()[column].getTooltip();
        }
        Pair<IRawFile, EColumn> index = this.getColumnContent(column);
        return ((EColumn)((Object)index.getRight())).name() + " value from " + ((IRawFile)index.getLeft()).getName();
    }

    public String getTootlTipValue(int row, int col) {
        return null;
    }

    public TableCellRenderer getRenderer(int row, int col) {
        if (this.m_rendererMap.containsKey(col)) {
            return this.m_rendererMap.get(col);
        }
        StatusRenderer renderer = null;
        if (col == Column.STATUS.id) {
            renderer = new StatusRenderer();
        }
        if (renderer != null) {
            this.m_rendererMap.put(col, renderer);
        }
        return renderer;
    }

    public GlobalTableModelInterface getFrozzenModel() {
        return this;
    }

    public Long getTaskId() {
        return -1L;
    }

    public LazyData getLazyData(int row, int col) {
        return null;
    }

    public void givePriorityTo(Long taskId, int row, int col) {
    }

    public void sortingChanged(int col) {
    }

    public int getSubTaskId(int col) {
        return -1;
    }

    public String getDataColumnIdentifier(int columnIndex) {
        return this.getColumnName(columnIndex);
    }

    public Class getDataColumnClass(int columnIndex) {
        return this.getColumnClass(columnIndex);
    }

    public Object getDataValueAt(int rowIndex, int columnIndex) {
        return this.getValueAt(rowIndex, columnIndex);
    }

    public int[] getKeysColumn() {
        return new int[]{Column.MZ.id};
    }

    public int getInfoColumn() {
        return Column.MZ.id;
    }

    public void setName(String name) {
    }

    public String getName() {
        return "Extraction Results";
    }

    public Map<String, Object> getExternalData() {
        return null;
    }

    public PlotInformation getPlotInformation() {
        return null;
    }

    public void addFilters(LinkedHashMap<Integer, Filter> filtersMap) {
    }

    public boolean isLoaded() {
        return true;
    }

    public int getLoadingPercentage() {
        return 1;
    }

    public PlotType getBestPlotType() {
        return null;
    }

    public int[] getBestColIndex(PlotType plotType) {
        return null;
    }

    public String getExportRowCell(int row, int col) {
        if (col == Column.STATUS.id) {
            ExtractionObject.Status st = this.m_extractionObjects.get(row).getStatus();
            if (st.equals((Object)ExtractionObject.Status.DONE)) {
                return "done";
            }
            if (st.equals((Object)ExtractionObject.Status.REQUESTED)) {
                return "requested";
            }
            return "none";
        }
        return ExportModelUtilities.getExportRowCell((ExtendedTableModelInterface)this, (int)row, (int)col);
    }

    public ArrayList<ExportFontData> getExportFonts(int row, int col) {
        return null;
    }

    public String getExportColumnName(int col) {
        return this.getColumnName(col);
    }

    public ArrayList<ExtraDataType> getExtraDataTypes() {
        ArrayList<ExtraDataType> list = new ArrayList<ExtraDataType>();
        list.add(new ExtraDataType(ExtractionObject.class, true));
        this.registerSingleValuesAsExtraTypes(list);
        return list;
    }

    public Object getValue(Class c) {
        return null;
    }

    public Object getRowValue(Class c, int row) {
        if (c.equals(ExtractionObject.class)) {
            return this.m_extractionObjects.get(row);
        }
        return null;
    }

    public Object getColValue(Class c, int col) {
        return null;
    }

    public static enum EColumn {
        INTENSITY,
        SCANS_COUNT,
        AREA;

    }

    public static enum Column {
        MZ(0, "m/z", "m/z extraction value"),
        STATUS(1, "status", "Extraction status : NONE, REQUESTED or DONE");

        private final String name;
        private final String tooltip;
        private final int id;

        private Column(int id, String name, String tooltip) {
            this.id = id;
            this.name = name;
            this.tooltip = tooltip;
        }

        public String getName() {
            return this.name;
        }

        public String getTooltip() {
            return this.tooltip;
        }

        public int getId() {
            return this.id;
        }
    }
}

