/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzscope.ui;

import com.compomics.util.general.IsotopicDistribution;
import fr.profi.chemistry.algo.AveragineComputer;
import fr.profi.chemistry.algo.MassComputer;
import fr.profi.chemistry.algo.MassPrecision$;
import fr.profi.chemistry.model.AminoAcidComposition;
import fr.profi.chemistry.model.AminoAcidTableLike;
import fr.profi.chemistry.model.AtomComposition;
import fr.profi.chemistry.model.AtomTableLike;
import fr.profi.chemistry.model.BiomoleculeAtomTable$;
import fr.profi.chemistry.model.HumanAminoAcidTable$;
import fr.profi.chemistry.model.ProteinogenicAminoAcidTable$;
import fr.profi.ms.algo.IsotopePatternEstimator;
import fr.profi.ms.algo.IsotopePatternEstimator$;
import fr.profi.ms.model.TheoreticalIsotopePattern;
import fr.profi.mzdb.model.DataMode;
import fr.profi.mzscope.ui.IsotopicTableModel;
import fr.proline.mzscope.model.Spectrum;
import fr.proline.mzscope.processing.SpectrumUtils;
import fr.proline.mzscope.ui.IMzScopeController;
import fr.proline.mzscope.ui.IRawFileViewer;
import fr.proline.mzscope.ui.MzScopePanel;
import fr.proline.mzscope.ui.model.ScanTableModel;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.graphics.BasePlotPanel;
import fr.proline.studio.graphics.PlotBaseAbstract;
import fr.proline.studio.graphics.PlotLinear;
import fr.proline.studio.table.DecoratedMarkerTable;
import fr.proline.studio.table.TablePopupMenu;
import fr.proline.studio.utils.IconManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;
import scala.collection.mutable.HashMap;

public class IsotopicToolPanel
extends JPanel {
    private static final Logger logger = LoggerFactory.getLogger(IsotopicToolPanel.class);
    private static final BiomoleculeAtomTable$ atomTable = BiomoleculeAtomTable$.MODULE$;
    private static final ProteinogenicAminoAcidTable$ aaTable = ProteinogenicAminoAcidTable$.MODULE$;
    private final IMzScopeController appController;
    protected BasePlotPanel m_graphPlot;
    protected JTextField m_mozTF;
    private IsotopicTableModel m_isotopicTableModel;
    private JComboBox<Integer> m_chargeCB;
    private JSlider m_mzSlider;
    private JRadioButton m_averagineBtn;
    private JRadioButton m_binomialBtn;
    private JTextField m_CTF;
    private JTextField m_HTF;
    private JTextField m_NTF;
    private JTextField m_OTF;
    private JTextField m_STF;
    private double m_fwhm = 0.01;
    private MassComputer massComputer = new MassComputer((AminoAcidTableLike)aaTable, MassPrecision$.MODULE$.MONOISOTOPIC());

    public IsotopicToolPanel(MzScopePanel mzScopePanel) {
        this.appController = mzScopePanel;
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        JToolBar toolbar = this.initToolbar();
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        mainPanel.add((Component)new JLabel("m/z:"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.m_mozTF = new JTextField(10);
        mainPanel.add((Component)this.m_mozTF, c);
        this.m_mozTF.addActionListener(e -> {
            this.updateAtomComposition();
            this.computeIsotopicDist();
        });
        ++c.gridx;
        c.weightx = 0.0;
        mainPanel.add((Component)new JLabel("charge:"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.m_chargeCB = new JComboBox<Integer>(new Integer[]{1, 2, 3, 4, 5, 6, 7, 8});
        mainPanel.add(this.m_chargeCB, c);
        this.m_chargeCB.addActionListener(e -> {
            this.updateAtomComposition();
            this.computeIsotopicDist();
        });
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 4;
        this.m_mzSlider = new JSlider(300, 3000);
        mainPanel.add((Component)this.m_mzSlider, c);
        this.m_mzSlider.addChangeListener(e -> {
            this.m_mozTF.setText(Double.toString(this.m_mzSlider.getValue()));
            this.updateAtomComposition();
            this.computeIsotopicDist();
        });
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        c.gridwidth = 4;
        mainPanel.add((Component)this.getFormulaPanel(), c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        c.weightx = 0.0;
        this.m_averagineBtn = new JRadioButton("Averagine (based on mass & charge)");
        this.m_averagineBtn.setSelected(true);
        this.m_averagineBtn.addActionListener(e -> this.computeIsotopicDist());
        mainPanel.add((Component)this.m_averagineBtn, c);
        c.gridx += 2;
        this.m_binomialBtn = new JRadioButton("Binomial (based on atomic composition)");
        this.m_binomialBtn.addActionListener(e -> this.computeIsotopicDist());
        mainPanel.add((Component)this.m_binomialBtn, c);
        ButtonGroup group = new ButtonGroup();
        group.add(this.m_averagineBtn);
        group.add(this.m_binomialBtn);
        DecoratedMarkerTable m_table = new DecoratedMarkerTable(){

            public void addTableModelListener(TableModelListener l) {
                this.getModel().addTableModelListener(l);
            }

            public TablePopupMenu initPopupMenu() {
                return null;
            }

            public void prepostPopupMenu() {
            }
        };
        this.m_isotopicTableModel = new IsotopicTableModel();
        m_table.setModel((TableModel)((Object)this.m_isotopicTableModel));
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView((Component)m_table);
        m_table.setFillsViewportHeight(true);
        m_table.setViewport(jScrollPane.getViewport());
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 4;
        c.weightx = 1.0;
        c.weighty = 1.0;
        mainPanel.add((Component)jScrollPane, c);
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BorderLayout());
        leftPanel.add((Component)toolbar, "West");
        leftPanel.add((Component)mainPanel, "Center");
        JSplitPane splitPane = new JSplitPane();
        splitPane.setLeftComponent(leftPanel);
        this.m_graphPlot = new BasePlotPanel();
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new GridBagLayout());
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        rightPanel.add((Component)new JLabel("fwhm:"), c);
        JSlider fwhmSlider = new JSlider(0, 200);
        fwhmSlider.setValue((int)(this.m_fwhm * 1000.0));
        fwhmSlider.addChangeListener(e -> {
            this.m_fwhm = (double)((JSlider)e.getSource()).getValue() / 1000.0;
            this.updatePatternViewer();
        });
        ++c.gridx;
        c.weightx = 1.0;
        rightPanel.add((Component)fwhmSlider, c);
        ++c.gridy;
        c.gridx = 0;
        c.weighty = 1.0;
        c.gridwidth = 2;
        rightPanel.add((Component)this.m_graphPlot, c);
        splitPane.setRightComponent(rightPanel);
        this.add((Component)splitPane, "Center");
    }

    private JPanel getFormulaPanel() {
        JPanel formulaPanel = new JPanel();
        formulaPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridy = 0;
        c.gridx = 0;
        formulaPanel.add((Component)new JLabel("C"), c);
        ++c.gridx;
        this.m_CTF = new JTextField(3);
        this.m_CTF.addActionListener(e -> {
            this.computeMozFromFormula();
            this.computeIsotopicDist();
        });
        formulaPanel.add((Component)this.m_CTF, c);
        ++c.gridx;
        formulaPanel.add((Component)new JLabel("H"), c);
        ++c.gridx;
        this.m_HTF = new JTextField(3);
        formulaPanel.add((Component)this.m_HTF, c);
        ++c.gridx;
        formulaPanel.add((Component)new JLabel("N"), c);
        ++c.gridx;
        this.m_NTF = new JTextField(3);
        formulaPanel.add((Component)this.m_NTF, c);
        ++c.gridx;
        formulaPanel.add((Component)new JLabel("O"), c);
        ++c.gridx;
        this.m_OTF = new JTextField(3);
        formulaPanel.add((Component)this.m_OTF, c);
        ++c.gridx;
        formulaPanel.add((Component)new JLabel("S"), c);
        ++c.gridx;
        this.m_STF = new JTextField(3);
        formulaPanel.add((Component)this.m_STF, c);
        return formulaPanel;
    }

    private void computeMozFromFormula() {
        double monoMass = this.getMonoMassFromFormula();
        int charge = (Integer)this.m_chargeCB.getSelectedItem();
        this.m_mozTF.setText(Double.toString(this.massToMz(monoMass, charge)));
    }

    private double getMonoMassFromMzField() {
        int charge = (Integer)this.m_chargeCB.getSelectedItem();
        double mz = Double.parseDouble(this.m_mozTF.getText());
        return this.mzToMass(mz, charge);
    }

    private double getMonoMassFromFormula() {
        int cAb = this.m_CTF.getText().length() > 0 ? Integer.parseInt(this.m_CTF.getText()) : 0;
        int hAb = this.m_HTF.getText().length() > 0 ? Integer.parseInt(this.m_HTF.getText()) : 0;
        int nAb = this.m_NTF.getText().length() > 0 ? Integer.parseInt(this.m_NTF.getText()) : 0;
        int oAb = this.m_OTF.getText().length() > 0 ? Integer.parseInt(this.m_OTF.getText()) : 0;
        int sAb = this.m_STF.getText().length() > 0 ? Integer.parseInt(this.m_STF.getText()) : 0;
        double monoMass = atomTable.getAtom("C").monoMass() * (double)cAb + atomTable.getAtom("H").monoMass() * (double)hAb + atomTable.getAtom("N").monoMass() * (double)nAb + atomTable.getAtom("O").monoMass() * (double)oAb + atomTable.getAtom("S").monoMass() * (double)sAb;
        return monoMass;
    }

    private double mzToMass(double mz, int charge) {
        return mz * (double)charge - (double)charge * 1.007276466812;
    }

    private double massToMz(double monoMass, int charge) {
        return (monoMass + (double)charge * 1.007276466812) / (double)charge;
    }

    private void updateAtomComposition() {
        if (this.m_mozTF.getText() != null && !this.m_mozTF.getText().isEmpty()) {
            int charge = (Integer)this.m_chargeCB.getSelectedItem();
            double mz = Double.parseDouble(this.m_mozTF.getText());
            AveragineComputer computer = new AveragineComputer((AminoAcidTableLike)HumanAminoAcidTable$.MODULE$, (AtomTableLike)atomTable);
            AtomComposition composition = (AtomComposition)computer.computeAveragine((double)this.mzToMass((double)mz, (int)charge), (boolean)false, (float)0.01f)._1;
            composition.roundAbundances();
            this.displayAtomComposition(composition);
        }
    }

    private void displayAtomComposition(AtomComposition composition) {
        HashMap atoms = composition.abundanceMap();
        int cAb = atoms.get((Object)atomTable.getAtom("C")).isDefined() ? ((Float)atoms.get((Object)atomTable.getAtom("C")).get()).intValue() : 0;
        this.m_CTF.setText(Integer.toString(cAb));
        int hAb = atoms.get((Object)atomTable.getAtom("H")).isDefined() ? ((Float)atoms.get((Object)atomTable.getAtom("H")).get()).intValue() : 0;
        this.m_HTF.setText(Integer.toString(hAb));
        int nAb = atoms.get((Object)atomTable.getAtom("N")).isDefined() ? ((Float)atoms.get((Object)atomTable.getAtom("N")).get()).intValue() : 0;
        this.m_NTF.setText(Integer.toString(nAb));
        int oAb = atoms.get((Object)atomTable.getAtom("O")).isDefined() ? ((Float)atoms.get((Object)atomTable.getAtom("O")).get()).intValue() : 0;
        this.m_OTF.setText(Integer.toString(oAb));
        int sAb = atoms.get((Object)atomTable.getAtom("S")).isDefined() ? ((Float)atoms.get((Object)atomTable.getAtom("S")).get()).intValue() : 0;
        this.m_STF.setText(Integer.toString(sAb));
    }

    private void computeIsotopicDist() {
        if (this.m_mozTF.getText() != null && !this.m_mozTF.getText().isEmpty()) {
            if (this.m_averagineBtn.isSelected()) {
                logger.info("Compute Isotopic Distribution using Averagine model");
                double moz = Double.parseDouble(this.m_mozTF.getText());
                int charge = (Integer)this.m_chargeCB.getSelectedItem();
                TheoreticalIsotopePattern pattern = IsotopePatternEstimator.getTheoreticalPattern((double)moz, (int)charge);
                this.m_isotopicTableModel.setPattern(pattern);
            } else {
                logger.info("Compute Isotopic Distribution using Binomial model");
                int cAb = this.m_CTF.getText().length() > 0 ? Integer.parseInt(this.m_CTF.getText()) : 0;
                int hAb = this.m_HTF.getText().length() > 0 ? Integer.parseInt(this.m_HTF.getText()) : 0;
                int nAb = this.m_NTF.getText().length() > 0 ? Integer.parseInt(this.m_NTF.getText()) : 0;
                int oAb = this.m_OTF.getText().length() > 0 ? Integer.parseInt(this.m_OTF.getText()) : 0;
                int sAb = this.m_STF.getText().length() > 0 ? Integer.parseInt(this.m_STF.getText()) : 0;
                int charge = (Integer)this.m_chargeCB.getSelectedItem();
                double monoMz = Double.parseDouble(this.m_mozTF.getText());
                IsotopicDistribution dist = new IsotopicDistribution(cAb, nAb, hAb, oAb, sAb);
                dist.calculate();
                Double[] values = dist.getPercTot();
                Double max = Arrays.stream(values).max(Double::compareTo).get();
                List l = Arrays.stream(values).map(v -> new Tuple2((Object)0.0, (Object)Float.valueOf((float)(100.0 * v / max)))).collect(Collectors.toList());
                Tuple2[] ab = new Tuple2[l.size()];
                for (int k = 0; k < l.size(); ++k) {
                    ab[k] = new Tuple2((Object)(monoMz + (double)k * IsotopePatternEstimator$.MODULE$.avgIsoMassDiff() / (double)charge), ((Tuple2)l.get((int)k))._2);
                }
                TheoreticalIsotopePattern pattern = TheoreticalIsotopePattern.apply((Tuple2[])ab, (int)((Integer)this.m_chargeCB.getSelectedItem()));
                this.m_isotopicTableModel.setPattern(pattern);
            }
            this.updatePatternViewer();
        }
    }

    protected JToolBar initToolbar() {
        JToolBar toolbar = new JToolBar(1);
        toolbar.setFloatable(false);
        JButton displayPatternBtn = new JButton();
        displayPatternBtn.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.CENTROID_SPECTRA));
        displayPatternBtn.setToolTipText("Display pattern in current spectrum");
        displayPatternBtn.addActionListener(e -> this.displayIsotopicPattern());
        toolbar.add(displayPatternBtn);
        JButton aaSeqBtn = new JButton();
        aaSeqBtn.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.QUESTION));
        aaSeqBtn.setToolTipText("Enter Amino Acid sequence");
        aaSeqBtn.addActionListener(e -> this.enterAASequence());
        toolbar.add(aaSeqBtn);
        return toolbar;
    }

    private void enterAASequence() {
        String sequence = (String)JOptionPane.showInputDialog(null, "AA sequence", "Amino Acid Sequence", -1, null, null, "MENHIR");
        if (sequence != null && sequence.length() > 0) {
            double mass = this.massComputer.computeMass(sequence);
            int charge = (Integer)this.m_chargeCB.getSelectedItem();
            this.m_mozTF.setText(Double.toString(this.massToMz(mass, charge)));
            AminoAcidComposition aaCompo = new AminoAcidComposition(sequence, (AminoAcidTableLike)aaTable);
            this.displayAtomComposition(aaCompo.getAtomComposition((AtomTableLike)atomTable));
            this.computeIsotopicDist();
        }
    }

    private void displayIsotopicPattern() {
        IRawFileViewer viewer = this.appController.getCurrentRawFileViewer();
        Spectrum currentSpectrum = viewer.getCurrentSpectrum();
        int maxTheoreticalPeakIndex = this.m_isotopicTableModel.getIsotopicPattern().theoreticalMaxPeakelIndex();
        int index = SpectrumUtils.getNearestPeakIndex((double[])currentSpectrum.getMasses(), (double)this.m_isotopicTableModel.getMasses()[maxTheoreticalPeakIndex]);
        double maxCurrentIntensity = currentSpectrum.getIntensities()[index];
        Spectrum s = SpectrumUtils.buildSpectrum((double[])this.m_isotopicTableModel.getMasses(), (float[])this.m_isotopicTableModel.getAbundances(), (double)this.m_fwhm, (DataMode)DataMode.FITTED);
        viewer.setReferenceSpectrum(s, Float.valueOf((float)(maxCurrentIntensity / (double)this.m_isotopicTableModel.getAbundances()[maxTheoreticalPeakIndex])));
    }

    private void updatePatternViewer() {
        this.m_graphPlot.clearPlots();
        float maxY = 0.0f;
        boolean index = false;
        Spectrum spectrum = SpectrumUtils.buildSpectrum((double[])this.m_isotopicTableModel.getMasses(), (float[])this.m_isotopicTableModel.getAbundances(), (double)this.m_fwhm, (DataMode)DataMode.FITTED);
        ScanTableModel scanModel = new ScanTableModel(spectrum);
        PlotLinear plot = new PlotLinear(this.m_graphPlot, (ExtendedTableModelInterface)scanModel, null, 0, 1);
        plot.setStrokeFixed(true);
        plot.setPlotInformation(scanModel.getPlotInformation());
        this.m_graphPlot.setPlot((PlotBaseAbstract)plot);
        ((PlotBaseAbstract)this.m_graphPlot.getPlots().get(0)).clearMarkers();
        this.m_graphPlot.getYAxis().lockMinValue(Double.valueOf(0.0));
        this.m_graphPlot.getYAxis().setRange(0.0, 110.0);
        this.m_graphPlot.repaint();
    }
}

