/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.util;

import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;

public final class MathUtils {
    public static final float EPSILON_FLOAT = 1.0E-6f;
    public static final double EPSILON_LOW_PRECISION = 1.0E-6;
    public static final double EPSILON_HIGH_PRECISION = 1.0E-14;

    public static boolean nearlyEquals(double a, double b, double eps) {
        if (a == b) {
            return true;
        }
        return Math.abs(a - b) < eps;
    }

    private MathUtils() {
    }

    public static double[][] matrixSolver(double[][] coefficients, double[][] values, boolean coeffTransposed) {
        if (values == null || values.length == 0) {
            return new double[0][0];
        }
        double[][] tCoefficients = coeffTransposed ? coefficients : MathUtils.transposeMatrix(coefficients);
        double[][] newValues = new double[values.length][values[0].length];
        Array2DRowRealMatrix coeffMatrix = new Array2DRowRealMatrix(tCoefficients, false);
        DecompositionSolver solver = new LUDecomposition((RealMatrix)coeffMatrix).getSolver();
        ArrayRealVector constants = null;
        RealVector result = null;
        for (int i = 0; i < values.length; ++i) {
            double[] rowVal = values[i];
            constants = new ArrayRealVector(rowVal, false);
            result = solver.solve((RealVector)constants);
            newValues[i] = result.toArray();
        }
        return newValues;
    }

    public static double[][] transposeMatrix(double[][] m) {
        int d1 = m.length;
        int d2 = m[0].length;
        double[][] temp = new double[d2][d1];
        for (int i = 0; i < d1; ++i) {
            for (int j = 0; j < d2; ++j) {
                temp[j][i] = m[i][j];
            }
        }
        return temp;
    }
}

