/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.extendedtablemodel;

import fr.proline.studio.export.ExportFontData;
import fr.proline.studio.extendedtablemodel.ChildModelInterface;
import fr.proline.studio.extendedtablemodel.ExtraDataType;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.filter.Filter;
import fr.proline.studio.filter.FilterTableModel;
import fr.proline.studio.filter.FilterTableModelInterface;
import fr.proline.studio.graphics.PlotDataSpec;
import fr.proline.studio.graphics.PlotInformation;
import fr.proline.studio.graphics.PlotType;
import fr.proline.studio.table.LazyData;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.swingx.JXTable;

public class CompoundTableModel
extends AbstractTableModel
implements GlobalTableModelInterface,
TableModelListener,
FilterTableModelInterface {
    private GlobalTableModelInterface m_baseModel = null;
    private GlobalTableModelInterface m_lastModel = null;
    private FilterTableModel m_filterModel = null;

    public CompoundTableModel(GlobalTableModelInterface baseModel, boolean filterCapability) {
        this.setBaseModel(baseModel);
    }

    public final void setBaseModel(GlobalTableModelInterface baseModel) {
        this.m_baseModel = baseModel;
        this.m_lastModel = baseModel;
        if (this.m_baseModel != null) {
            this.m_baseModel.addTableModelListener(this);
        }
    }

    public void addModel(ChildModelInterface model) {
        if (this.m_filterModel != null) {
            this.m_filterModel.getTableModelSource().removeTableModelListener(this.m_filterModel);
            model.setParentModel(this.m_filterModel.getTableModelSource());
            model.addTableModelListener(this.m_filterModel);
            this.m_filterModel.setTableModelSource(model);
            this.filter();
        } else {
            this.m_lastModel.removeTableModelListener(this);
            model.setParentModel(this.m_lastModel);
            model.addTableModelListener(this);
            this.m_lastModel = model;
        }
        this.fireTableStructureChanged();
    }

    public GlobalTableModelInterface getBaseModel() {
        return this.m_baseModel;
    }

    public GlobalTableModelInterface getLastNonFilterModel() {
        if (this.m_filterModel == null) {
            return this.m_lastModel;
        }
        return this.m_filterModel.getTableModelSource();
    }

    public int convertCompoundRowToBaseModelRow(int row) {
        if (this.m_filterModel == null) {
            return row;
        }
        return this.m_filterModel.convertRowToOriginalModel(row);
    }

    public int convertBaseModelRowToCompoundRow(int row) {
        if (this.m_filterModel == null) {
            return row;
        }
        return this.m_filterModel.convertOriginalModelToRow(row);
    }

    @Override
    public int getRowCount() {
        if (this.m_lastModel == null) {
            return 0;
        }
        return this.m_lastModel.getRowCount();
    }

    @Override
    public int getColumnCount() {
        if (this.m_lastModel == null) {
            return 0;
        }
        return this.m_lastModel.getColumnCount();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.m_lastModel.getValueAt(rowIndex, columnIndex);
    }

    @Override
    public String getColumnName(int column) {
        return this.m_lastModel.getColumnName(column);
    }

    public Class getColumnClass(int columnIndex) {
        return this.m_lastModel.getColumnClass(columnIndex);
    }

    @Override
    public void initFilters() {
        if (this.m_filterModel == null) {
            this.m_filterModel = new FilterTableModel(this.m_lastModel);
            this.m_lastModel.removeTableModelListener(this);
            this.m_lastModel = this.m_filterModel;
            this.m_filterModel.addTableModelListener(this);
        }
    }

    @Override
    public LinkedHashMap<Integer, Filter> getFilters() {
        if (this.m_filterModel == null) {
            this.initFilters();
        }
        return this.m_filterModel.getFilters();
    }

    @Override
    public Filter getColumnFilter(int col) {
        if (this.m_filterModel == null) {
            return null;
        }
        return this.m_filterModel.getColumnFilter(col);
    }

    @Override
    public boolean filter() {
        if (this.m_filterModel == null) {
            return false;
        }
        this.m_filterModel.filter();
        return true;
    }

    @Override
    public boolean filter(int row, int col) {
        if (this.m_filterModel == null) {
            return false;
        }
        return this.m_filterModel.filter(row, col);
    }

    @Override
    public boolean filter(int row) {
        if (this.m_filterModel == null) {
            return false;
        }
        return this.m_filterModel.filter(row);
    }

    @Override
    public int convertRowToOriginalModel(int row) {
        if (this.m_filterModel == null) {
            return row;
        }
        return this.m_filterModel.convertRowToOriginalModel(row);
    }

    @Override
    public int convertOriginalModelToRow(int row) {
        if (this.m_filterModel == null) {
            return row;
        }
        return this.m_filterModel.convertOriginalModelToRow(row);
    }

    @Override
    public void restrain(HashSet<Integer> restrainRowSet) {
        this.initFilters();
        this.m_filterModel.restrain(restrainRowSet);
    }

    @Override
    public HashSet<Integer> getRestrainRowSet() {
        if (this.m_filterModel == null) {
            return null;
        }
        return this.m_filterModel.getRestrainRowSet();
    }

    @Override
    public boolean hasRestrain() {
        if (this.m_filterModel == null) {
            return false;
        }
        return this.m_filterModel.hasRestrain();
    }

    @Override
    public int search(JXTable table, Filter f, boolean newSearch) {
        this.initFilters();
        return this.m_filterModel.search(table, f, newSearch);
    }

    @Override
    public boolean isLoaded() {
        if (this.m_lastModel == null) {
            return false;
        }
        return this.m_lastModel.isLoaded();
    }

    @Override
    public int getLoadingPercentage() {
        if (this.m_lastModel == null) {
            return 0;
        }
        return this.m_lastModel.getLoadingPercentage();
    }

    @Override
    public String getDataColumnIdentifier(int columnIndex) {
        return this.m_lastModel.getDataColumnIdentifier(columnIndex);
    }

    @Override
    public Class getDataColumnClass(int columnIndex) {
        return this.m_lastModel.getDataColumnClass(columnIndex);
    }

    @Override
    public Object getDataValueAt(int rowIndex, int columnIndex) {
        return this.m_lastModel.getDataValueAt(rowIndex, columnIndex);
    }

    @Override
    public int[] getKeysColumn() {
        return this.m_lastModel.getKeysColumn();
    }

    @Override
    public int getInfoColumn() {
        return this.m_lastModel.getInfoColumn();
    }

    @Override
    public void setName(String name) {
        this.m_lastModel.setName(name);
    }

    @Override
    public String getName() {
        return this.m_lastModel.getName();
    }

    @Override
    public Map<String, Object> getExternalData() {
        return this.m_lastModel.getExternalData();
    }

    @Override
    public PlotInformation getPlotInformation() {
        return this.m_lastModel.getPlotInformation();
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.fireTableChanged(e);
    }

    @Override
    public int getSubTaskId(int col) {
        return this.m_lastModel.getSubTaskId(col);
    }

    @Override
    public Long getTaskId() {
        return this.m_lastModel.getTaskId();
    }

    @Override
    public LazyData getLazyData(int row, int col) {
        return this.m_lastModel.getLazyData(row, col);
    }

    @Override
    public void givePriorityTo(Long taskId, int row, int col) {
        this.m_lastModel.givePriorityTo(taskId, row, col);
    }

    @Override
    public void sortingChanged(int col) {
        this.m_lastModel.sortingChanged(col);
    }

    @Override
    public String getToolTipForHeader(int col) {
        return this.m_lastModel.getToolTipForHeader(col);
    }

    @Override
    public String getTootlTipValue(int row, int col) {
        return this.m_lastModel.getTootlTipValue(row, col);
    }

    @Override
    public void addFilters(LinkedHashMap<Integer, Filter> filtersMap) {
        this.m_lastModel.addFilters(filtersMap);
    }

    @Override
    public PlotType getBestPlotType() {
        return this.m_lastModel.getBestPlotType();
    }

    @Override
    public int[] getBestColIndex(PlotType plotType) {
        return this.m_lastModel.getBestColIndex(plotType);
    }

    @Override
    public String getExportRowCell(int row, int col) {
        return this.m_lastModel.getExportRowCell(row, col);
    }

    @Override
    public ArrayList<ExportFontData> getExportFonts(int row, int col) {
        return this.m_lastModel.getExportFonts(row, col);
    }

    @Override
    public String getExportColumnName(int col) {
        return this.m_lastModel.getExportColumnName(col);
    }

    @Override
    public void setTableModelSource(GlobalTableModelInterface tableModelSource) {
    }

    @Override
    public GlobalTableModelInterface getTableModelSource() {
        return null;
    }

    @Override
    public TableCellRenderer getRenderer(int row, int col) {
        return this.m_lastModel.getRenderer(row, col);
    }

    @Override
    public long row2UniqueId(int rowIndex) {
        return this.m_lastModel.row2UniqueId(rowIndex);
    }

    @Override
    public int uniqueId2Row(long id) {
        return this.m_lastModel.uniqueId2Row(id);
    }

    @Override
    public GlobalTableModelInterface getFrozzenModel() {
        CompoundTableModel copyModel = new CompoundTableModel(null, true);
        ArrayList<GlobalTableModelInterface> modelList = new ArrayList<GlobalTableModelInterface>();
        GlobalTableModelInterface curModel = this.m_lastModel;
        FilterTableModel filterModel = null;
        while (curModel != null) {
            GlobalTableModelInterface frozzenModel = curModel.getFrozzenModel();
            modelList.add(0, frozzenModel);
            if (frozzenModel instanceof FilterTableModel) {
                filterModel = (FilterTableModel)frozzenModel;
            }
            if (curModel instanceof ChildModelInterface) {
                curModel = ((ChildModelInterface)curModel).getParentModel();
                continue;
            }
            curModel = null;
        }
        if (modelList.isEmpty()) {
            return copyModel;
        }
        for (int i = modelList.size() - 1; i >= 1; --i) {
            GlobalTableModelInterface prevModel = (GlobalTableModelInterface)modelList.get(i - 1);
            GlobalTableModelInterface model = (GlobalTableModelInterface)modelList.get(i);
            if (!(model instanceof ChildModelInterface)) continue;
            ((ChildModelInterface)model).setParentModel(prevModel);
            prevModel.addTableModelListener((TableModelListener)((Object)model));
        }
        copyModel.m_baseModel = (GlobalTableModelInterface)modelList.get(0);
        copyModel.m_filterModel = filterModel;
        if (filterModel != null) {
            filterModel.setTableModelSource(((ChildModelInterface)((Object)filterModel)).getParentModel());
        }
        copyModel.m_lastModel = (GlobalTableModelInterface)modelList.get(modelList.size() - 1);
        copyModel.m_lastModel.addTableModelListener(this);
        return copyModel;
    }

    @Override
    public ArrayList<ExtraDataType> getExtraDataTypes() {
        return this.m_lastModel.getExtraDataTypes();
    }

    @Override
    public Object getValue(Class c) {
        return this.m_lastModel.getValue(c);
    }

    @Override
    public Object getRowValue(Class c, int rowIndex) {
        return this.m_lastModel.getRowValue(c, rowIndex);
    }

    @Override
    public Object getColValue(Class c, int col) {
        return this.m_lastModel.getColValue(c, col);
    }

    @Override
    public void addSingleValue(Object v) {
        this.m_lastModel.addSingleValue(v);
    }

    @Override
    public Object getSingleValue(Class c) {
        return this.m_lastModel.getSingleValue(c);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.m_lastModel.isCellEditable(rowIndex, columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.m_lastModel.setValueAt(aValue, rowIndex, columnIndex);
    }

    @Override
    public PlotDataSpec getDataSpecAt(int i) {
        return this.m_lastModel.getDataSpecAt(i);
    }
}

