/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.graphics;

import fr.proline.studio.WindowManager;
import fr.proline.studio.graphics.colorpicker.ColorDataInterface;
import fr.proline.studio.graphics.colorpicker.ColorPickerDialog;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;

public class ColorButton
extends JButton
implements ColorDataInterface {
    private static final int WIDTH = 135;
    private static final int HEIGHT = 35;
    private final Dimension m_dimension = new Dimension(135, 35);
    private ArrayList<ColorDataInterface> m_listeners = null;
    private final int SQUARE_SIZE = 10;

    public void initActionListener() {
        this.addActionListener(this.getActionListener());
    }

    protected ActionListener getActionListener() {
        final ColorButton colorButton = this;
        ActionListener a = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorPickerDialog colorPickerDialog = new ColorPickerDialog((Window)WindowManager.getDefault().getMainWindow(), colorButton.getBackground());
                colorPickerDialog.setLocationRelativeTo(colorButton);
                colorPickerDialog.setVisible(true);
                if (colorPickerDialog.getButtonClicked() == 0) {
                    colorButton.setBackground(colorPickerDialog.getColor());
                    ColorButton.this.colorChangedToListeners();
                }
            }
        };
        return a;
    }

    public void setColor(Color c) {
        this.setBackground(c);
    }

    public Color getColor() {
        return this.getBackground();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.m_dimension;
    }

    @Override
    protected void paintComponent(Graphics g) {
        int height = this.getHeight();
        int width = this.getWidth();
        g.setColor(Color.white);
        g.fillRect(0, 0, width, height);
        g.setColor(Color.gray);
        int y = 0;
        do {
            int x = 0;
            do {
                if ((x + y) % 2 != 0) continue;
                g.fillRect(x * 10, y * 10, 10, 10);
            } while (++x * 10 <= width);
        } while (++y * 10 <= height);
        g.setColor(this.getBackground());
        g.fillRect(0, 0, width, height);
        g.setColor(Color.darkGray);
        g.drawRect(0, 0, width - 1, height - 1);
    }

    @Override
    public void propagateColorChanged(int r, int g, int b) {
        this.setBackground(new Color(r, g, b, this.getBackground().getAlpha()));
    }

    @Override
    public int getRed() {
        return this.getBackground().getRed();
    }

    @Override
    public int getGreen() {
        return this.getBackground().getGreen();
    }

    @Override
    public int getBlue() {
        return this.getBackground().getBlue();
    }

    @Override
    public void addListener(ColorDataInterface colorDataInterface) {
        if (this.m_listeners == null) {
            this.m_listeners = new ArrayList();
        }
        this.m_listeners.add(colorDataInterface);
    }

    public void colorChangedToListeners() {
        if (this.m_listeners == null) {
            return;
        }
        for (ColorDataInterface cdi : this.m_listeners) {
            cdi.propagateColorChanged(this.getRed(), this.getGreen(), this.getBlue());
        }
    }
}

