/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.graphics;

import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.graphics.Axis;
import fr.proline.studio.graphics.BasePlotPanel;
import fr.proline.studio.graphics.CrossSelectionInterface;
import fr.proline.studio.graphics.PlotMultiDataAbstract;
import fr.proline.studio.graphics.PlotType;
import fr.proline.studio.graphics.XAxis;
import fr.proline.studio.graphics.YAxis;
import fr.proline.studio.graphics.core.PlotToolbarListenerInterface;
import fr.proline.studio.graphics.marker.LabelMarker;
import fr.proline.studio.graphics.marker.coordinates.PercentageCoordinates;
import fr.proline.studio.graphics.venndiagram.Circle;
import fr.proline.studio.graphics.venndiagram.IntersectArea;
import fr.proline.studio.graphics.venndiagram.Set;
import fr.proline.studio.graphics.venndiagram.SetList;
import fr.proline.studio.parameter.ColorParameter;
import fr.proline.studio.parameter.IntegerParameter;
import fr.proline.studio.parameter.ParameterList;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JSlider;
import javax.swing.JSpinner;

public class PlotVennDiagram
extends PlotMultiDataAbstract {
    final double EPSILON = 1.0E-15;
    private SetList m_setList = null;
    private boolean firstPaint = true;
    private ArrayList<ParameterList> m_parameterListArray = null;
    private final ColorParameter m_colorParameter;
    private final IntegerParameter m_thicknessParameter;
    private final IntegerParameter m_zoomParameter;
    private final IntegerParameter m_rotateParameter;
    private final IntegerParameter m_splitParameter;
    private final IntegerParameter m_xTranslationParameter;
    private final IntegerParameter m_yTranslationParameter;
    private final ParameterList m_colorParameterList;
    private final ArrayList<ColorParameter> m_colorAreaParameterList;
    private HashMap<Integer, Integer> m_allIntersections = new HashMap();
    private Color m_currentColor;
    private String m_currentThickness;
    private String m_currentZoom;
    private String m_currentRotate;
    private String m_currentSplit;
    private String m_currentXTranslation;
    private String m_currentYTranslation;
    private ArrayList<Color> m_currentAreaColorList = new ArrayList();

    public PlotVennDiagram(BasePlotPanel plotPanel, ExtendedTableModelInterface compareDataInterface, CrossSelectionInterface crossSelectionInterface, int[] cols) {
        super(plotPanel, PlotType.VENN_DIAGRAM_PLOT, compareDataInterface, crossSelectionInterface);
        this.update(cols, null);
        ActionListener repaintAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlotVennDiagram.this.m_plotPanel.forceUpdateDoubleBuffer();
                PlotVennDiagram.this.m_plotPanel.repaint();
            }
        };
        this.m_colorParameterList = new ParameterList("Colors");
        this.m_colorParameter = new ColorParameter("COLOR_BORDER_VENNDIAGRAM", "Border Color", Color.white);
        this.m_colorParameterList.add(this.m_colorParameter);
        this.m_thicknessParameter = new IntegerParameter("THICKNESS_BORDER_VENNDIAGRAM", "Border Thickness", JSpinner.class, (Integer)5, (Integer)1, (Integer)10);
        this.m_colorParameterList.add(this.m_thicknessParameter);
        this.m_colorAreaParameterList = new ArrayList();
        ParameterList transformationsParameterList = new ParameterList("Transformations");
        this.m_rotateParameter = new IntegerParameter("ROTATE_FACTOR_VENNDIAGRAM", "Rotation", JSlider.class, (Integer)0, (Integer)0, (Integer)359);
        this.m_zoomParameter = new IntegerParameter("ZOOM_FACTOR_VENNDIAGRAM", "Zooming", JSlider.class, (Integer)100, (Integer)10, (Integer)100);
        this.m_splitParameter = new IntegerParameter("SPLIT_FACTOR_VENNDIAGRAM", "Splitting", JSlider.class, (Integer)0, (Integer)0, (Integer)200);
        this.m_xTranslationParameter = new IntegerParameter("TRANSLATE_X_VENNDIAGRAM", "X Translation", JSlider.class, (Integer)0, (Integer)-200, (Integer)200);
        this.m_yTranslationParameter = new IntegerParameter("TRANSLATE_Y_VENNDIAGRAM", "Y Translation", JSlider.class, (Integer)0, (Integer)-200, (Integer)200);
        transformationsParameterList.add(this.m_rotateParameter);
        transformationsParameterList.add(this.m_zoomParameter);
        transformationsParameterList.add(this.m_splitParameter);
        transformationsParameterList.add(this.m_xTranslationParameter);
        transformationsParameterList.add(this.m_yTranslationParameter);
        this.m_parameterListArray = new ArrayList(2);
        this.m_parameterListArray.add(transformationsParameterList);
        this.m_parameterListArray.add(this.m_colorParameterList);
        this.m_colorParameter.setExternalActionListener(repaintAction);
        this.m_rotateParameter.setExternalActionListener(repaintAction);
        this.m_zoomParameter.setExternalActionListener(repaintAction);
        this.m_splitParameter.setExternalActionListener(repaintAction);
        this.m_thicknessParameter.setExternalActionListener(repaintAction);
        this.m_xTranslationParameter.setExternalActionListener(repaintAction);
        this.m_yTranslationParameter.setExternalActionListener(repaintAction);
        this.m_plotPanel.enableButton(PlotToolbarListenerInterface.BUTTONS.GRID, false);
        this.m_plotPanel.enableButton(PlotToolbarListenerInterface.BUTTONS.EXPORT_SELECTION, false);
        this.m_plotPanel.enableButton(PlotToolbarListenerInterface.BUTTONS.IMPORT_SELECTION, false);
        this.m_plotPanel.enableButton(PlotToolbarListenerInterface.BUTTONS.VIEW_ALL_MAP, false);
    }

    @Override
    public boolean needsXAxis() {
        return false;
    }

    @Override
    public boolean needsYAxis() {
        return false;
    }

    @Override
    public boolean canLogXAxis() {
        return false;
    }

    @Override
    public boolean canLogYAxis() {
        return false;
    }

    @Override
    public void parametersChanged() {
        int labelIndex = 0;
        int areaIndex = 0;
        for (IntersectArea intersectArea : this.m_setList.getGeneratedAreas()) {
            LabelMarker marker = (LabelMarker)this.m_markersList.get(labelIndex);
            marker.setReferenceColor(this.m_colorAreaParameterList.get(areaIndex).getColor());
            ++labelIndex;
            ++areaIndex;
        }
    }

    @Override
    public void paint(Graphics2D g2d, XAxis xAxis, YAxis yAxis) {
        Integer split;
        Integer rotation;
        Integer zoom;
        double zoomFactor;
        double translateFactorY;
        int height;
        if (this.m_setList == null) {
            return;
        }
        int width = this.m_plotPanel.getWidth();
        boolean scaled = this.m_setList.scale(width, height = this.m_plotPanel.getHeight(), 10);
        if (scaled || this.firstPaint) {
            this.m_setList.generateAreas();
            this.m_plotPanel.updateAxis(this);
            xAxis.setSize(0, height, width, 0);
            yAxis.setSize(0, 0, 0, height);
        }
        if (this.m_setList.getGeneratedAreas() == null) {
            return;
        }
        if (this.firstPaint) {
            this.firstPaint = false;
            this.prepareColorAreaParameterList();
            int labelIndex = 0;
            int areaIndex = 0;
            for (IntersectArea intersectArea : this.m_setList.getGeneratedAreas()) {
                double percentageX = 60.0 / (double)width;
                double percentageY = 1.0 - 30.0 * (double)(++labelIndex) / (double)height;
                LabelMarker marker = new LabelMarker(this.m_plotPanel, new PercentageCoordinates(percentageX, percentageY), intersectArea.getDisplayName(this), 2, 2, this.m_colorAreaParameterList.get(areaIndex).getColor());
                this.addMarker(marker);
                ++areaIndex;
            }
        }
        AffineTransform previousTransform = g2d.getTransform();
        Integer translateX = (Integer)this.m_xTranslationParameter.getObjectValue();
        double translateFactorX = translateX != null ? (double)translateX.intValue() : 0.0;
        Integer translateY = (Integer)this.m_yTranslationParameter.getObjectValue();
        double d = translateFactorY = translateY != null ? (double)translateY.intValue() : 0.0;
        if (translateFactorX != 0.0 || translateFactorY != 0.0) {
            g2d.transform(AffineTransform.getTranslateInstance(translateFactorX, translateFactorY));
        }
        double d2 = zoomFactor = (zoom = (Integer)this.m_zoomParameter.getObjectValue()) != null ? (double)zoom.intValue() / 100.0 : 1.0;
        if (zoom != null && zoom < 100) {
            g2d.transform(AffineTransform.getScaleInstance(zoomFactor, zoomFactor));
        }
        if ((rotation = (Integer)this.m_rotateParameter.getObjectValue()) != null && rotation > 0) {
            double angle = (double)rotation.intValue() * Math.PI / 180.0;
            double centerX = width / 2;
            double centerY = height / 2;
            g2d.transform(AffineTransform.getRotateInstance(angle, centerX, centerY));
        }
        double splitFactor = (split = (Integer)this.m_splitParameter.getObjectValue()) != null ? (double)split.intValue() : 0.0;
        int centerSplitX = width / 2;
        int centerSplitY = height / 2;
        ArrayList<Area> areaListForSplitFactor = null;
        int index = 0;
        for (IntersectArea intersectArea : this.m_setList.getGeneratedAreas()) {
            g2d.setColor(this.m_colorAreaParameterList.get(index).getColor());
            ++index;
            Area a = intersectArea.getArea();
            if (splitFactor > 0.0) {
                Rectangle r = a.getBounds();
                int centerX = r.x + r.width / 2;
                int centerY = r.y + r.height / 2;
                double trX = splitFactor * (double)(centerX - centerSplitX) / (double)(width - centerSplitX);
                double trY = splitFactor * (double)(centerY - centerSplitY) / (double)(height - centerSplitY);
                Area splittedArea = a.createTransformedArea(AffineTransform.getTranslateInstance(trX, trY));
                if (areaListForSplitFactor == null) {
                    areaListForSplitFactor = new ArrayList<Area>();
                }
                areaListForSplitFactor.add(splittedArea);
                g2d.fill(splittedArea);
                continue;
            }
            g2d.fill(a);
        }
        Color color = this.m_colorParameter.getColor();
        g2d.setColor(color);
        Stroke previousStroke = g2d.getStroke();
        Integer thickness = (Integer)this.m_thicknessParameter.getObjectValue();
        if (thickness == null) {
            thickness = 5;
        }
        g2d.setStroke(new BasicStroke(thickness.intValue()));
        if (splitFactor > 0.0) {
            for (Area a : areaListForSplitFactor) {
                g2d.draw(a);
            }
        } else {
            for (Set set : this.m_setList.getList()) {
                Circle c = set.getCircle();
                int x = (int)Math.round(c.getX() - c.getRadius());
                int y = (int)Math.round(c.getY() - c.getRadius());
                int size = (int)Math.round(c.getRadius() * 2.0);
                g2d.drawOval(x, y, size, size);
            }
        }
        g2d.setStroke(previousStroke);
        g2d.setTransform(previousTransform);
    }

    @Override
    public String getToolTipText(double x, double y) {
        return null;
    }

    @Override
    public void update() {
        int k;
        int i;
        this.m_setList = new SetList();
        int nbCols = this.m_cols.length;
        int nbRows = this.m_compareDataInterface.getRowCount();
        for (i = 0; i < nbCols; ++i) {
            int colId = this.m_cols[i];
            int nbValues = 0;
            int nbNonSpecificValues = 0;
            for (int j = 0; j < nbRows; ++j) {
                if (this.isValue(this.m_compareDataInterface.getDataValueAt(j, colId)) != 1) continue;
                for (k = 0; k < nbCols; ++k) {
                    if (k == i || this.isValue(this.m_compareDataInterface.getDataValueAt(j, this.m_cols[k])) != 1) continue;
                    ++nbNonSpecificValues;
                    break;
                }
                ++nbValues;
            }
            Set s = new Set(this.m_compareDataInterface.getDataColumnIdentifier(colId), nbValues, i);
            s.setSpecificSize(nbValues - nbNonSpecificValues);
            this.m_setList.addSet(s);
        }
        for (i = 0; i < nbCols; ++i) {
            int colId1 = this.m_cols[i];
            for (int j = i + 1; j < nbCols; ++j) {
                int colId2 = this.m_cols[j];
                int nbValues = 0;
                for (k = 0; k < nbRows; ++k) {
                    nbValues += this.isValue(this.m_compareDataInterface.getDataValueAt(k, colId1)) * this.isValue(this.m_compareDataInterface.getDataValueAt(k, colId2));
                }
                if (nbValues <= 0) continue;
                this.m_setList.addIntersection(this.m_setList.getSet(i), this.m_setList.getSet(j), nbValues);
            }
        }
        this.allIntersections();
        this.m_setList.approximateSolution();
        this.m_setList.optimizeSolution();
        if (this.m_markersList != null) {
            this.m_markersList.clear();
        }
        this.firstPaint = true;
        this.m_plotPanel.forceUpdateDoubleBuffer();
        this.m_plotPanel.repaint();
    }

    public int getIntersectionSize(Set[] setArray) {
        int intersectionOfSetsId = 0;
        for (Set s : setArray) {
            intersectionOfSetsId += (int)Math.round(Math.pow(2.0, s.getId()));
        }
        return this.m_allIntersections.get(intersectionOfSetsId);
    }

    public void allIntersections() {
        int nbRows = this.m_compareDataInterface.getRowCount();
        this.m_allIntersections.clear();
        ArrayList<Set> setList = this.m_setList.getList();
        int nb = setList.size();
        int powNb = (int)Math.round(Math.pow(2.0, nb));
        for (int intersectionOfSetsId = 1; intersectionOfSetsId < powNb; ++intersectionOfSetsId) {
            int nbValues = 0;
            for (int i = 0; i < nbRows; ++i) {
                boolean valuesFound = true;
                for (int setId = 0; setId < nb; ++setId) {
                    int pow = (int)Math.round(Math.pow(2.0, setId));
                    int colId = this.m_cols[setId];
                    valuesFound = (pow & intersectionOfSetsId) > 0 ? valuesFound && this.isValue(this.m_compareDataInterface.getDataValueAt(i, colId)) == 1 : valuesFound && this.isValue(this.m_compareDataInterface.getDataValueAt(i, colId)) == 0;
                }
                if (!valuesFound) continue;
                ++nbValues;
            }
            this.m_allIntersections.put(intersectionOfSetsId, nbValues);
        }
    }

    private int isValue(Object o) {
        if (o == null) {
            return 0;
        }
        if (Number.class.isAssignableFrom(o.getClass())) {
            Number value = (Number)o;
            if (value != null) {
                double d2 = value.doubleValue();
                if (Double.isNaN(d2) || Math.abs(d2) <= 1.0E-15) {
                    return 0;
                }
            } else {
                return 0;
            }
            return 1;
        }
        if (String.class.isAssignableFrom(o.getClass())) {
            String s = (String)o;
            if (s == null || s.isEmpty() || s.trim().isEmpty()) {
                return 0;
            }
            return 1;
        }
        return 1;
    }

    @Override
    public boolean select(double x, double y, boolean append) {
        return false;
    }

    @Override
    public boolean select(Path2D.Double path, double minX, double maxX, double minY, double maxY, boolean append) {
        return false;
    }

    @Override
    public ArrayList<ParameterList> getParameters() {
        this.m_currentColor = (Color)this.m_colorParameter.getObjectValue();
        this.m_currentThickness = this.m_thicknessParameter.getStringValue();
        this.m_currentZoom = this.m_zoomParameter.getStringValue();
        this.m_currentRotate = this.m_rotateParameter.getStringValue();
        this.m_currentSplit = this.m_splitParameter.getStringValue();
        this.m_currentXTranslation = this.m_xTranslationParameter.getStringValue();
        this.m_currentYTranslation = this.m_yTranslationParameter.getStringValue();
        this.prepareColorAreaParameterList();
        return this.m_parameterListArray;
    }

    private void prepareColorAreaParameterList() {
        int sizeColor;
        int size = this.m_setList.getGeneratedAreas().size();
        if (size != (sizeColor = this.m_colorAreaParameterList.size())) {
            this.m_colorAreaParameterList.clear();
            this.m_colorParameterList.clear();
            ActionListener repaintAction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PlotVennDiagram.this.m_plotPanel.forceUpdateDoubleBuffer();
                    PlotVennDiagram.this.m_plotPanel.repaint();
                }
            };
            int index = 1;
            for (IntersectArea intersectArea : this.m_setList.getGeneratedAreas()) {
                ColorParameter param = new ColorParameter("COLOR_AREA_VENNDIAGRAM" + index, "Color " + index, intersectArea.getColor());
                param.setExternalActionListener(repaintAction);
                this.m_colorAreaParameterList.add(param);
                this.m_colorParameterList.add(param);
                ++index;
            }
            this.m_colorParameterList.resetPanel();
        }
        this.m_currentAreaColorList.clear();
        for (ColorParameter parameter : this.m_colorAreaParameterList) {
            this.m_currentAreaColorList.add(parameter.getColor());
        }
    }

    @Override
    public boolean parametersCanceled() {
        this.m_colorParameter.setColor(this.m_currentColor);
        this.m_thicknessParameter.setValue(this.m_currentThickness);
        this.m_zoomParameter.setValue(this.m_currentZoom);
        this.m_rotateParameter.setValue(this.m_currentRotate);
        this.m_splitParameter.setValue(this.m_currentSplit);
        this.m_xTranslationParameter.setValue(this.m_currentXTranslation);
        this.m_yTranslationParameter.setValue(this.m_currentYTranslation);
        int index = 0;
        for (ColorParameter parameter : this.m_colorAreaParameterList) {
            parameter.setColor(this.m_currentAreaColorList.get(index));
            ++index;
        }
        return true;
    }

    @Override
    public boolean isMouseOnPlot(double x, double y) {
        return false;
    }

    @Override
    public boolean isMouseOnSelectedPlot(double x, double y) {
        return false;
    }

    @Override
    public String getEnumValueX(int index, boolean fromData) {
        return null;
    }

    @Override
    public String getEnumValueY(int index, boolean fromData, Axis axis) {
        return null;
    }

    @Override
    public double getNearestXData(double x) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double getNearestYData(double y) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double getXMin() {
        return 0.0;
    }

    @Override
    public double getXMax() {
        if (this.m_plotPanel == null) {
            return 0.0;
        }
        return this.m_plotPanel.getWidth();
    }

    @Override
    public double getYMin() {
        return 0.0;
    }

    @Override
    public double getYMax() {
        if (this.m_plotPanel == null) {
            return 0.0;
        }
        return this.m_plotPanel.getHeight();
    }

    @Override
    public ArrayList<Long> getSelectedIds() {
        return null;
    }

    @Override
    public void setSelectedIds(ArrayList<Long> selection) {
    }
}

