/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.graphics;

import java.awt.Color;
import java.awt.Graphics;

public class ZoomGesture {
    public static final int ACTION_NONE = 0;
    public static final int ACTION_ZOOM = 1;
    public static final int ACTION_UNZOOM = 2;
    private boolean m_isZooming = false;
    private boolean m_basePlot = true;
    private int m_action = 0;
    private int m_x1;
    private int m_x2;
    private int m_y1;
    private int m_y2;
    private int m_xStart;
    private int m_xEnd;
    private int m_yStart;
    private int m_yEnd;
    private static final int MIN_ZOOMING_DELTA = 10;

    public boolean isZooming() {
        return this.m_isZooming;
    }

    public void startZooming(int x, int y, boolean basePlot) {
        this.m_x1 = x;
        this.m_y1 = y;
        this.m_x2 = x;
        this.m_y2 = y;
        this.m_isZooming = true;
        this.m_basePlot = basePlot;
        this.m_action = 0;
    }

    public void moveZooming(int x, int y) {
        this.m_x2 = x;
        this.m_y2 = y;
    }

    public void stopZooming(int x, int y) {
        this.m_x2 = x;
        this.m_y2 = y;
        this.m_isZooming = false;
        this.m_action = Math.abs(this.m_x2 - this.m_x1) <= 10 || Math.abs(this.m_y2 - this.m_y1) <= 10 ? 0 : (this.m_x2 > this.m_x1 && this.m_y2 > this.m_y1 ? 1 : 2);
    }

    public void paint(Graphics g) {
        if (!this.m_isZooming) {
            return;
        }
        if (this.m_x2 < this.m_x1 || this.m_y2 < this.m_y1) {
            return;
        }
        g.setXORMode(Color.white);
        g.setColor(Color.red);
        if (this.m_x1 < this.m_x2) {
            this.m_xStart = this.m_x1;
            this.m_xEnd = this.m_x2;
        } else {
            this.m_xStart = this.m_x2;
            this.m_xEnd = this.m_x1;
        }
        if (this.m_y1 < this.m_y2) {
            this.m_yStart = this.m_y1;
            this.m_yEnd = this.m_y2;
        } else {
            this.m_yStart = this.m_y2;
            this.m_yEnd = this.m_y1;
        }
        g.drawRect(this.m_xStart, this.m_yStart, this.m_xEnd - this.m_xStart, this.m_yEnd - this.m_yStart);
    }

    public int getStartX() {
        return this.m_xStart;
    }

    public int getEndX() {
        return this.m_xEnd;
    }

    public int getStartY() {
        return this.m_yStart;
    }

    public int getEndY() {
        return this.m_yEnd;
    }

    public int getAction() {
        return this.m_action;
    }

    public boolean isBasePlot() {
        return this.m_basePlot;
    }
}

