/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.graphics.marker;

import fr.proline.studio.graphics.BasePlotPanel;
import fr.proline.studio.graphics.MoveableInterface;
import fr.proline.studio.graphics.marker.AbstractMarker;
import fr.proline.studio.graphics.marker.PointMarker;
import fr.proline.studio.graphics.marker.coordinates.AbstractCoordinates;
import fr.proline.studio.graphics.marker.coordinates.PixelCoordinates;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class LabelMarker
extends AbstractMarker
implements MoveableInterface {
    public static final int ORIENTATION_X_LEFT = 0;
    public static final int ORIENTATION_X_RIGHT = 1;
    public static final int ORIENTATION_XY_MIDDLE = 2;
    public static final int ORIENTATION_Y_TOP = 3;
    public static final int ORIENTATION_Y_BOTTOM = 4;
    public static final Font TEXT_FONT = new Font("Arial", 0, 12);
    public static final Font TITLE_FONT = new Font("Arial", 1, 16);
    private Font m_font = TEXT_FONT;
    private FontMetrics m_metrics;
    private PointMarker m_anchorMarker;
    private AbstractCoordinates m_labelCoordinates = null;
    private String m_valueLabel = null;
    private final int m_orientationX;
    private final int m_orientationY;
    private static final int LINE_DELTA = 18;
    private static final int COLOR_WIDTH = 15;
    private static final int DELTA_COLOR = 4;
    private static final int DELTA = 3;
    private int m_heightBox;
    private int m_widthBox;
    private Color m_referenceColor = null;
    private boolean m_drawLineToAnchor = true;
    private boolean m_drawFrame = true;
    private double m_zoomFactor = 1.0;
    private boolean m_firstPaint = true;

    public LabelMarker(BasePlotPanel plotPanel, AbstractCoordinates coordinates, String valueLabel) {
        super(plotPanel);
        this.m_valueLabel = valueLabel;
        this.m_anchorMarker = new PointMarker(plotPanel, coordinates);
        this.m_orientationX = 2;
        this.m_orientationY = 2;
        this.m_drawLineToAnchor = false;
    }

    public LabelMarker(BasePlotPanel plotPanel, AbstractCoordinates coordinates, String valueLabel, int orientationX, int orientationY) {
        super(plotPanel);
        this.m_valueLabel = valueLabel;
        this.m_anchorMarker = new PointMarker(plotPanel, coordinates);
        this.m_orientationX = orientationX;
        this.m_orientationY = orientationY;
        this.m_drawLineToAnchor = this.m_orientationX != 2;
    }

    public LabelMarker(BasePlotPanel plotPanel, AbstractCoordinates coordinates, String valueLabel, int orientationX, int orientationY, Color referenceColor) {
        super(plotPanel);
        this.m_valueLabel = valueLabel;
        this.m_anchorMarker = new PointMarker(plotPanel, coordinates);
        this.m_orientationX = orientationX;
        this.m_orientationY = orientationY;
        this.m_referenceColor = referenceColor;
        this.m_drawLineToAnchor = this.m_orientationX != 2;
    }

    public void setCoordinates(AbstractCoordinates coordinates) {
        this.m_anchorMarker.setCoordinates(coordinates);
        this.m_firstPaint = true;
    }

    public AbstractCoordinates getCoordinates() {
        return this.m_anchorMarker.getCoordinates();
    }

    public void setLabel(String valueLabel) {
        this.m_valueLabel = valueLabel;
        this.m_firstPaint = true;
    }

    public void setZoomFactor(double zoomFactor) {
        this.m_zoomFactor = zoomFactor;
    }

    public void setFont(Font f) {
        this.m_font = f;
    }

    public void setDrawFrame(boolean v) {
        this.m_drawFrame = v;
    }

    private boolean hasReferenceColor() {
        return this.m_referenceColor != null;
    }

    public void setReferenceColor(Color referenceColor) {
        this.m_referenceColor = referenceColor;
    }

    private void prepareCoordinates() {
        this.m_labelCoordinates = new PixelCoordinates(switch (this.m_orientationX) {
            case 0 -> -18;
            case 1 -> 18;
            default -> 0;
        }, switch (this.m_orientationY) {
            case 3 -> -18;
            case 4 -> 18;
            default -> 0;
        });
    }

    @Override
    public void paint(Graphics2D g) {
        int delta;
        AbstractCoordinates anchorCoordinates = this.m_anchorMarker.getCoordinates();
        int pixelX = (int)Math.round((double)anchorCoordinates.getPixelX(this.m_plotPanel) * this.m_zoomFactor);
        int pixelY = (int)Math.round((double)anchorCoordinates.getPixelY(this.m_plotPanel) * this.m_zoomFactor);
        g.setFont(this.m_font);
        if (this.m_firstPaint) {
            this.prepareCoordinates();
            int deltaX = this.m_labelCoordinates.getPixelX(this.m_plotPanel);
            int deltaY = this.m_labelCoordinates.getPixelY(this.m_plotPanel);
            this.m_metrics = g.getFontMetrics();
            int stringWidth = this.m_metrics.stringWidth(this.m_valueLabel);
            int stringHeight = this.m_metrics.getHeight();
            stringWidth += 6;
            if (this.hasReferenceColor()) {
                stringWidth += 23;
            }
            this.m_heightBox = stringHeight + 6;
            this.m_widthBox = stringWidth;
            int xBox = 0;
            int yBox = 0;
            if (this.m_orientationX == 1) {
                xBox = pixelX + deltaX;
                yBox = pixelY + deltaY - stringHeight / 2 - 3;
            } else if (this.m_orientationX == 0) {
                xBox = pixelX + deltaX - stringWidth;
                yBox = pixelY + deltaY - stringHeight / 2 - 3;
            } else if (this.m_orientationX == 2) {
                xBox = pixelX + deltaX - stringWidth / 2;
                yBox = pixelY + deltaY - stringHeight / 2 - 3;
            }
            Rectangle r = g.getClipBounds();
            if ((double)xBox < r.getX()) {
                xBox = (int)Math.round(r.getX());
            } else if ((double)(xBox + this.m_widthBox) > r.getWidth()) {
                xBox = (int)Math.round(r.getWidth() - (double)this.m_widthBox - 1.0);
            }
            if ((double)yBox < r.getY()) {
                yBox = (int)Math.round(r.getY());
            } else if ((double)(yBox + this.m_heightBox) > r.getHeight()) {
                yBox = (int)Math.round(r.getHeight() - (double)this.m_heightBox - 1.0);
            }
            this.m_labelCoordinates.setPixelPosition(this.m_plotPanel, xBox - pixelX, yBox - pixelY);
            this.m_firstPaint = false;
        }
        int xBox = pixelX + this.m_labelCoordinates.getPixelX(this.m_plotPanel);
        int yBox = pixelY + this.m_labelCoordinates.getPixelY(this.m_plotPanel);
        g.setColor(new Color(255, 255, 255, 196));
        g.fillRect(xBox, yBox, this.m_widthBox, this.m_heightBox);
        g.setColor(Color.black);
        if (this.m_drawFrame) {
            g.drawRect(xBox, yBox, this.m_widthBox, this.m_heightBox);
        }
        if (this.hasReferenceColor()) {
            g.setColor(this.m_referenceColor);
            g.fillRect(xBox + 4, yBox + (this.m_heightBox - 15) / 2, 15, 15);
            delta = 23;
            g.setColor(Color.black);
        } else {
            delta = 3;
        }
        int spacer = (this.m_heightBox - (this.m_metrics.getAscent() + this.m_metrics.getDescent())) / 2;
        g.drawString(this.m_valueLabel, xBox + delta, yBox + this.m_metrics.getAscent() + spacer);
        if (this.m_drawLineToAnchor) {
            g.setColor(Color.black);
            if (pixelX < xBox) {
                g.drawLine(pixelX, pixelY, xBox, yBox + this.m_heightBox / 2);
            } else if (pixelX > xBox + this.m_widthBox) {
                g.drawLine(pixelX, pixelY, xBox + this.m_widthBox, yBox + this.m_heightBox / 2);
            } else if (pixelY < yBox) {
                g.drawLine(pixelX, pixelY, xBox + this.m_widthBox / 2, yBox);
            } else if (pixelY > yBox) {
                g.drawLine(pixelX, pixelY, xBox + this.m_widthBox / 2, yBox + this.m_heightBox);
            }
        }
    }

    @Override
    public boolean insideXY(int x, int y) {
        if (this.m_labelCoordinates == null) {
            return false;
        }
        AbstractCoordinates anchorCoordinates = this.m_anchorMarker.getCoordinates();
        int pixelX = anchorCoordinates.getPixelX(this.m_plotPanel);
        int pixelY = anchorCoordinates.getPixelY(this.m_plotPanel);
        int xBox = pixelX + this.m_labelCoordinates.getPixelX(this.m_plotPanel);
        int yBox = pixelY + this.m_labelCoordinates.getPixelY(this.m_plotPanel);
        return x >= xBox && x <= xBox + this.m_widthBox && y >= yBox && y <= yBox + this.m_heightBox;
    }

    @Override
    public void moveDXY(int deltaX, int deltaY) {
        this.m_labelCoordinates.setPixelPosition(this.m_plotPanel, this.m_labelCoordinates.getPixelX(this.m_plotPanel) + deltaX, this.m_labelCoordinates.getPixelY(this.m_plotPanel) + deltaY);
    }

    @Override
    public boolean isMoveable() {
        return true;
    }

    @Override
    public void snapToData(boolean isCtrlOrShiftDown) {
    }

    @Override
    public void setSelected(boolean s, boolean isCtrlOrShiftDown) {
    }

    @Override
    public AbstractMarker clone(BasePlotPanel plotPanel) throws CloneNotSupportedException {
        LabelMarker clone = (LabelMarker)super.clone(plotPanel);
        clone.m_anchorMarker = (PointMarker)this.m_anchorMarker.clone(plotPanel);
        return clone;
    }
}

