/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.db.model.params;

import fr.profi.mzdb.db.model.params.AbstractXMLParamTree;
import fr.profi.mzdb.db.model.params.ScanParamTree;
import fr.profi.mzdb.serialization.SerializationInterface;
import fr.profi.mzdb.serialization.SerializationReader;
import fr.profi.mzdb.serialization.SerializationWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;

@XmlRootElement(name="scanList")
public class ScanList
extends AbstractXMLParamTree {
    @XmlAttribute(required=true)
    @XmlSchemaType(name="nonNegativeInteger")
    protected int count;
    @XmlElement(name="scan")
    protected List<ScanParamTree> scans;

    public ScanList() {
    }

    public ScanList(SerializationReader reader) throws IOException {
        this.read(reader);
    }

    public ScanList(int c) {
        this.count = c;
    }

    public List<ScanParamTree> getScans() {
        return this.scans;
    }

    @Override
    public void write(SerializationWriter writer) throws IOException {
        super.write(writer);
        writer.writeInt32(this.count);
        boolean hasData = this.scans != null;
        writer.writeBoolean(hasData);
        if (hasData) {
            writer.writeInt32(this.scans.size());
            for (SerializationInterface serializationInterface : this.scans) {
                serializationInterface.write(writer);
            }
        }
    }

    @Override
    public void read(SerializationReader reader) throws IOException {
        super.read(reader);
        this.count = reader.readInt32();
        boolean hasData = reader.readBoolean();
        if (hasData) {
            int size = reader.readInt32();
            this.scans = new ArrayList<ScanParamTree>(size);
            for (int i = 0; i < size; ++i) {
                ScanParamTree element = new ScanParamTree(reader);
                this.scans.add(element);
            }
        } else {
            this.scans = null;
        }
    }
}

