/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.io.writer;

import fr.profi.mzdb.model.SpectrumHeader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import org.apache.commons.lang3.StringUtils;

public class MsSpectrumTSVWriter {
    public static void writeRun(SpectrumHeader[] spectra, Integer runId, File outFile) {
        PrintWriter out = null;
        try {
            out = new PrintWriter(new FileOutputStream(outFile));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        Object[] colnames = new String[]{"id", "initial_id", "cycle", "time", "ms_level", "tic", "base_peak_moz", "base_peak_intensity", "precursor_moz", "precursor_charge", "serialized_properties", "run_id"};
        out.print(StringUtils.join((Object[])colnames, (String)"\t") + "\n");
        for (SpectrumHeader spectrum : spectra) {
            out.print(MsSpectrumTSVWriter.spectrum2String(spectrum, runId));
        }
        out.close();
    }

    private static String spectrum2String(SpectrumHeader spectrum, Integer runId) {
        Object[] spectrumValues = new String[]{String.valueOf(spectrum.getId()), String.valueOf(spectrum.getInitialId()), String.valueOf(spectrum.getCycle()), String.valueOf(spectrum.getTime()), String.valueOf(spectrum.getMsLevel()), String.valueOf(spectrum.getTIC()), String.valueOf(spectrum.getBasePeakMz()), String.valueOf(spectrum.getBasePeakIntensity()), String.valueOf(spectrum.getPrecursorMz()), String.valueOf(spectrum.getPrecursorCharge()), "", String.valueOf(runId)};
        return StringUtils.join((Object[])spectrumValues, (String)"\t") + "\n";
    }
}

