/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import org.ojalgo.OjAlgoUtils;
import org.ojalgo.array.DenseArray;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.function.special.PowerOf2;
import org.ojalgo.type.math.MathType;

final class GrowthStrategy {
    private final long myChunk;
    private final long myInitial;
    private final long mySegment;

    static Builder newBuilder(DenseArray.Factory<?> denseFactory) {
        return new Builder(denseFactory);
    }

    static GrowthStrategy newInstance(DenseArray.Factory<?> denseFactory) {
        return new Builder(denseFactory).build();
    }

    GrowthStrategy(Builder builder) {
        this.myInitial = builder.initial();
        this.myChunk = builder.chunk();
        this.mySegment = builder.segment();
    }

    long chunk() {
        return this.myChunk;
    }

    int grow(int current) {
        return Math.toIntExact(this.grow((long)current));
    }

    long grow(long current) {
        long retVal;
        long required = current + 1L;
        if (required >= this.myChunk) {
            for (retVal = this.myChunk; retVal < required; retVal += this.myChunk) {
            }
        } else {
            long maybe = retVal;
            while ((maybe = Math.round((double)retVal / PrimitiveMath.GOLDEN_RATIO)) >= required) {
                retVal = maybe;
            }
        }
        return retVal;
    }

    int initial() {
        return (int)this.myInitial;
    }

    boolean isChunked(long count) {
        return count > this.myChunk;
    }

    boolean isSegmented(long count) {
        return count > this.mySegment;
    }

    <N extends Comparable<N>> DenseArray<N> makeChunk(DenseArray.Factory<N> denseFactory) {
        return (DenseArray)denseFactory.make(this.myChunk);
    }

    <N extends Comparable<N>> DenseArray<N> makeInitial(DenseArray.Factory<N> denseFactory) {
        return (DenseArray)denseFactory.make(this.myInitial);
    }

    <N extends Comparable<N>> DenseArray<N> makeSegment(DenseArray.Factory<N> denseFactory) {
        return (DenseArray)denseFactory.make(this.mySegment);
    }

    long segment() {
        return this.mySegment;
    }

    static final class Builder {
        private static final long CHUNK = 4096L / MathType.R064.getTotalMemory();
        private static final long INITIAL = 4L;
        private static final long SEGMENT = 32768L;
        private long myChunk = CHUNK;
        private long myInitial = 4L;
        private long mySegment = 32768L;

        Builder(DenseArray.Factory<?> denseFactory) {
            this(denseFactory.getElementSize());
        }

        Builder(long elementSize) {
            long halfTopLevelCacheElements = OjAlgoUtils.ENVIRONMENT.cache / 2L / elementSize;
            this.segment(halfTopLevelCacheElements);
            long memoryPageElements = 4096L / elementSize;
            this.chunk(memoryPageElements);
        }

        GrowthStrategy build() {
            return new GrowthStrategy(this);
        }

        long chunk() {
            return this.myChunk;
        }

        Builder chunk(long chunk) {
            long notLargerThanCurrentSegment = Math.min(chunk, this.mySegment);
            int power = PowerOf2.powerOf2Smaller(notLargerThanCurrentSegment);
            this.myChunk = 1L << power;
            return this;
        }

        int initial() {
            return (int)this.myInitial;
        }

        Builder initial(long initial) {
            this.myInitial = Math.max(1L, initial);
            return this;
        }

        long segment() {
            return this.mySegment;
        }

        Builder segment(long segment) {
            long notSmallerThanCurrentChunk = Math.max(this.myChunk, segment);
            int power = PowerOf2.powerOf2Smaller(notSmallerThanCurrentChunk);
            this.mySegment = 1L << power;
            return this;
        }
    }
}

