/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.data.domain.finance.series;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Set;
import org.ojalgo.type.NumberDefinition;
import org.ojalgo.type.PrimitiveNumber;
import org.ojalgo.type.keyvalue.EntryPair;

public abstract class DatePrice
implements EntryPair.KeyedPrimitive<LocalDate> {
    public final LocalDate date;

    public static DatePrice of(CharSequence date, CharSequence price) {
        return new DefaultDP(date, Double.parseDouble(price.toString()));
    }

    public static DatePrice of(CharSequence date, DateTimeFormatter formatter, CharSequence price) {
        return new DefaultDP(date, formatter, Double.parseDouble(price.toString()));
    }

    public static DatePrice of(CharSequence date, DateTimeFormatter formatter, double price) {
        return new DefaultDP(date, formatter, price);
    }

    public static DatePrice of(CharSequence date, double price) {
        return new DefaultDP(date, price);
    }

    public static DatePrice of(LocalDate date, CharSequence price) {
        return new DefaultDP(date, Double.parseDouble(price.toString()));
    }

    public static DatePrice of(LocalDate date, double price) {
        return new DefaultDP(date, price);
    }

    protected DatePrice(CharSequence text) {
        this.date = LocalDate.parse(text);
    }

    protected DatePrice(CharSequence text, DateTimeFormatter formatter) {
        this.date = LocalDate.parse(text, formatter);
    }

    protected DatePrice(LocalDate key) {
        this.date = key;
    }

    @Override
    public int compareTo(PrimitiveNumber reference) {
        int retVal = 0;
        if (reference instanceof DatePrice) {
            retVal = this.date.compareTo(((DatePrice)reference).date);
        }
        if (retVal == 0) {
            retVal = Double.compare(this.getPrice(), reference.doubleValue());
        }
        return retVal;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.date.equals(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (value instanceof Comparable) {
            return NumberDefinition.doubleValue((Comparable)value) == this.getPrice();
        }
        return false;
    }

    @Override
    public final double doubleValue() {
        return this.getPrice();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DatePrice)) {
            return false;
        }
        DatePrice other = (DatePrice)obj;
        return !(this.date == null ? other.date != null : !this.date.equals(other.date));
    }

    @Override
    public PrimitiveNumber get(Object key) {
        if (this.date.equals(key)) {
            return this;
        }
        return null;
    }

    @Override
    public final LocalDate getKey() {
        return this.date;
    }

    public abstract double getPrice();

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        return 31 * result + (this.date == null ? 0 : this.date.hashCode());
    }

    @Override
    public Set<LocalDate> keySet() {
        return Collections.singleton(this.date);
    }

    public final String toString() {
        return this.getKey() + ": " + this.getPrice();
    }

    static final class DefaultDP
    extends DatePrice {
        private final double myPrice;

        DefaultDP(CharSequence text, DateTimeFormatter formatter, double price) {
            super(text, formatter);
            this.myPrice = price;
        }

        DefaultDP(CharSequence text, double price) {
            super(text);
            this.myPrice = price;
        }

        DefaultDP(LocalDate key, double price) {
            super(key);
            this.myPrice = price;
        }

        @Override
        public double getPrice() {
            return this.myPrice;
        }
    }
}

