/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function.aggregator;

import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.function.aggregator.AggregatorSet;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.function.constant.RationalMath;
import org.ojalgo.scalar.PrimitiveScalar;
import org.ojalgo.scalar.RationalNumber;
import org.ojalgo.scalar.Scalar;

public final class RationalAggregator
extends AggregatorSet<RationalNumber> {
    private static final ThreadLocal<AggregatorFunction<RationalNumber>> AVERAGE = new ThreadLocal<AggregatorFunction<RationalNumber>>(){

        @Override
        protected AggregatorFunction<RationalNumber> initialValue() {
            return new RationalAggregatorFunction(){
                private int myCount = 0;
                private RationalNumber myNumber = RationalNumber.ZERO;

                @Override
                public RationalNumber get() {
                    return (RationalNumber)this.myNumber.divide(this.myCount);
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(RationalNumber anArg) {
                    ++this.myCount;
                    this.myNumber = this.myNumber.add(anArg);
                }

                @Override
                public AggregatorFunction<RationalNumber> reset() {
                    this.myCount = 0;
                    this.myNumber = RationalNumber.ZERO;
                    return this;
                }
            };
        }
    };
    private static final ThreadLocal<AggregatorFunction<RationalNumber>> CARDINALITY = new ThreadLocal<AggregatorFunction<RationalNumber>>(){

        @Override
        protected AggregatorFunction<RationalNumber> initialValue() {
            return new RationalAggregatorFunction(){
                private int myCount = 0;

                @Override
                public RationalNumber get() {
                    return RationalNumber.valueOf(this.myCount);
                }

                @Override
                public int intValue() {
                    return this.myCount;
                }

                @Override
                public void invoke(RationalNumber anArg) {
                    if (!PrimitiveScalar.isSmall(PrimitiveMath.ONE, PrimitiveMath.ABS.invoke(anArg.doubleValue()))) {
                        ++this.myCount;
                    }
                }

                @Override
                public AggregatorFunction<RationalNumber> reset() {
                    this.myCount = 0;
                    return this;
                }
            };
        }
    };
    private static final ThreadLocal<AggregatorFunction<RationalNumber>> LARGEST = new ThreadLocal<AggregatorFunction<RationalNumber>>(){

        @Override
        protected AggregatorFunction<RationalNumber> initialValue() {
            return new RationalAggregatorFunction(){
                private RationalNumber myNumber = RationalNumber.ZERO;

                @Override
                public RationalNumber get() {
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(RationalNumber anArg) {
                    this.myNumber = RationalMath.MAX.invoke(this.myNumber, RationalMath.ABS.invoke(anArg));
                }

                @Override
                public AggregatorFunction<RationalNumber> reset() {
                    this.myNumber = RationalNumber.ZERO;
                    return this;
                }
            };
        }
    };
    private static final ThreadLocal<AggregatorFunction<RationalNumber>> MAX = new ThreadLocal<AggregatorFunction<RationalNumber>>(){

        @Override
        protected AggregatorFunction<RationalNumber> initialValue() {
            return new RationalAggregatorFunction(){
                private RationalNumber myNumber = RationalNumber.NEGATIVE_INFINITY;

                @Override
                public RationalNumber get() {
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(RationalNumber anArg) {
                    this.myNumber = RationalMath.MAX.invoke(this.myNumber, anArg);
                }

                @Override
                public AggregatorFunction<RationalNumber> reset() {
                    this.myNumber = RationalNumber.NEGATIVE_INFINITY;
                    return this;
                }
            };
        }
    };
    private static final ThreadLocal<AggregatorFunction<RationalNumber>> MIN = new ThreadLocal<AggregatorFunction<RationalNumber>>(){

        @Override
        protected AggregatorFunction<RationalNumber> initialValue() {
            return new RationalAggregatorFunction(){
                private RationalNumber myNumber = RationalNumber.POSITIVE_INFINITY;

                @Override
                public RationalNumber get() {
                    if (RationalNumber.isInfinite(this.myNumber)) {
                        return RationalNumber.ZERO;
                    }
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(RationalNumber anArg) {
                    this.myNumber = RationalMath.MIN.invoke(this.myNumber, anArg);
                }

                @Override
                public AggregatorFunction<RationalNumber> reset() {
                    this.myNumber = RationalNumber.POSITIVE_INFINITY;
                    return this;
                }
            };
        }
    };
    private static final ThreadLocal<AggregatorFunction<RationalNumber>> NORM1 = new ThreadLocal<AggregatorFunction<RationalNumber>>(){

        @Override
        protected AggregatorFunction<RationalNumber> initialValue() {
            return new RationalAggregatorFunction(){
                private RationalNumber myNumber = RationalNumber.ZERO;

                @Override
                public RationalNumber get() {
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(RationalNumber anArg) {
                    this.myNumber = this.myNumber.add(PrimitiveMath.ABS.invoke(anArg.doubleValue()));
                }

                @Override
                public AggregatorFunction<RationalNumber> reset() {
                    this.myNumber = RationalNumber.ZERO;
                    return this;
                }
            };
        }
    };
    private static final ThreadLocal<AggregatorFunction<RationalNumber>> NORM2 = new ThreadLocal<AggregatorFunction<RationalNumber>>(){

        @Override
        protected AggregatorFunction<RationalNumber> initialValue() {
            return new RationalAggregatorFunction(){
                private RationalNumber myNumber = RationalNumber.ZERO;

                @Override
                public RationalNumber get() {
                    return RationalNumber.valueOf(PrimitiveMath.SQRT.invoke(PrimitiveMath.ABS.invoke(this.myNumber.doubleValue())));
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(RationalNumber anArg) {
                    double tmpMod = PrimitiveMath.ABS.invoke(anArg.doubleValue());
                    this.myNumber = this.myNumber.add(tmpMod * tmpMod);
                }

                @Override
                public AggregatorFunction<RationalNumber> reset() {
                    this.myNumber = RationalNumber.ZERO;
                    return this;
                }
            };
        }
    };
    private static final ThreadLocal<AggregatorFunction<RationalNumber>> PRODUCT = new ThreadLocal<AggregatorFunction<RationalNumber>>(){

        @Override
        protected AggregatorFunction<RationalNumber> initialValue() {
            return new RationalAggregatorFunction(){
                private RationalNumber myNumber = RationalNumber.ONE;

                @Override
                public RationalNumber get() {
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(RationalNumber anArg) {
                    this.myNumber = this.myNumber.multiply(anArg);
                }

                @Override
                public AggregatorFunction<RationalNumber> reset() {
                    this.myNumber = RationalNumber.ONE;
                    return this;
                }
            };
        }
    };
    private static final ThreadLocal<AggregatorFunction<RationalNumber>> PRODUCT2 = new ThreadLocal<AggregatorFunction<RationalNumber>>(){

        @Override
        protected AggregatorFunction<RationalNumber> initialValue() {
            return new RationalAggregatorFunction(){
                private RationalNumber myNumber = RationalNumber.ONE;

                @Override
                public RationalNumber get() {
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(RationalNumber anArg) {
                    this.myNumber = this.myNumber.multiply(anArg.multiply(anArg));
                }

                @Override
                public AggregatorFunction<RationalNumber> reset() {
                    this.myNumber = RationalNumber.ONE;
                    return this;
                }
            };
        }
    };
    private static final RationalAggregator SET = new RationalAggregator();
    private static final ThreadLocal<AggregatorFunction<RationalNumber>> SMALLEST = new ThreadLocal<AggregatorFunction<RationalNumber>>(){

        @Override
        protected AggregatorFunction<RationalNumber> initialValue() {
            return new RationalAggregatorFunction(){
                private RationalNumber myNumber = RationalNumber.POSITIVE_INFINITY;

                @Override
                public RationalNumber get() {
                    if (RationalNumber.isInfinite(this.myNumber)) {
                        return RationalNumber.ZERO;
                    }
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(RationalNumber anArg) {
                    if (!RationalNumber.isSmall(PrimitiveMath.ONE, anArg)) {
                        this.myNumber = RationalMath.MIN.invoke(this.myNumber, RationalMath.ABS.invoke(anArg));
                    }
                }

                @Override
                public AggregatorFunction<RationalNumber> reset() {
                    this.myNumber = RationalNumber.POSITIVE_INFINITY;
                    return this;
                }
            };
        }
    };
    private static final ThreadLocal<AggregatorFunction<RationalNumber>> SUM = new ThreadLocal<AggregatorFunction<RationalNumber>>(){

        @Override
        protected AggregatorFunction<RationalNumber> initialValue() {
            return new RationalAggregatorFunction(){
                private RationalNumber myNumber = RationalNumber.ZERO;

                @Override
                public RationalNumber get() {
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(RationalNumber anArg) {
                    this.myNumber = this.myNumber.add(anArg);
                }

                @Override
                public AggregatorFunction<RationalNumber> reset() {
                    this.myNumber = RationalNumber.ZERO;
                    return this;
                }
            };
        }
    };
    private static final ThreadLocal<AggregatorFunction<RationalNumber>> SUM2 = new ThreadLocal<AggregatorFunction<RationalNumber>>(){

        @Override
        protected AggregatorFunction<RationalNumber> initialValue() {
            return new RationalAggregatorFunction(){
                private RationalNumber myNumber = RationalNumber.ZERO;

                @Override
                public RationalNumber get() {
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(RationalNumber anArg) {
                    this.myNumber = this.myNumber.add(anArg.multiply(anArg));
                }

                @Override
                public AggregatorFunction<RationalNumber> reset() {
                    this.myNumber = RationalNumber.ZERO;
                    return this;
                }
            };
        }
    };

    public static RationalAggregator getSet() {
        return SET;
    }

    private RationalAggregator() {
    }

    @Override
    public AggregatorFunction<RationalNumber> average() {
        return AVERAGE.get().reset();
    }

    @Override
    public AggregatorFunction<RationalNumber> cardinality() {
        return CARDINALITY.get().reset();
    }

    @Override
    public AggregatorFunction<RationalNumber> largest() {
        return LARGEST.get().reset();
    }

    @Override
    public AggregatorFunction<RationalNumber> maximum() {
        return MAX.get().reset();
    }

    @Override
    public AggregatorFunction<RationalNumber> minimum() {
        return MIN.get().reset();
    }

    @Override
    public AggregatorFunction<RationalNumber> norm1() {
        return NORM1.get().reset();
    }

    @Override
    public AggregatorFunction<RationalNumber> norm2() {
        return NORM2.get().reset();
    }

    @Override
    public AggregatorFunction<RationalNumber> product() {
        return PRODUCT.get().reset();
    }

    @Override
    public AggregatorFunction<RationalNumber> product2() {
        return PRODUCT2.get().reset();
    }

    @Override
    public AggregatorFunction<RationalNumber> smallest() {
        return SMALLEST.get().reset();
    }

    @Override
    public AggregatorFunction<RationalNumber> sum() {
        return SUM.get().reset();
    }

    @Override
    public AggregatorFunction<RationalNumber> sum2() {
        return SUM2.get().reset();
    }

    static abstract class RationalAggregatorFunction
    implements AggregatorFunction<RationalNumber> {
        RationalAggregatorFunction() {
        }

        @Override
        public final double doubleValue() {
            return ((RationalNumber)this.get()).doubleValue();
        }

        @Override
        public final void invoke(double anArg) {
            this.invoke(RationalNumber.valueOf(anArg));
        }

        @Override
        public final void invoke(float anArg) {
            this.invoke(RationalNumber.valueOf(anArg));
        }

        @Override
        public final Scalar<RationalNumber> toScalar() {
            return (Scalar)this.get();
        }
    }
}

