/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function.polynomial;

import org.ojalgo.array.Array1D;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.function.polynomial.AbstractPolynomial;
import org.ojalgo.function.polynomial.PolynomialFunction;
import org.ojalgo.matrix.decomposition.QR;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.structure.Access1D;

public class PolynomialR064
extends AbstractPolynomial<Double> {
    public PolynomialR064(int degree) {
        super((Array1D)Array1D.R064.make(degree + 1));
    }

    PolynomialR064(Array1D<Double> coefficients) {
        super(coefficients);
    }

    @Override
    public void estimate(Access1D<?> x, Access1D<?> y) {
        this.estimate(x, y, Primitive64Store.FACTORY, QR.R064);
    }

    @Override
    public Double integrate(Double fromPoint, Double toPoint) {
        PolynomialFunction primitive = this.buildPrimitive();
        double fromVal = primitive.invoke(fromPoint);
        double toVal = primitive.invoke(toPoint);
        return toVal - fromVal;
    }

    @Override
    public Double invoke(Double arg) {
        return this.invoke((double)arg);
    }

    @Override
    public void set(Access1D<?> coefficients) {
        int limit = Math.min(this.size(), coefficients.size());
        for (int p = 0; p < limit; ++p) {
            this.set(p, coefficients.doubleValue(p));
        }
    }

    @Override
    protected Double getDerivativeFactor(int power) {
        int nextIndex = power + 1;
        return (double)nextIndex * this.doubleValue(nextIndex);
    }

    @Override
    protected Double getPrimitiveFactor(int power) {
        if (power <= 0) {
            return PrimitiveMath.ZERO;
        }
        return this.doubleValue(power - 1) / (double)power;
    }

    @Override
    protected AbstractPolynomial<Double> makeInstance(int size) {
        return new PolynomialR064((Array1D)Array1D.R064.make(size));
    }
}

