/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.machine;

import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import org.ojalgo.array.operation.COPY;
import org.ojalgo.machine.BasicMachine;
import org.ojalgo.machine.CommonMachine;
import org.ojalgo.machine.VirtualMachine;

public final class Hardware
extends CommonMachine
implements Comparable<Hardware> {
    public static final long CPU_CACHE_LINE_SIZE = 64L;
    public static final long OS_MEMORY_PAGE_SIZE = 4096L;
    public static final Set<Hardware> PREDEFINED = new TreeSet<Hardware>();
    static final Hardware AARCH64__08 = new Hardware("aarch64", new BasicMachine[]{new BasicMachine(0x400000000L, 8), new BasicMachine(0xC00000L, 4), new BasicMachine(131072L, 1)});
    static final Hardware PPC__01 = new Hardware("ppc", new BasicMachine[]{new BasicMachine(0x50000000L, 1), new BasicMachine(524288L, 1), new BasicMachine(65536L, 1)});
    static final Hardware X86__01 = new Hardware("x86", new BasicMachine[]{new BasicMachine(0x40000000L, 1), new BasicMachine(0x100000L, 1), new BasicMachine(32768L, 1)});
    static final Hardware X86__02 = new Hardware("x86", new BasicMachine[]{new BasicMachine(0xE0000000L, 2), new BasicMachine(0x600000L, 2), new BasicMachine(32768L, 1)});
    static final Hardware X86_64__02 = new Hardware("x86_64", new BasicMachine[]{new BasicMachine(0xC0000000L, 2), new BasicMachine(0x400000L, 2), new BasicMachine(32768L, 1)});
    static final Hardware X86_64__04 = new Hardware("x86_64", new BasicMachine[]{new BasicMachine(0x800000000L, 4), new BasicMachine(0x300000L, 4), new BasicMachine(262144L, 2), new BasicMachine(32768L, 2)});
    static final Hardware X86_64__04_1_L2 = new Hardware("x86_64", new BasicMachine[]{new BasicMachine(0x200000000L, 4), new BasicMachine(0x300000L, 2), new BasicMachine(32768L, 1)});
    static final Hardware X86_64__04_1_L3 = new Hardware("x86_64", new BasicMachine[]{new BasicMachine(0x800000000L, 4), new BasicMachine(0x600000L, 4), new BasicMachine(262144L, 1), new BasicMachine(32768L, 1)});
    static final Hardware X86_64__04_2 = new Hardware("x86_64", new BasicMachine[]{new BasicMachine(0x200000000L, 4), new BasicMachine(0x300000L, 4), new BasicMachine(262144L, 2), new BasicMachine(32768L, 2)});
    static final Hardware X86_64__08 = new Hardware("x86_64", new BasicMachine[]{new BasicMachine(0x800000000L, 8), new BasicMachine(0x800000L, 8), new BasicMachine(262144L, 2), new BasicMachine(32768L, 2)});
    static final Hardware X86_64__12 = new Hardware("x86_64", new BasicMachine[]{new BasicMachine(0x300000000L, 12), new BasicMachine(0xC00000L, 12), new BasicMachine(262144L, 2), new BasicMachine(32768L, 2)});
    static final Hardware X86_64__16 = new Hardware("x86_64", new BasicMachine[]{new BasicMachine(0x1000000000L, 16), new BasicMachine(0x800000L, 16), new BasicMachine(262144L, 2), new BasicMachine(32768L, 2)});
    static final Hardware X86_64__64 = new Hardware("x86_64", new BasicMachine[]{new BasicMachine(0x8000000000L, 64), new BasicMachine(0x1400000L, 32), new BasicMachine(262144L, 2), new BasicMachine(32768L, 2)});
    static final Hardware X86_64__96 = new Hardware("x86_64", new BasicMachine[]{new BasicMachine(0x8000000000L, 96), new BasicMachine(0x1E00000L, 24), new BasicMachine(262144L, 2), new BasicMachine(32768L, 2)});
    private final BasicMachine[] myLevels;

    public static Hardware makeSimple() {
        return Hardware.makeSimple(VirtualMachine.getArchitecture(), VirtualMachine.getMemory(), VirtualMachine.getThreads());
    }

    public static Hardware makeSimple(String systemArchitecture, long systemMemory, int systemThreads) {
        if (systemThreads > 8) {
            BasicMachine tmpL1Machine = new BasicMachine(32768L, 2);
            BasicMachine tmpL2Machine = new BasicMachine(262144L, tmpL1Machine.threads);
            BasicMachine tmpL3Machine = new BasicMachine(0x400000L, systemThreads / ((systemThreads + 7) / 8));
            BasicMachine tmpSystemMachine = new BasicMachine(systemMemory, systemThreads);
            return new Hardware(systemArchitecture, new BasicMachine[]{tmpSystemMachine, tmpL3Machine, tmpL2Machine, tmpL1Machine});
        }
        if (systemThreads >= 4) {
            BasicMachine tmpL1Machine = new BasicMachine(32768L, 2);
            BasicMachine tmpL2Machine = new BasicMachine(262144L, tmpL1Machine.threads);
            BasicMachine tmpL3Machine = new BasicMachine(0x300000L, systemThreads);
            BasicMachine tmpSystemMachine = new BasicMachine(systemMemory, systemThreads);
            return new Hardware(systemArchitecture, new BasicMachine[]{tmpSystemMachine, tmpL3Machine, tmpL2Machine, tmpL1Machine});
        }
        BasicMachine tmpL1Machine = new BasicMachine(32768L, 1);
        BasicMachine tmpL2Machine = new BasicMachine(0x200000L, tmpL1Machine.threads);
        BasicMachine tmpSystemMachine = new BasicMachine(systemMemory, systemThreads);
        return new Hardware(systemArchitecture, new BasicMachine[]{tmpSystemMachine, tmpL2Machine, tmpL1Machine});
    }

    public Hardware(String arch, BasicMachine[] levels) {
        super(arch, levels);
        if (levels.length < 2) {
            throw new IllegalArgumentException();
        }
        this.myLevels = COPY.copyOf(levels);
    }

    @Override
    public int compareTo(Hardware other) {
        if (this.cores != other.cores) {
            return this.cores - other.cores;
        }
        if (this.threads != other.threads) {
            return this.threads - other.threads;
        }
        if (this.cache != other.cache) {
            return (int)(this.cache - other.cache);
        }
        if (this.units != other.units) {
            return this.units - other.units;
        }
        if (this.memory != other.memory) {
            return (int)(this.memory - other.memory);
        }
        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj) || !(obj instanceof Hardware)) {
            return false;
        }
        Hardware other = (Hardware)obj;
        return Arrays.equals(this.myLevels, other.myLevels);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        return 31 * result + Arrays.hashCode(this.myLevels);
    }

    public boolean isL2Specified() {
        return this.myLevels.length > 2;
    }

    public boolean isL3Specified() {
        return this.myLevels.length > 3;
    }

    @Override
    public String toString() {
        StringBuilder retVal = new StringBuilder("HW=");
        retVal.append(this.myLevels[0].toString());
        if (this.isL3Specified()) {
            retVal.append(',').append(this.units).append("xL3:").append(this.myLevels[this.myLevels.length - 3]);
        } else if (this.isL2Specified()) {
            retVal.append(',').append(this.units).append("xL2:").append(this.myLevels[this.myLevels.length - 2]);
        }
        retVal.append(',').append(this.cores).append("cores:").append(this.myLevels[this.myLevels.length - 1]);
        return retVal.toString();
    }

    public VirtualMachine virtualise() {
        return new VirtualMachine(this, Runtime.getRuntime());
    }

    static {
        PREDEFINED.add(AARCH64__08);
        PREDEFINED.add(PPC__01);
        PREDEFINED.add(X86__01);
        PREDEFINED.add(X86__02);
        PREDEFINED.add(X86_64__02);
        PREDEFINED.add(X86_64__04);
        PREDEFINED.add(X86_64__08);
        PREDEFINED.add(X86_64__12);
        PREDEFINED.add(X86_64__16);
        PREDEFINED.add(X86_64__64);
        PREDEFINED.add(X86_64__96);
    }
}

