/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import java.util.ArrayList;
import java.util.List;
import org.ojalgo.array.SparseArray;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.TransformableRegion;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.ElementView1D;
import org.ojalgo.structure.Mutate2D;

public final class RowsSupplier<N extends Comparable<N>>
implements MatrixStore<N>,
Mutate2D {
    private final int myColumnsCount;
    private final PhysicalStore.Factory<N, ?> myPhysicalStoreFactory;
    private final SparseArray.SparseFactory<N> myRowFactory;
    private final List<SparseArray<N>> myRows = new ArrayList<SparseArray<N>>();

    RowsSupplier(PhysicalStore.Factory<N, ?> factory, int numberOfColumns) {
        this.myColumnsCount = numberOfColumns;
        this.myPhysicalStoreFactory = factory;
        this.myRowFactory = (SparseArray.SparseFactory)SparseArray.factory(factory.array()).limit(this.myColumnsCount);
    }

    public SparseArray<N> addRow() {
        return this.addRow(this.myRowFactory.make());
    }

    public void addRows(int numberToAdd) {
        for (int i = 0; i < numberToAdd; ++i) {
            this.myRows.add(this.myRowFactory.make());
        }
    }

    @Override
    public long countColumns() {
        return this.myColumnsCount;
    }

    @Override
    public long countRows() {
        return this.myRows.size();
    }

    @Override
    public double doubleValue(long row, long col) {
        return this.myRows.get((int)row).doubleValue(col);
    }

    @Override
    public PhysicalStore<N> get() {
        return (PhysicalStore)this.collect(this.myPhysicalStoreFactory);
    }

    @Override
    public N get(long row, long col) {
        return this.myRows.get((int)row).get(col);
    }

    public SparseArray<N> getRow(int index) {
        return this.myRows.get(index);
    }

    @Override
    public PhysicalStore.Factory<N, ?> physical() {
        return this.myPhysicalStoreFactory;
    }

    public SparseArray<N> removeRow(int index) {
        return this.myRows.remove(index);
    }

    @Override
    public Access2D.RowView<N> rows() {
        return new SingleView(this);
    }

    @Override
    public MatrixStore<N> rows(final int ... rows) {
        return new MatrixStore<N>(){

            @Override
            public long countColumns() {
                return RowsSupplier.this.countColumns();
            }

            @Override
            public long countRows() {
                return rows.length;
            }

            @Override
            public double doubleValue(long row, long col) {
                return RowsSupplier.this.doubleValue(rows[(int)row], col);
            }

            @Override
            public N get(long row, long col) {
                return RowsSupplier.this.get(rows[(int)row], col);
            }

            @Override
            public PhysicalStore.Factory<N, ?> physical() {
                return RowsSupplier.this.physical();
            }

            @Override
            public void supplyTo(TransformableRegion<N> receiver) {
                receiver.reset();
                for (int i = 0; i < rows.length; ++i) {
                    SparseArray row = RowsSupplier.this.getRow(rows[i]);
                    for (SparseArray.NonzeroView nz : row.nonzeros()) {
                        receiver.set(nz.index(), (long)i, (Comparable<?>)nz.get());
                    }
                }
            }

            public String toString() {
                return Access2D.toString(this);
            }
        };
    }

    public RowsSupplier<N> selectRows(int[] indices) {
        RowsSupplier<N> retVal = new RowsSupplier<N>(this.myPhysicalStoreFactory, this.myColumnsCount);
        for (int i = 0; i < indices.length; ++i) {
            retVal.addRow(this.getRow(indices[i]));
        }
        return retVal;
    }

    @Override
    public void set(long row, long col, Comparable<?> value) {
        this.myRows.get((int)row).set(col, value);
    }

    @Override
    public void set(long row, long col, double value) {
        this.myRows.get((int)row).set(col, value);
    }

    @Override
    public void supplyTo(TransformableRegion<N> receiver) {
        receiver.reset();
        int limit = this.myRows.size();
        for (int i = 0; i < limit; ++i) {
            this.myRows.get(i).supplyNonZerosTo(receiver.regionByRows(i));
        }
    }

    public String toString() {
        return Access2D.toString(this);
    }

    SparseArray<N> addRow(SparseArray<N> rowToAdd) {
        if (this.myRows.add(rowToAdd)) {
            return rowToAdd;
        }
        return null;
    }

    public static final class SingleView<N extends Comparable<N>>
    extends Access2D.RowView<N>
    implements Access2D.Collectable<N, PhysicalStore<N>> {
        private final RowsSupplier<N> myBase;

        SingleView(RowsSupplier<N> base) {
            super(base);
            this.myBase = base;
        }

        @Override
        public long countColumns() {
            return this.myBase.countColumns();
        }

        @Override
        public long countRows() {
            return 1L;
        }

        @Override
        public ElementView1D<N, ?> elements() {
            return this.getCurrent().elements();
        }

        @Override
        public ElementView1D<N, ?> nonzeros() {
            return this.getCurrent().nonzeros();
        }

        @Override
        public void supplyTo(PhysicalStore<N> receiver) {
            receiver.reset();
            for (ElementView1D element : this.nonzeros()) {
                receiver.set(element.index(), element.doubleValue());
            }
        }

        private SparseArray<N> getCurrent() {
            return this.myBase.getRow(Math.toIntExact(this.row()));
        }
    }
}

