/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.netio;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import org.ojalgo.netio.InMemoryFile;
import org.ojalgo.netio.ToFileWriter;
import org.ojalgo.type.function.AutoConsumer;
import org.ojalgo.type.function.OperatorWithException;

public final class TextLineWriter
implements ToFileWriter<CharSequence> {
    private final BufferedWriter myWriter;

    public static TextLineWriter of(File file) {
        return new TextLineWriter(ToFileWriter.output(file));
    }

    public static TextLineWriter of(File file, OperatorWithException<OutputStream> filter) {
        return new TextLineWriter(filter.apply(ToFileWriter.output(file)));
    }

    public static TextLineWriter of(InMemoryFile file) {
        return new TextLineWriter(file.newOutputStream());
    }

    public static TextLineWriter of(InMemoryFile file, OperatorWithException<OutputStream> filter) {
        return new TextLineWriter(filter.apply(file.newOutputStream()));
    }

    public TextLineWriter(OutputStream outputStream) {
        try {
            this.myWriter = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
        }
        catch (UnsupportedEncodingException cause) {
            throw new RuntimeException(cause);
        }
    }

    @Override
    public void close() throws IOException {
        this.myWriter.close();
    }

    public CSVLineBuilder newCSVLineBuilder(char delimiter) {
        return new CSVLineBuilder(this, delimiter);
    }

    public CSVLineBuilder newCSVLineBuilder(String delimiter) {
        return new CSVLineBuilder(this, delimiter);
    }

    public <T> AutoConsumer<T> withFormatter(Formatter<T> formatter) {
        return AutoConsumer.mapped(formatter::format, this);
    }

    @Override
    public void write(CharSequence itemToWrite) {
        try {
            this.myWriter.write(itemToWrite.toString());
            this.myWriter.newLine();
        }
        catch (IOException cause) {
            throw new RuntimeException(cause);
        }
    }

    @FunctionalInterface
    public static interface Formatter<T> {
        public String format(T var1);
    }

    public static final class CSVLineBuilder {
        private final String myDelimiter;
        private final StringBuilder myTextLine = new StringBuilder();
        private final TextLineWriter myWriter;

        CSVLineBuilder(TextLineWriter writer, char delimiter) {
            this(writer, Character.toString(delimiter));
        }

        CSVLineBuilder(TextLineWriter writer, String delimiter) {
            this.myWriter = writer;
            this.myDelimiter = delimiter;
        }

        public CSVLineBuilder append(boolean colVal) {
            this.delimit();
            this.myTextLine.append(colVal);
            return this;
        }

        public CSVLineBuilder append(byte colVal) {
            this.delimit();
            this.myTextLine.append(Byte.toString(colVal));
            return this;
        }

        public CSVLineBuilder append(char colVal) {
            this.delimit();
            this.myTextLine.append(colVal);
            return this;
        }

        public CSVLineBuilder append(double colVal) {
            this.delimit();
            this.myTextLine.append(colVal);
            return this;
        }

        public CSVLineBuilder append(float colVal) {
            this.delimit();
            this.myTextLine.append(colVal);
            return this;
        }

        public CSVLineBuilder append(int colVal) {
            this.delimit();
            this.myTextLine.append(colVal);
            return this;
        }

        public CSVLineBuilder append(long colVal) {
            this.delimit();
            this.myTextLine.append(colVal);
            return this;
        }

        public CSVLineBuilder append(Object colVal) {
            this.delimit();
            this.myTextLine.append(colVal);
            return this;
        }

        public CSVLineBuilder append(short colVal) {
            this.delimit();
            this.myTextLine.append(Short.toString(colVal));
            return this;
        }

        private void delimit() {
            if (this.myTextLine.length() > 0) {
                this.myTextLine.append(this.myDelimiter);
            }
        }

        public void write() {
            this.myWriter.write(this.myTextLine);
            this.myTextLine.setLength(0);
        }
    }
}

