/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.convex;

import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.convex.BasePrimitiveSolver;
import org.ojalgo.optimisation.convex.ConvexData;

final class UnconstrainedSolver
extends BasePrimitiveSolver {
    UnconstrainedSolver(ConvexData<Double> convexSolverBuilder, Optimisation.Options optimisationOptions) {
        super(convexSolverBuilder, optimisationOptions);
    }

    protected MatrixStore<Double> getIterationKKT() {
        return this.getMatrixQ();
    }

    protected MatrixStore<Double> getIterationRHS() {
        return this.getMatrixC();
    }

    @Override
    protected boolean needsAnotherIteration() {
        return this.countIterations() < 1;
    }

    @Override
    protected void performIteration() {
        boolean solved = false;
        solved = this.isSolvableQ();
        if (solved) {
            this.getSolutionQ(this.getMatrixC(), this.getSolutionX());
        } else {
            solved = this.solveFullKKT(this.getSolutionX());
            if (solved) {
                // empty if block
            }
        }
        if (solved) {
            this.setState(Optimisation.State.DISTINCT);
        } else {
            this.setState(Optimisation.State.UNBOUNDED);
            this.getSolutionX().fillAll(PrimitiveMath.ZERO);
        }
        this.incrementIterationsCount();
    }
}

