/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.linear;

import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collection;
import org.ojalgo.array.Array1D;
import org.ojalgo.array.ArrayR064;
import org.ojalgo.array.LongToNumberMap;
import org.ojalgo.array.SparseArray;
import org.ojalgo.equation.Equation;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.linear.LinearSolver;
import org.ojalgo.optimisation.linear.LinearStructure;
import org.ojalgo.optimisation.linear.Primitive1D;
import org.ojalgo.optimisation.linear.SimplexTableau;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Structure1D;
import org.ojalgo.type.context.NumberContext;

abstract class SimplexTableauSolver
extends LinearSolver {
    private static final NumberContext ACC = NumberContext.of(12, 14).withMode(RoundingMode.HALF_DOWN);
    private static final NumberContext DEGENERATE = NumberContext.of(12, 8).withMode(RoundingMode.HALF_DOWN);
    private static final NumberContext PHASE1 = NumberContext.of(12, 7).withMode(RoundingMode.HALF_DOWN);
    private static final NumberContext PIVOT = NumberContext.of(12, 8).withMode(RoundingMode.HALF_DOWN);
    private static final NumberContext RATIO = NumberContext.of(12, 8).withMode(RoundingMode.HALF_DOWN);
    private static final NumberContext WEIGHT = NumberContext.of(8, 10).withMode(RoundingMode.HALF_DOWN);
    private LongToNumberMap<Double> myFixedVariables = null;
    private final IterationPoint myPoint;
    private final SimplexTableau myTableau;

    SimplexTableauSolver(SimplexTableau tableau, Optimisation.Options solverOptions) {
        super(solverOptions);
        this.myTableau = tableau;
        this.myPoint = new IterationPoint();
        if (this.isLogProgress()) {
            this.log("", new Object[0]);
            this.log("Created SimplexSolver", new Object[0]);
            this.log("countVariables: {}", tableau.countVariables());
            this.log("countProblemVariables: {}", tableau.countProblemVariables());
            this.log("countSlackVariables: {}", tableau.countSlackVariables());
            this.log("countArtificialVariables: {}", tableau.countArtificialVariables());
            this.log("countVariablesTotally: {}", tableau.countVariablesTotally());
            this.log("countConstraints: {}", tableau.countConstraints());
            this.log("countBasisDeficit: {}", tableau.countBasisDeficit());
        }
        if (this.isLogDebug() && this.isTableauPrintable()) {
            this.logDebugTableau("Tableau Created");
        }
    }

    @Override
    public boolean fixVariable(int index, double value) {
        if (value < PrimitiveMath.ZERO) {
            return false;
        }
        boolean retVal = this.myTableau.fixVariable(index, value);
        if (retVal) {
            if (this.myFixedVariables == null) {
                this.myFixedVariables = LongToNumberMap.factory(ArrayR064.FACTORY).make();
            }
            this.myFixedVariables.put((long)index, value);
            this.myPoint.returnToPhase1();
        }
        return retVal;
    }

    @Override
    public final Collection<Equation> generateCutCandidates(double fractionality, boolean ... integer) {
        return this.myTableau.generateCutCandidates(integer, this.options.integer().getIntegralityTolerance(), fractionality);
    }

    @Override
    public LinearStructure getEntityMap() {
        return this.myTableau.meta;
    }

    @Override
    public Optimisation.Result solve(Optimisation.Result kickStarter) {
        if (this.isLogDebug() && this.isTableauPrintable()) {
            this.logDebugTableau("Initial Tableau");
        }
        this.resetIterationsCount();
        while (this.isIterationAllowed() && this.needsAnotherIteration()) {
            this.performIteration(this.myPoint);
            this.incrementIterationsCount();
            if (!this.isLogDebug() || !this.isTableauPrintable()) continue;
            this.logDebugTableau("Tableau Iteration");
        }
        if (this.isLogDebug() && this.isTableauPrintable()) {
            this.logDebugTableau("Final Tableau");
        }
        return this.buildResult();
    }

    private void cleanUpPhase1Artificials() {
        int[] basis = this.myTableau.getBasis();
        int[] excluded = this.myTableau.getExcluded();
        int colRHS = this.myTableau.countVariablesTotally();
        for (int i = 0; i < basis.length; ++i) {
            if (basis[i] >= 0) continue;
            double rhs = this.myTableau.doubleValue(i, colRHS);
            if (this.options.validate && !PHASE1.isZero(rhs)) {
                this.log("Non-zero RHS artificial variable: {} = {}", i, rhs);
            }
            int enter = -1;
            double maxPivot = PrimitiveMath.ZERO;
            for (int j = 0; j < excluded.length; ++j) {
                int posEnt = excluded[j];
                double pivot = this.myTableau.doubleValue(i, posEnt);
                if (!(pivot > maxPivot) || PIVOT.isZero(pivot)) continue;
                maxPivot = pivot;
                enter = posEnt;
            }
            if (enter < 0) continue;
            this.myPoint.row = i;
            this.myPoint.col = enter;
            this.performIteration(this.myPoint);
        }
    }

    private int getRowObjective() {
        return this.myPoint.isPhase1() ? this.myTableau.countConstraints() + 1 : this.myTableau.countConstraints();
    }

    private double infeasibility() {
        return -this.myTableau.value(true);
    }

    private boolean isTableauPrintable() {
        return this.myTableau.count() <= 512L;
    }

    private void logDebugTableau(String message) {
        this.log(message + "; Basics: " + Arrays.toString(this.myTableau.getBasis()), this.myTableau);
    }

    private int phase() {
        return this.myPoint.isPhase2() ? 2 : 1;
    }

    private double value() {
        return -this.myTableau.value(false);
    }

    protected Optimisation.Result buildResult() {
        Access1D<?> solution = this.extractSolution();
        double value = this.evaluateFunction(solution);
        Optimisation.State state = this.getState();
        Optimisation.Result result = new Optimisation.Result(state, value, solution);
        if (this.myTableau.isAbleToExtractDual()) {
            return result.multipliers(this.extractMultipliers());
        }
        return result;
    }

    protected double evaluateFunction(Access1D<?> solution) {
        return -this.myTableau.value(false);
    }

    protected Access1D<?> extractMultipliers() {
        final Primitive1D duals = this.myTableau.sliceDualVariables();
        final boolean[] negative = this.myTableau.meta.negatedDual;
        return new Access1D<Double>(){

            @Override
            public long count() {
                return negative.length;
            }

            @Override
            public double doubleValue(long index) {
                int i = Math.toIntExact(index);
                return negative[i] ? -duals.doubleValue(index) : duals.doubleValue(index);
            }

            @Override
            public Double get(long index) {
                return this.doubleValue(index);
            }

            public String toString() {
                return Access1D.toString(this);
            }
        };
    }

    protected Access1D<?> extractSolution() {
        int colRHS = this.myTableau.countVariablesTotally();
        Primitive64Store solution = (Primitive64Store)Primitive64Store.FACTORY.make(this.myTableau.countVariables(), 1);
        int numberOfConstraints = this.myTableau.countConstraints();
        for (int row = 0; row < numberOfConstraints; ++row) {
            int variableIndex = this.myTableau.getBasisColumnIndex(row);
            if (variableIndex < 0) continue;
            solution.set((long)variableIndex, this.myTableau.doubleValue(row, colRHS));
        }
        if (this.myFixedVariables != null) {
            for (SparseArray.NonzeroView entry : this.myFixedVariables.nonzeros()) {
                solution.set(entry.index(), entry.doubleValue());
            }
        }
        return solution;
    }

    protected boolean initialise(Optimisation.Result kickStarter) {
        return false;
    }

    protected boolean needsAnotherIteration() {
        if (this.isLogDebug()) {
            this.log();
            this.log("Needs Another Iteration? Phase={} Artificials={} Infeasibility={} Objective={}", this.phase(), this.myTableau.countBasisDeficit(), this.infeasibility(), this.value());
        }
        boolean retVal = false;
        this.myPoint.reset();
        if (this.myPoint.isPhase1() && (PHASE1.isZero(this.infeasibility()) || !this.myTableau.isBasicArtificials())) {
            this.cleanUpPhase1Artificials();
            if (this.isLogDebug()) {
                this.log();
                this.log("Switching to Phase2 with {} artificial variable(s) still in the basis and infeasibility {}.", this.myTableau.countBasisDeficit(), this.infeasibility());
                this.log();
            }
            this.myPoint.switchToPhase2();
            this.setState(Optimisation.State.FEASIBLE);
        }
        this.myPoint.col = this.findNextPivotCol();
        if (this.myPoint.col >= 0) {
            this.myPoint.row = this.findNextPivotRow();
            if (this.myPoint.row >= 0) {
                retVal = true;
            } else {
                if (this.myPoint.isPhase2()) {
                    this.setState(Optimisation.State.UNBOUNDED);
                } else {
                    this.setState(Optimisation.State.INFEASIBLE);
                }
                retVal = false;
            }
        } else {
            if (this.myPoint.isPhase1()) {
                this.setState(Optimisation.State.INFEASIBLE);
            } else {
                this.setState(Optimisation.State.OPTIMAL);
            }
            retVal = false;
        }
        if (this.isLogDebug()) {
            if (retVal) {
                this.log("\n==>>\tRow: {},\tExit: {},\tColumn/Enter: {}.\n", this.myPoint.row, this.myTableau.getBasisColumnIndex(this.myPoint.row), this.myPoint.col);
            } else {
                this.log("\n==>>\tNo more iterations needed/possible.\n", new Object[0]);
            }
        }
        return retVal;
    }

    protected boolean validate() {
        boolean retVal = true;
        this.setState(Optimisation.State.VALID);
        return retVal;
    }

    int findNextPivotCol() {
        int row = this.getRowObjective();
        boolean phase2 = this.myPoint.isPhase2();
        int nbVariables = this.myTableau.countVariables();
        if (this.isLogDebug()) {
            if (this.options.validate) {
                int[] excluded = this.myTableau.getExcluded();
                Primitive1D sliceTableauRow = this.myTableau.sliceTableauRow(row);
                double[] exclVals = new double[excluded.length];
                for (int i = 0; i < exclVals.length; ++i) {
                    exclVals[i] = sliceTableauRow.doubleValue((long)excluded[i]);
                }
                this.log("\nfindNextPivotCol (index of most negative value) among these:\n{}", Arrays.toString(exclVals));
            } else {
                this.log("\nfindNextPivotCol", new Object[0]);
            }
        }
        int retVal = -1;
        double minVal = phase2 ? -ACC.epsilon() : PrimitiveMath.ZERO;
        for (int j = 0; j < nbVariables; ++j) {
            double tmpVal;
            if (!this.myTableau.isExcluded(j) || !((tmpVal = this.myTableau.doubleValue(row, j)) < minVal) || retVal >= 0 && !WEIGHT.isDifferent(minVal, tmpVal)) continue;
            retVal = j;
            minVal = tmpVal;
            if (!this.isLogDebug()) continue;
            this.log("Col: {}\t=>\tReduced Contribution Weight: {}.", j, tmpVal);
        }
        return retVal;
    }

    int findNextPivotRow() {
        int numerCol = this.myTableau.countVariablesTotally();
        int denomCol = this.myPoint.col;
        boolean phase1 = this.myPoint.isPhase1();
        boolean phase2 = this.myPoint.isPhase2();
        if (this.isLogDebug()) {
            if (this.options.validate) {
                Primitive1D numerators = this.myTableau.sliceBodyColumn(numerCol);
                Primitive1D denominators = this.myTableau.sliceBodyColumn(denomCol);
                Structure1D ratios = Array1D.R064.copy((Access1D)numerators);
                ((Array1D)ratios).modifyMatching(PrimitiveMath.DIVIDE, denominators);
                this.log("\nfindNextPivotRow (smallest positive ratio) among these:\nNumerators={}\nDenominators={}\nRatios={}", numerators, denominators, ratios);
            } else {
                this.log("\nfindNextPivotRow", new Object[0]);
            }
        }
        int retVal = -1;
        double numer = Double.NaN;
        double denom = Double.NaN;
        double ratio = Double.NaN;
        double minRatio = Double.MAX_VALUE;
        double curDenom = Double.MIN_NORMAL;
        int constraintsCount = this.myTableau.countConstraints();
        for (int i = 0; i < constraintsCount; ++i) {
            numer = Math.abs(this.myTableau.doubleValue(i, numerCol));
            denom = this.myTableau.doubleValue(i, denomCol);
            int basisColumnIndex = this.myTableau.getBasisColumnIndex(i);
            boolean artificial = basisColumnIndex < 0;
            boolean degenerate = artificial && DEGENERATE.isZero(numer);
            boolean specialCase = phase2 && degenerate;
            ratio = specialCase ? PrimitiveMath.ZERO : numer / denom;
            if (!(denom > PrimitiveMath.ZERO) && !specialCase || PIVOT.isZero(denom) || !(ratio >= PrimitiveMath.ZERO) || !(ratio < minRatio) && (RATIO.isDifferent(minRatio, ratio) || !(denom > curDenom))) continue;
            retVal = i;
            minRatio = ratio;
            double d = curDenom = degenerate ? Math.max(denom, PrimitiveMath.ONE) : denom;
            if (!this.isLogDebug()) continue;
            this.log("Row: {}\t=>\tRatio: {},\tNumerator/RHS: {}, \tDenominator/Pivot: {},\tArtificial: {}.", i, ratio, numer, denom, artificial);
        }
        return retVal;
    }

    void performIteration(IterationPoint pivot) {
        double tmpPivotElement = this.myTableau.doubleValue(pivot.row, pivot.col);
        int tmpColRHS = this.myTableau.countVariablesTotally();
        double tmpPivotRHS = this.myTableau.doubleValue(pivot.row, tmpColRHS);
        this.myTableau.pivot(pivot);
        if (this.isLogDebug()) {
            this.log("Iteration Point <{},{}>\tPivot: {} => {}\tRHS: {} => {}.", pivot.row, pivot.col, tmpPivotElement, this.myTableau.doubleValue(pivot.row, pivot.col), tmpPivotRHS, this.myTableau.doubleValue(pivot.row, tmpColRHS));
        }
        if (this.isLogDebug() && this.options.validate) {
            Primitive1D colRHS = this.myTableau.sliceConstraintsRHS();
            double minRHS = Double.MAX_VALUE;
            for (int i = 0; i < colRHS.size(); ++i) {
                double tmpRHS = colRHS.doubleValue((long)i);
                if (!(tmpRHS < minRHS) || !((minRHS = tmpRHS) < PrimitiveMath.ZERO)) continue;
                this.log("Negative RHS {} @ Row: {}", minRHS, i);
                this.log();
            }
            if (minRHS < PrimitiveMath.ZERO && !ACC.isZero(minRHS) && this.isLogDebug()) {
                this.log("Entire RHS columns: {}", colRHS);
                this.log();
            }
        }
    }

    static final class IterationPoint {
        private boolean myPhase1 = true;
        int col;
        int row;

        IterationPoint() {
            this.reset();
        }

        boolean isPhase1() {
            return this.myPhase1;
        }

        boolean isPhase2() {
            return !this.myPhase1;
        }

        void reset() {
            this.row = -1;
            this.col = -1;
        }

        void returnToPhase1() {
            this.myPhase1 = true;
        }

        void switchToPhase2() {
            this.myPhase1 = false;
        }
    }
}

